/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.Address;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;

public class MakeConnection
implements IOMRMPart {
    private String namespaceValue = null;
    Identifier identifier = null;
    Address address = null;

    public MakeConnection(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("specDoesNotSupportElement", namespaceValue, "MakeConnection"));
        }
        this.namespaceValue = namespaceValue;
    }

    public void toSOAPEnvelope(SOAPEnvelope envelope) {
        SOAPBody body = envelope.getBody();
        OMElement elem = body.getFirstChildWithName(new QName(this.namespaceValue, "MakeConnection"));
        if (elem != null) {
            elem.detach();
        }
        this.toOMElement((OMElement)body);
    }

    public Object fromOMElement(OMElement makeConnectionElement) throws OMException, AxisFault {
        OMElement identifierElement = makeConnectionElement.getFirstChildWithName(Sandesha2Constants.SPEC_2007_02.QNames.Identifier);
        if (identifierElement == null) {
            identifierElement = makeConnectionElement.getFirstChildWithName(Sandesha2Constants.SPEC_2005_02.QNames.Identifier);
        }
        OMElement addressElement = makeConnectionElement.getFirstChildWithName(new QName(this.namespaceValue, "Address"));
        if (identifierElement == null && addressElement == null) {
            String message = "MakeConnection element should have at lease one of Address and Identifier subelements";
            throw new SandeshaException(message);
        }
        if (identifierElement != null) {
            this.identifier = new Identifier(identifierElement.getNamespace().getNamespaceURI());
            this.identifier.fromOMElement(makeConnectionElement);
        }
        if (addressElement != null) {
            this.address = new Address(this.namespaceValue);
            this.address.fromOMElement(makeConnectionElement);
        }
        return this;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        return "http://docs.oasis-open.org/ws-rx/wsmc/200702".equals(namespaceName);
    }

    public OMElement toOMElement(OMElement body) throws OMException {
        if (body == null || !(body instanceof SOAPBody)) {
            String message = "MakeConnection element can only be added to a SOAP Body ";
            throw new OMException(SandeshaMessageHelper.getMessage(message));
        }
        OMFactory factory = body.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsmc");
        OMElement makeConnectionElement = factory.createOMElement("MakeConnection", rmNamespace);
        if (this.identifier != null) {
            this.identifier.toOMElement(makeConnectionElement);
        }
        if (this.address != null) {
            this.address.toOMElement(makeConnectionElement);
        }
        body.addChild((OMNode)makeConnectionElement);
        return body;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }
}

