/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMElement;

public class Identifier
implements Sandesha2Constants,
IOMRMElement {
    private String identifier = null;
    private String namespaceValue = null;

    public Identifier(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public void setIndentifer(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getNamespaceValue() throws OMException {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement element) throws OMException {
        OMElement identifierPart = element.getFirstChildWithName(new QName(this.namespaceValue, "Identifier"));
        if (identifierPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("invalidIdentifier", element.toString()));
        }
        String identifierText = identifierPart.getText();
        if (identifierText == null || identifierText == "") {
            throw new OMException(SandeshaMessageHelper.getMessage("invalidIdentifier", element.toString()));
        }
        this.identifier = identifierText;
        return this;
    }

    public OMElement toOMElement(OMElement element) throws OMException {
        if (this.identifier == null || this.identifier == "") {
            throw new OMException(SandeshaMessageHelper.getMessage("invalidIdentifier", element.toString()));
        }
        OMFactory factory = element.getOMFactory();
        OMNamespace wsrmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        OMElement identifierElement = factory.createOMElement("Identifier", wsrmNamespace);
        identifierElement.setText(this.identifier);
        element.addChild((OMNode)identifierElement);
        return element;
    }

    public String toString() {
        return this.identifier;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

