/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.MissingResourceException;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;

public class SpecSpecificConstants {
    public static String getSpecVersionString(String namespaceValue) throws SandeshaException {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceValue)) {
            return "Spec_2005_02";
        }
        if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceValue)) {
            return "Spec_2007_02";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
    }

    public static String getRMNamespaceValue(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return "http://schemas.xmlsoap.org/ws/2005/02/rm";
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getCreateSequenceAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return "http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence";
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/CreateSequence";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getCreateSequenceResponseAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return "http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse";
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/CreateSequenceResponse";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getTerminateSequenceAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return "http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence";
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/TerminateSequence";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getTerminateSequenceResponseAction(String specVersion) throws SandeshaException {
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/TerminateSequenceResponse";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec"));
    }

    public static String getCloseSequenceAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("closeSequenceSpecLevel", specVersion));
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/CloseSequence";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getCloseSequenceResponseAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("closeSequenceSpecLevel", specVersion));
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/CloseSequenceResponse";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getAckRequestAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return null;
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/AckRequested";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getSequenceAcknowledgementAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return "http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement";
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/SequenceAcknowledgement";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getMakeConnectionAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            String message = "MakeConnection is not supported in this RM version";
            throw new SandeshaException(message);
        }
        return "http://docs.oasis-open.org/ws-rx/wsmc/200702/MakeConnection";
    }

    public static String getCreateSequenceSOAPAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return "http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence";
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/CreateSequence";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getCreateSequenceResponseSOAPAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return "http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse";
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/CreateSequenceResponse";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getTerminateSequenceSOAPAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return "http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence";
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/TerminateSequence";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getTerminateSequenceResponseSOAPAction(String specVersion) throws SandeshaException {
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/TerminateSequenceResponse";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getAckRequestSOAPAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            throw new SandeshaException("this spec version does not define a ackRequest SOAP action");
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/AckRequested";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getSequenceAcknowledgementSOAPAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return "http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement";
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/SequenceAcknowledgement";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static boolean isTerminateSequenceResponseRequired(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return false;
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return true;
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static boolean isLastMessageIndicatorRequired(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return true;
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return false;
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static boolean isAckFinalAllowed(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return false;
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return true;
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static boolean isAckNoneAllowed(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return false;
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return true;
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static boolean isSequenceClosingAllowed(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return false;
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return true;
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getDefaultSpecVersion() {
        return "Spec_2005_02";
    }

    public static String getAddressingAnonymousURI(String addressingNSURI) throws SandeshaException {
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNSURI)) {
            return "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
        }
        if ("http://www.w3.org/2005/08/addressing".equals(addressingNSURI)) {
            return "http://www.w3.org/2005/08/addressing/anonymous";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownWSAVersion", addressingNSURI));
    }

    public static String getAddressingFaultAction(String specVersion) throws SandeshaException {
        if ("Spec_2005_02".equals(specVersion)) {
            return "http://www.w3.org/2005/08/addressing/fault";
        }
        if ("Spec_2007_02".equals(specVersion)) {
            return "http://docs.oasis-open.org/ws-rx/wsrm/200702/fault";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", specVersion));
    }

    public static String getAddressingNamespace(String rmNamespace) throws SandeshaException {
        if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(rmNamespace)) {
            return "http://www.w3.org/2005/08/addressing";
        }
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(rmNamespace)) {
            return "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownRMNamespace", rmNamespace));
    }

    public static String getSecurityNamespace(String rmNamespace) {
        if (rmNamespace.equals("http://schemas.xmlsoap.org/ws/2005/02/rm")) {
            return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
        }
        if (rmNamespace.equals("http://docs.oasis-open.org/ws-rx/wsrm/200702")) {
            return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
        }
        return null;
    }

    public static AxisOperation getWSRMOperation(int messageType, String rmSpecLevel, AxisService service) throws SandeshaException {
        AxisOperation result = null;
        if ("Spec_2005_02".equals(rmSpecLevel)) {
            switch (messageType) {
                case 1: {
                    result = service.getOperation(Sandesha2Constants.RM_OUT_IN_OPERATION);
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 12: {
                    result = service.getOperation(Sandesha2Constants.RM_OUT_ONLY_OPERATION);
                    break;
                }
                case 13: {
                    result = service.getOperation(Sandesha2Constants.RM_DUPLICATE_IN_ONLY_OPERATION);
                    break;
                }
                case 14: {
                    result = service.getOperation(Sandesha2Constants.RM_DUPLICATE_IN_OUT_OPERATION);
                    break;
                }
                case 15: {
                    result = service.getOperation(Sandesha2Constants.RM_OUT_ONLY_OPERATION);
                }
            }
        } else if ("Spec_2007_02".equals(rmSpecLevel)) {
            switch (messageType) {
                case 1: 
                case 5: 
                case 7: {
                    result = service.getOperation(Sandesha2Constants.RM_OUT_IN_OPERATION);
                    break;
                }
                case 4: 
                case 8: {
                    result = service.getOperation(Sandesha2Constants.RM_OUT_ONLY_OPERATION);
                    break;
                }
                case 15: {
                    result = service.getOperation(Sandesha2Constants.RM_OUT_ONLY_OPERATION);
                }
            }
        }
        if (messageType == 11) {
            result = service.getOperation(Sandesha2Constants.RM_OUT_IN_OPERATION);
        }
        if (result == null) {
            String message = SandeshaMessageHelper.getMessage("couldNotFindOperation", Integer.toString(messageType), rmSpecLevel);
            throw new SandeshaException(message);
        }
        return result;
    }

    public static QName getFaultSubcode(String namespaceValue, int faultType) throws SandeshaException, MissingResourceException {
        QName result = null;
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceValue)) {
            switch (faultType) {
                case 1: {
                    result = Sandesha2Constants.SPEC_2005_02.QNames.UnknownSequence;
                    break;
                }
                case 2: {
                    result = Sandesha2Constants.SPEC_2005_02.QNames.MessageNumberRollover;
                    break;
                }
                case 3: {
                    result = Sandesha2Constants.SPEC_2005_02.QNames.InvalidAcknowledgement;
                    break;
                }
                case 4: {
                    result = Sandesha2Constants.SPEC_2005_02.QNames.CreateSequenceRefused;
                    break;
                }
                case 5: {
                    result = Sandesha2Constants.SPEC_2005_02.QNames.LastMessageNoExceeded;
                    break;
                }
                case 6: {
                    result = Sandesha2Constants.SPEC_2005_02.QNames.SequenceClosed;
                    break;
                }
                case 7: {
                    result = Sandesha2Constants.SPEC_2005_02.QNames.SequenceTerminated;
                }
            }
        } else if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceValue)) {
            switch (faultType) {
                case 1: {
                    result = Sandesha2Constants.SPEC_2007_02.QNames.UnknownSequence;
                    break;
                }
                case 2: {
                    result = Sandesha2Constants.SPEC_2007_02.QNames.MessageNumberRollover;
                    break;
                }
                case 3: {
                    result = Sandesha2Constants.SPEC_2007_02.QNames.InvalidAcknowledgement;
                    break;
                }
                case 4: {
                    result = Sandesha2Constants.SPEC_2007_02.QNames.CreateSequenceRefused;
                    break;
                }
                case 5: {
                    result = Sandesha2Constants.SPEC_2007_02.QNames.LastMessageNoExceeded;
                    break;
                }
                case 6: {
                    result = Sandesha2Constants.SPEC_2007_02.QNames.SequenceClosed;
                    break;
                }
                case 7: {
                    result = Sandesha2Constants.SPEC_2007_02.QNames.SequenceTerminated;
                }
            }
        } else {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        return result;
    }

    public static boolean sendAckInBackChannel(int messageType) {
        boolean result = true;
        switch (messageType) {
            case 12: {
                result = false;
            }
        }
        return result;
    }
}

