/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.OperationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.context.ContextManager;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.transport.Sandesha2TransportOutDesc;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.AcknowledgementRange;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.CloseSequenceResponse;
import org.apache.sandesha2.wsrm.Sequence;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;

public class SandeshaUtil {
    private static Log log = LogFactory.getLog((Class)SandeshaUtil.class);
    private static AxisModule axisModule = null;

    public static AxisModule getAxisModule() {
        return axisModule;
    }

    public static void setAxisModule(AxisModule module) {
        axisModule = module;
    }

    public static String getUUID() {
        String uuid = UUIDGenerator.getUUID();
        return uuid;
    }

    public static ArrayList getAckRangeArrayList(RangeString completedMessageRanges, String rmNamespaceValue) throws SandeshaException {
        ArrayList<AcknowledgementRange> ackRanges = new ArrayList<AcknowledgementRange>();
        Range[] ranges = completedMessageRanges.getRanges();
        for (int i = 0; i < ranges.length; ++i) {
            AcknowledgementRange ackRange = new AcknowledgementRange(rmNamespaceValue);
            ackRange.setLowerValue(ranges[i].lowerValue);
            ackRange.setUpperValue(ranges[i].upperValue);
            ackRanges.add(ackRange);
        }
        return ackRanges;
    }

    public static void startWorkersForSequence(ConfigurationContext context, RMSequenceBean sequence) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: SandeshaUtil::startWorkersForSequence, sequence " + sequence));
        }
        StorageManager mgr = SandeshaUtil.getSandeshaStorageManager(context, (AxisDescription)context.getAxisConfiguration());
        boolean polling = sequence.isPollingMode();
        SandeshaThread sender = mgr.getSender();
        SandeshaThread invoker = mgr.getInvoker();
        PollingManager pollMgr = mgr.getPollingManager();
        if (polling && pollMgr == null) {
            String message = SandeshaMessageHelper.getMessage("makeConnectionDisabled");
            throw new SandeshaException(message);
        }
        if (sequence instanceof RMSBean) {
            String sequenceId = ((RMSBean)sequence).getInternalSequenceID();
            sender.runThreadForSequence(context, sequenceId, true);
            if (polling) {
                pollMgr.runThreadForSequence(context, sequenceId, true);
            }
        } else {
            String sequenceId = sequence.getSequenceID();
            sender.runThreadForSequence(context, sequenceId, false);
            if (invoker != null) {
                invoker.runThreadForSequence(context, sequenceId, false);
            }
            if (polling) {
                pollMgr.runThreadForSequence(context, sequenceId, false);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SandeshaUtil::startWorkersForSequence");
        }
    }

    public static String getMessageTypeString(int messageType) {
        switch (messageType) {
            case 1: {
                return "CreateSequence";
            }
            case 2: {
                return "CreateSequenceResponse";
            }
            case 4: {
                return "Acknowledgement";
            }
            case 3: {
                return "Application";
            }
            case 7: {
                return "TerminateSequence";
            }
            case 8: {
                return "AckRequest";
            }
            case 5: {
                return "CloseSequence";
            }
            case 6: {
                return "CloseSequenceResponse";
            }
            case 9: {
                return "TerminateSequenceResponse";
            }
            case 10: {
                return "Fault";
            }
            case 11: {
                return "MakeConnection";
            }
            case 0: {
                return "Unknown";
            }
        }
        return "Error";
    }

    public static String getServerSideIncomingSeqIdFromInternalSeqId(String internalSequenceId) throws SandeshaException {
        String startStr = "Sandesha2InternalSequence:";
        if (!internalSequenceId.startsWith(startStr)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("invalidInternalSequenceID", internalSequenceId));
        }
        String incomingSequenceId = internalSequenceId.substring(startStr.length());
        return incomingSequenceId;
    }

    public static StorageManager getSandeshaStorageManager(ConfigurationContext context, AxisDescription description) throws SandeshaException {
        String value;
        Parameter parameter = description.getParameter("Sandesha2StorageManager");
        if (parameter == null) {
            parameter = new Parameter("Sandesha2StorageManager", (Object)"inmemory");
        }
        if ("inmemory".equals(value = (String)parameter.getValue())) {
            return SandeshaUtil.getInMemoryStorageManager(context);
        }
        if ("persistent".equals(value)) {
            return SandeshaUtil.getPermanentStorageManager(context);
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotGetStorageManager"));
    }

    public static StorageManager getInMemoryStorageManager(ConfigurationContext context) throws SandeshaException {
        StorageManager inMemoryStorageManager = null;
        AxisConfiguration config = context.getAxisConfiguration();
        Parameter parameter = config.getParameter("inmemory");
        if (parameter != null) {
            inMemoryStorageManager = (StorageManager)parameter.getValue();
        }
        if (inMemoryStorageManager != null) {
            return inMemoryStorageManager;
        }
        try {
            String storageManagerClassStr = SandeshaUtil.getDefaultPropertyBean(context.getAxisConfiguration()).getInMemoryStorageManagerClass();
            inMemoryStorageManager = SandeshaUtil.getStorageManagerInstance(storageManagerClassStr, context);
            parameter = new Parameter("inmemory", (Object)inMemoryStorageManager);
            config.addParameter(parameter);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitInMemoryStorageManager", e.toString());
            throw new SandeshaException(message, (Exception)((Object)e));
        }
        return inMemoryStorageManager;
    }

    public static StorageManager getPermanentStorageManager(ConfigurationContext context) throws SandeshaException {
        StorageManager permanentStorageManager = null;
        AxisConfiguration config = context.getAxisConfiguration();
        Parameter parameter = config.getParameter("persistent");
        if (parameter != null) {
            permanentStorageManager = (StorageManager)parameter.getValue();
        }
        if (permanentStorageManager != null) {
            return permanentStorageManager;
        }
        try {
            String storageManagerClassStr = SandeshaUtil.getDefaultPropertyBean(context.getAxisConfiguration()).getPermanentStorageManagerClass();
            permanentStorageManager = SandeshaUtil.getStorageManagerInstance(storageManagerClassStr, context);
            parameter = new Parameter("persistent", (Object)permanentStorageManager);
            config.addParameter(parameter);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitPersistentStorageManager", e.toString());
            throw new SandeshaException(message, (Exception)((Object)e));
        }
        return permanentStorageManager;
    }

    private static StorageManager getStorageManagerInstance(String className, ConfigurationContext context) throws SandeshaException {
        StorageManager storageManager = null;
        try {
            StorageManager mgr;
            Class<?> configContextClass;
            ClassLoader classLoader = null;
            AxisConfiguration config = context.getAxisConfiguration();
            Parameter classLoaderParam = config.getParameter("Sandesha2ModuleClassLoader");
            if (classLoaderParam != null) {
                classLoader = (ClassLoader)classLoaderParam.getValue();
            }
            if (classLoader == null) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("classLoaderNotFound"));
            }
            Class<?> c = classLoader.loadClass(className);
            Constructor<?> constructor = c.getConstructor(configContextClass = context.getClass());
            Object obj = constructor.newInstance(context);
            if (obj == null || !(obj instanceof StorageManager)) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("storageManagerMustImplement"));
            }
            storageManager = mgr = (StorageManager)obj;
            return storageManager;
        }
        catch (Exception e) {
            String message = SandeshaMessageHelper.getMessage("cannotGetStorageManager");
            if (log.isErrorEnabled()) {
                log.error((Object)message, (Throwable)e);
            }
            throw new SandeshaException(message, e);
        }
    }

    public static int getSOAPVersion(SOAPEnvelope envelope) throws SandeshaException {
        String namespaceName = envelope.getNamespace().getNamespaceURI();
        if (namespaceName.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            return 1;
        }
        if (namespaceName.equals("http://www.w3.org/2003/05/soap-envelope")) {
            return 2;
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSoapVersion", namespaceName));
    }

    public static MessageContext createNewRelatedMessageContext(RMMsgContext referenceRMMessage, AxisOperation operation) throws SandeshaException {
        try {
            MessageContext referenceMessage = referenceRMMessage.getMessageContext();
            ConfigurationContext configContext = referenceMessage.getConfigurationContext();
            AxisConfiguration axisConfiguration = configContext.getAxisConfiguration();
            MessageContext newMessageContext = new MessageContext();
            newMessageContext.setConfigurationContext(configContext);
            Options oldOptions = referenceMessage.getOptions();
            Options newOptions = new Options();
            newOptions.setProperties(oldOptions.getProperties());
            newMessageContext.setOptions(newOptions);
            if (referenceMessage.getAxisServiceGroup() != null) {
                newMessageContext.setAxisServiceGroup(referenceMessage.getAxisServiceGroup());
                if (referenceMessage.getServiceGroupContext() != null) {
                    newMessageContext.setServiceGroupContext(referenceMessage.getServiceGroupContext());
                    newMessageContext.setServiceGroupContextId(referenceMessage.getServiceGroupContextId());
                } else {
                    ServiceGroupContext serviceGroupContext = new ServiceGroupContext(configContext, referenceMessage.getAxisServiceGroup());
                    newMessageContext.setServiceGroupContext(serviceGroupContext);
                }
            } else {
                AxisServiceGroup axisServiceGroup = new AxisServiceGroup(axisConfiguration);
                ServiceGroupContext serviceGroupContext = new ServiceGroupContext(configContext, axisServiceGroup);
                newMessageContext.setAxisServiceGroup(axisServiceGroup);
                newMessageContext.setServiceGroupContext(serviceGroupContext);
            }
            if (referenceMessage.getAxisService() != null) {
                newMessageContext.setAxisService(referenceMessage.getAxisService());
                if (referenceMessage.getServiceContext() != null) {
                    newMessageContext.setServiceContext(referenceMessage.getServiceContext());
                    newMessageContext.setServiceContextID(referenceMessage.getServiceContextID());
                } else {
                    ServiceGroupContext sgc = newMessageContext.getServiceGroupContext();
                    ServiceContext serviceContext = sgc.getServiceContext(referenceMessage.getAxisService());
                    newMessageContext.setServiceContext(serviceContext);
                }
            }
            newMessageContext.setAxisOperation(operation);
            newMessageContext.setAxisMessage(operation.getMessage("Out"));
            OperationContext operationContext = OperationContextFactory.createOperationContext((int)operation.getAxisSpecificMEPConstant(), (AxisOperation)operation, (ServiceContext)newMessageContext.getServiceContext());
            newMessageContext.setOperationContext(operationContext);
            operationContext.addMessageContext(newMessageContext);
            SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(referenceMessage.getEnvelope()));
            newMessageContext.setEnvelope(factory.getDefaultEnvelope());
            newMessageContext.setTransportIn(referenceMessage.getTransportIn());
            newMessageContext.setTransportOut(referenceMessage.getTransportOut());
            newMessageContext.setProperty("TRANSPORT_OUT", referenceMessage.getProperty("TRANSPORT_OUT"));
            newMessageContext.setProperty("OutTransportInfo", referenceMessage.getProperty("OutTransportInfo"));
            newMessageContext.setProperty("TRANSPORT_HEADERS", referenceMessage.getProperty("TRANSPORT_HEADERS"));
            newMessageContext.setProperty("TRANSPORT_IN", referenceMessage.getProperty("TRANSPORT_IN"));
            newMessageContext.setProperty("TRANSPORT_OUT", referenceMessage.getProperty("TRANSPORT_OUT"));
            newMessageContext.setProperty("WSAddressingVersion", referenceMessage.getProperty("WSAddressingVersion"));
            newMessageContext.setProperty("disableAddressingForOutMessages", referenceMessage.getProperty("disableAddressingForOutMessages"));
            SandeshaUtil.copyConfiguredProperties(referenceMessage, newMessageContext);
            newMessageContext.setServerSide(referenceMessage.isServerSide());
            if (oldOptions != null) {
                newOptions.setUseSeparateListener(oldOptions.isUseSeparateListener());
            }
            return newMessageContext;
        }
        catch (AxisFault e) {
            log.debug((Object)e.getMessage());
            throw new SandeshaException(e.getMessage());
        }
    }

    private static void copyConfiguredProperties(MessageContext fromMessage, MessageContext toMessage) throws AxisFault {
        String value;
        String value2;
        if (axisModule == null) {
            String message = "moduleNotSet";
            throw new SandeshaException(message);
        }
        Parameter propertiesFromRefMsg = axisModule.getParameter("propertiesToCopyFromReferenceMessage");
        if (propertiesFromRefMsg != null && (value2 = (String)propertiesFromRefMsg.getValue()) != null) {
            value2 = value2.trim();
            String[] propertyNames = value2.split(",");
            for (int i = 0; i < propertyNames.length; ++i) {
                String tmp = propertyNames[i];
                String propertyName = null;
                String targetPropertyName = null;
                if (tmp.indexOf(":") >= 0) {
                    String[] vals = tmp.split(":");
                    propertyName = vals[0].trim();
                    targetPropertyName = vals[1].trim();
                } else {
                    propertyName = targetPropertyName = tmp;
                }
                Object val = fromMessage.getProperty(propertyName);
                if (val == null) continue;
                toMessage.setProperty(targetPropertyName, val);
            }
        }
        Parameter propertiesFromRefReqMsg = axisModule.getParameter("propertiesToCopyFromReferenceRequestMessage");
        OperationContext referenceOpCtx = fromMessage.getOperationContext();
        MessageContext referenceRequestMessage = null;
        if (referenceOpCtx != null) {
            referenceRequestMessage = referenceOpCtx.getMessageContext("In");
        }
        if (propertiesFromRefReqMsg != null && referenceRequestMessage != null && (value = (String)propertiesFromRefReqMsg.getValue()) != null) {
            value = value.trim();
            String[] propertyNames = value.split(",");
            for (int i = 0; i < propertyNames.length; ++i) {
                String propertyName = propertyNames[i];
                Object val = referenceRequestMessage.getProperty(propertyName);
                if (val == null) continue;
                toMessage.setProperty(propertyName, val);
            }
        }
    }

    public static SandeshaPolicyBean getDefaultPropertyBean(AxisConfiguration axisConfiguration) throws SandeshaException {
        Parameter parameter = axisConfiguration.getParameter("Sandesha2PropertyBean");
        if (parameter == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("defaultPropertyBeanNotSet"));
        }
        SandeshaPolicyBean sandeshaPropertyBean = (SandeshaPolicyBean)parameter.getValue();
        return sandeshaPropertyBean;
    }

    public static ArrayList getArrayListFromString(String str) {
        if (str == null || "".equals(str)) {
            return new ArrayList();
        }
        if (str.length() < 2) {
            String message = SandeshaMessageHelper.getMessage("invalidStringArray", str);
            log.debug((Object)message);
            throw new IllegalArgumentException(message);
        }
        int length = str.length();
        if (str.charAt(0) != '[' || str.charAt(length - 1) != ']') {
            String message = SandeshaMessageHelper.getMessage("invalidStringArray", str);
            log.debug((Object)message);
            throw new IllegalArgumentException(message);
        }
        ArrayList<String> retArr = new ArrayList<String>();
        String subStr = str.substring(1, length - 1);
        String[] parts = subStr.split(",");
        for (int i = 0; i < parts.length; ++i) {
            if ("".equals(parts[i])) continue;
            retArr.add(parts[i].trim());
        }
        return retArr;
    }

    public static String getInternalSequenceID(String to, String sequenceKey) {
        if (to == null && sequenceKey == null) {
            return null;
        }
        if (to == null) {
            return sequenceKey;
        }
        if (sequenceKey == null) {
            return to;
        }
        return "Sandesha2InternalSequence:" + to + ":" + sequenceKey;
    }

    public static String getOutgoingSideInternalSequenceID(String sequenceID) {
        return "Sandesha2InternalSequence:" + sequenceID;
    }

    public static final RMSBean getRMSBeanFromInternalSequenceId(StorageManager storageManager, String internalSequenceID) throws SandeshaException {
        RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
        RMSBean bean = new RMSBean();
        bean.setInternalSequenceID(internalSequenceID);
        bean = rmsBeanMgr.findUnique(bean);
        return bean;
    }

    public static final RMSBean getRMSBeanFromSequenceId(StorageManager storageManager, String sequenceID) throws SandeshaException {
        RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
        RMSBean bean = new RMSBean();
        bean.setSequenceID(sequenceID);
        bean = rmsBeanMgr.findUnique(bean);
        return bean;
    }

    public static RMDBean getRMDBeanFromSequenceId(StorageManager storageManager, String sequenceID) throws SandeshaException {
        RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
        RMDBean bean = new RMDBean();
        bean.setSequenceID(sequenceID);
        bean = rmdBeanMgr.findUnique(bean);
        return bean;
    }

    public static String getSequenceIDFromInternalSequenceID(String internalSequenceID, StorageManager storageManager) throws SandeshaException {
        RMSBean rMSBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceID);
        String sequeunceID = null;
        if (rMSBean != null && rMSBean.getSequenceID() != null && !rMSBean.getSequenceID().equals("uuid:tempID")) {
            sequeunceID = rMSBean.getSequenceID();
        }
        return sequeunceID;
    }

    public static String getExecutionChainString(ArrayList executionChain) {
        Iterator iter = executionChain.iterator();
        String executionChainStr = "";
        while (iter.hasNext()) {
            Handler handler = (Handler)iter.next();
            String name = handler.getName();
            executionChainStr = executionChainStr + "." + name;
        }
        return executionChainStr;
    }

    public static boolean isAllMsgsAckedUpto(long highestInMsgNo, String internalSequenceId, StorageManager storageManager) throws SandeshaException {
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
        RangeString ackedMsgRanges = rmsBean.getClientCompletedMessages();
        long smallestMsgNo = 1L;
        Range interestedRange = new Range(smallestMsgNo, highestInMsgNo);
        boolean allComplete = false;
        if (ackedMsgRanges != null && ackedMsgRanges.isRangeCompleted(interestedRange)) {
            allComplete = true;
        }
        return allComplete;
    }

    public static SandeshaPolicyBean getPropertyBean(AxisDescription axisDescription) throws SandeshaException {
        Parameter parameter = axisDescription.getParameter("Sandesha2PropertyBean");
        if (parameter == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("propertyBeanNotSet"));
        }
        SandeshaPolicyBean propertyBean = (SandeshaPolicyBean)parameter.getValue();
        if (propertyBean == null) {
            String message = SandeshaMessageHelper.getMessage("policyBeanNotFound");
            throw new SandeshaException(message);
        }
        return propertyBean;
    }

    public static String getSequenceIDFromRMMessage(RMMsgContext rmMessageContext) throws SandeshaException {
        int messageType = rmMessageContext.getMessageType();
        String sequenceID = null;
        if (messageType == 3) {
            Sequence sequence = (Sequence)rmMessageContext.getMessagePart(6);
            sequenceID = sequence.getIdentifier().getIdentifier();
        } else if (messageType == 4) {
            Iterator sequenceAckIter = rmMessageContext.getMessageParts(7);
            SequenceAcknowledgement sequenceAcknowledgement = (SequenceAcknowledgement)sequenceAckIter.next();
            sequenceID = sequenceAcknowledgement.getIdentifier().getIdentifier();
        } else if (messageType == 8) {
            Iterator ackRequestIter = rmMessageContext.getMessageParts(15);
            AckRequested ackReq = (AckRequested)ackRequestIter.next();
            sequenceID = ackReq.getIdentifier().getIdentifier();
        } else if (messageType == 5) {
            CloseSequence closeSequence = (CloseSequence)rmMessageContext.getMessagePart(12);
            sequenceID = closeSequence.getIdentifier().getIdentifier();
        } else if (messageType == 6) {
            CloseSequenceResponse closeSequenceResponse = (CloseSequenceResponse)rmMessageContext.getMessagePart(13);
            sequenceID = closeSequenceResponse.getIdentifier().getIdentifier();
        }
        return sequenceID;
    }

    public static String getSequenceKeyFromInternalSequenceID(String internalSequenceID, String to) {
        String toEPRString;
        String postPrefixString;
        int indexOfToEPR;
        if (to == null) {
            return internalSequenceID;
        }
        int postPrefixStringIndex = internalSequenceID.indexOf("Sandesha2InternalSequence");
        if (postPrefixStringIndex >= 0 && (indexOfToEPR = (postPrefixString = internalSequenceID.substring(postPrefixStringIndex + "Sandesha2InternalSequence".length())).indexOf(toEPRString = ":" + to + ":")) >= 0) {
            return postPrefixString.substring(indexOfToEPR + toEPRString.length());
        }
        return null;
    }

    public static SecurityManager getSecurityManager(ConfigurationContext context) throws SandeshaException {
        SecurityManager util = null;
        AxisConfiguration config = context.getAxisConfiguration();
        Parameter p = config.getParameter("Sandesha2SecurityManager");
        if (p != null) {
            util = (SecurityManager)p.getValue();
        }
        if (util != null) {
            return util;
        }
        try {
            String securityManagerClassStr = SandeshaUtil.getDefaultPropertyBean(context.getAxisConfiguration()).getSecurityManagerClass();
            util = SandeshaUtil.getSecurityManagerInstance(securityManagerClassStr, context);
            p = new Parameter("Sandesha2SecurityManager", (Object)util);
            config.addParameter(p);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitSecurityManager", e.toString());
            throw new SandeshaException(message, (Exception)((Object)e));
        }
        return util;
    }

    private static SecurityManager getSecurityManagerInstance(String className, ConfigurationContext context) throws SandeshaException {
        try {
            ClassLoader classLoader = null;
            AxisConfiguration config = context.getAxisConfiguration();
            Parameter classLoaderParam = config.getParameter("Sandesha2ModuleClassLoader");
            if (classLoaderParam != null) {
                classLoader = (ClassLoader)classLoaderParam.getValue();
            }
            if (classLoader == null) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("classLoaderNotFound"));
            }
            Class<?> c = classLoader.loadClass(className);
            Class<?> configContextClass = context.getClass();
            Constructor<?> constructor = c.getConstructor(configContextClass);
            Object obj = constructor.newInstance(context);
            if (!(obj instanceof SecurityManager)) {
                String message = SandeshaMessageHelper.getMessage("securityManagerMustImplement", className);
                throw new SandeshaException(message);
            }
            return (SecurityManager)obj;
        }
        catch (Exception e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitSecurityManager", e.toString());
            throw new SandeshaException(message, e);
        }
    }

    public static ContextManager getContextManager(ConfigurationContext context) throws SandeshaException {
        ContextManager mgr = null;
        AxisConfiguration config = context.getAxisConfiguration();
        Parameter p = config.getParameter("Sandesha2ContextManager");
        if (p != null) {
            mgr = (ContextManager)p.getValue();
        }
        if (mgr != null) {
            return mgr;
        }
        try {
            String securityManagerClassStr = SandeshaUtil.getDefaultPropertyBean(context.getAxisConfiguration()).getContextManagerClass();
            mgr = SandeshaUtil.getContextManagerInstance(securityManagerClassStr, context);
            p = new Parameter("Sandesha2ContextManager", (Object)mgr);
            config.addParameter(p);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitContextManager", e.toString());
            throw new SandeshaException(message, (Exception)((Object)e));
        }
        return mgr;
    }

    private static ContextManager getContextManagerInstance(String className, ConfigurationContext context) throws SandeshaException {
        try {
            ClassLoader classLoader = null;
            AxisConfiguration config = context.getAxisConfiguration();
            Parameter classLoaderParam = config.getParameter("Sandesha2ModuleClassLoader");
            if (classLoaderParam != null) {
                classLoader = (ClassLoader)classLoaderParam.getValue();
            }
            if (classLoader == null) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("classLoaderNotFound"));
            }
            Class<?> c = classLoader.loadClass(className);
            Class<?> configContextClass = context.getClass();
            Constructor<?> constructor = c.getConstructor(configContextClass);
            Object obj = constructor.newInstance(context);
            if (!(obj instanceof ContextManager)) {
                String message = SandeshaMessageHelper.getMessage("contextManagerMustImplement", className);
                throw new SandeshaException(message);
            }
            return (ContextManager)obj;
        }
        catch (Exception e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitContextManager", e.toString());
            throw new SandeshaException(message, e);
        }
    }

    public static boolean isWSRMAnonymous(String address) {
        return address != null && address.startsWith("http://docs.oasis-open.org/ws-rx/wsmc/200702/anonymous?id=");
    }

    public static void executeAndStore(RMMsgContext rmMsgContext, String storageKey) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: SandeshaUtil::executeAndStore, " + storageKey));
        }
        MessageContext msgContext = rmMsgContext.getMessageContext();
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        SandeshaPolicyBean policy = SandeshaUtil.getPropertyBean((AxisDescription)msgContext.getAxisOperation());
        if (policy.isUseMessageSerialization()) {
            msgContext.setProperty("Sandesha2QualifiedForSending", (Object)"true");
            StorageManager store = SandeshaUtil.getSandeshaStorageManager(configurationContext, (AxisDescription)configurationContext.getAxisConfiguration());
            store.storeMessageContext(storageKey, msgContext);
        } else {
            msgContext.setProperty("Sandesha2MessageStoreKey", (Object)storageKey);
            TransportOutDescription transportOut = msgContext.getTransportOut();
            msgContext.setProperty("Sandesha2OriginalTransportSender", (Object)transportOut);
            msgContext.setProperty("Sandesha2SetSendToTrue", (Object)"true");
            Sandesha2TransportOutDesc sandesha2TransportOutDesc = new Sandesha2TransportOutDesc();
            msgContext.setTransportOut((TransportOutDescription)sandesha2TransportOutDesc);
            if (msgContext.isPaused()) {
                AxisEngine.resumeSend((MessageContext)msgContext);
            } else {
                Boolean isTransportNonBlocking = (Boolean)msgContext.getProperty("transportNonBlocking");
                if (isTransportNonBlocking != null && isTransportNonBlocking.booleanValue()) {
                    msgContext.setProperty("transportNonBlocking", (Object)Boolean.FALSE);
                }
                AxisEngine.send((MessageContext)msgContext);
                msgContext.setProperty("transportNonBlocking", (Object)isTransportNonBlocking);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SandeshaUtil::executeAndStore");
        }
    }

    public static void modifyExecutionChainForStoring(MessageContext message) throws SandeshaException {
        Object property = message.getProperty("RMRetransmittablePhases");
        if (property != null) {
            return;
        }
        SandeshaPolicyBean policy = SandeshaUtil.getPropertyBean((AxisDescription)message.getAxisOperation());
        if (policy.isUseMessageSerialization()) {
            return;
        }
        TransportOutDescription transportOutDescription = message.getTransportOut();
        if (!(transportOutDescription instanceof Sandesha2TransportOutDesc)) {
            return;
        }
        ArrayList executionChain = message.getExecutionChain();
        ArrayList retransmittablePhaseNames = SandeshaUtil.getRetransmittablePhaseNameList();
        ArrayList<Handler> retransmittablePhases = new ArrayList<Handler>();
        Iterator it = executionChain.iterator();
        while (it.hasNext()) {
            Handler handler = (Handler)it.next();
            if (!retransmittablePhaseNames.contains(handler.getName())) continue;
            retransmittablePhases.add(handler);
            it.remove();
        }
        message.setProperty("RMRetransmittablePhases", retransmittablePhases);
    }

    private static ArrayList getRetransmittablePhaseNameList() {
        String security = "Security";
        ArrayList<String> phases = new ArrayList<String>();
        phases.add(security);
        return phases;
    }

    public static MessageContext cloneMessageContext(MessageContext oldMsg) throws AxisFault {
        MessageContext newMsg = new MessageContext();
        newMsg.setOptions(new Options(oldMsg.getOptions()));
        OMElement newElement = oldMsg.getEnvelope().cloneOMElement();
        String elementString = newElement.toString();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(elementString.getBytes("UTF8"));
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(XMLInputFactory.newInstance().createXMLStreamReader(stream), null);
            SOAPEnvelope envelope = builder.getSOAPEnvelope();
            newMsg.setEnvelope(envelope);
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        newMsg.setConfigurationContext(oldMsg.getConfigurationContext());
        newMsg.setAxisService(oldMsg.getAxisService());
        newMsg.setTransportOut(oldMsg.getTransportOut());
        newMsg.setTransportIn(oldMsg.getTransportIn());
        SandeshaUtil.copyConfiguredProperties(oldMsg, newMsg);
        return newMsg;
    }

    public static SOAPEnvelope removeMustUnderstand(SOAPEnvelope envelope) {
        SOAPHeader header;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SandeshaUtil::removeMustUnderstand");
        }
        if ((header = envelope.getHeader()) != null) {
            Iterator childrenOfOldEnv = header.getChildElements();
            while (childrenOfOldEnv.hasNext()) {
                SOAPHeaderBlock oldEnvHeaderBlock = (SOAPHeaderBlock)childrenOfOldEnv.next();
                QName oldEnvHeaderBlockQName = oldEnvHeaderBlock.getQName();
                if (oldEnvHeaderBlockQName == null || !oldEnvHeaderBlock.isProcessed() || !oldEnvHeaderBlock.getMustUnderstand()) continue;
                oldEnvHeaderBlock.setMustUnderstand(false);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SandeshaUtil::removeMustUnderstand");
        }
        return envelope;
    }

    public static EndpointReference cloneEPR(EndpointReference epr) {
        EndpointReference newEPR = new EndpointReference(epr.getAddress());
        Map referenceParams = epr.getAllReferenceParameters();
        if (referenceParams != null) {
            Iterator keys = referenceParams.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                Object referenceParam = referenceParams.get(key);
                if (!(referenceParam instanceof OMElement)) continue;
                OMElement clonedElement = ((OMElement)referenceParam).cloneOMElement();
                clonedElement.setText("false");
                newEPR.addReferenceParameter(clonedElement);
            }
        }
        return newEPR;
    }

    public static boolean isMessageUnreliable(MessageContext mc) {
        Parameter unreliableParam;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry: SandeshaUtil::isMessageUnreliable");
        }
        boolean result = false;
        String unreliable = (String)mc.getProperty(SandeshaClientConstants.UNRELIABLE_MESSAGE);
        if ("true".equals(unreliable)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unreliable message context");
            }
            result = true;
        }
        if (!result && mc.getAxisOperation() != null && null != (unreliableParam = mc.getAxisOperation().getParameter(SandeshaClientConstants.UNRELIABLE_MESSAGE)) && "true".equals(unreliableParam.getValue())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unreliable operation");
            }
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SandeshaUtil::isMessageUnreliable, " + result));
        }
        return result;
    }

    public static boolean isDuplicateInOnlyMessage(MessageContext msgContext) {
        AxisOperation operation = msgContext.getAxisOperation();
        String localName = operation.getName().getLocalPart();
        return localName.equals(Sandesha2Constants.RM_DUPLICATE_IN_ONLY_OPERATION.getLocalPart());
    }

    public static boolean isDuplicateInOutMessage(MessageContext msgContext) {
        AxisOperation operation = msgContext.getAxisOperation();
        String localName = operation.getName().getLocalPart();
        return localName.equals(Sandesha2Constants.RM_DUPLICATE_IN_OUT_OPERATION.getLocalPart());
    }

    public static SOAPEnvelope cloneEnvelope(SOAPEnvelope envelope) throws SandeshaException {
        XMLStreamReader streamReader = envelope.cloneOMElement().getXMLStreamReader();
        SOAPEnvelope clonedEnvelope = new StAXSOAPModelBuilder(streamReader, null).getSOAPEnvelope();
        SOAPHeader header = envelope.getHeader();
        if (header != null) {
            Iterator childrenOfOldEnv = header.getChildElements();
            Iterator childrenOfNewEnv = clonedEnvelope.getHeader().getChildElements();
            while (childrenOfOldEnv.hasNext()) {
                SOAPHeaderBlock oldEnvHeaderBlock = (SOAPHeaderBlock)childrenOfOldEnv.next();
                SOAPHeaderBlock newEnvHeaderBlock = (SOAPHeaderBlock)childrenOfNewEnv.next();
                QName oldEnvHeaderBlockQName = oldEnvHeaderBlock.getQName();
                if (oldEnvHeaderBlockQName == null) continue;
                if (oldEnvHeaderBlockQName.equals(newEnvHeaderBlock.getQName())) {
                    if (!oldEnvHeaderBlock.isProcessed()) continue;
                    newEnvHeaderBlock.setProcessed();
                    continue;
                }
                String message = SandeshaMessageHelper.getMessage("cloneDoesNotMatchToOriginal");
                throw new SandeshaException(message);
            }
        }
        return clonedEnvelope;
    }

    public static final String getStackTraceFromException(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        e.printStackTrace(pw);
        pw.flush();
        String stackTrace = baos.toString();
        return stackTrace;
    }

    public static EndpointReference rewriteEPR(RMSBean sourceBean, EndpointReference epr, ConfigurationContext configContext) throws SandeshaException {
        String address;
        SandeshaPolicyBean policy;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: SandeshaUtil::rewriteEPR " + epr));
        }
        if (!(policy = SandeshaUtil.getPropertyBean((AxisDescription)configContext.getAxisConfiguration())).isEnableRMAnonURI()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: SandeshaUtil::rewriteEPR, anon uri is disabled");
            }
            return epr;
        }
        if (epr == null) {
            epr = new EndpointReference(null);
        }
        if ((address = epr.getAddress()) == null || "http://www.w3.org/2005/08/addressing/anonymous".equals(address) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(address)) {
            String uuid = sourceBean.getAnonymousUUID();
            if (uuid == null) {
                uuid = "http://docs.oasis-open.org/ws-rx/wsmc/200702/anonymous?id=" + SandeshaUtil.getUUID();
                sourceBean.setAnonymousUUID(uuid);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rewriting EPR with anon URI " + uuid));
            }
            epr.setAddress(uuid);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SandeshaUtil::rewriteEPR " + epr));
        }
        return epr;
    }
}

