/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.util.SandeshaUtil;

public class PropertyManager {
    public static void loadPropertiesFromDefaultValues(SandeshaPolicyBean propertyBean) {
        propertyBean.setAcknowledgementInterval(3000L);
        propertyBean.setExponentialBackoff(true);
        propertyBean.setInactiveTimeoutInterval(-1L, "seconds");
        propertyBean.setSequenceRemovalTimeoutInterval(-1L, "seconds");
        propertyBean.setInOrder(true);
        propertyBean.setMsgTypesToDrop(null);
        propertyBean.setRetransmissionInterval(6000L);
        propertyBean.setInMemoryStorageManagerClass("org.apache.sandesha2.storage.inmemory.InMemoryStorageManager");
        propertyBean.setPermanentStorageManagerClass("org.apache.sandesha2.storage.inmemory.InMemoryStorageManager");
        propertyBean.setMaximumRetransmissionCount(10);
        String msgTypesToDrop = "none";
        PropertyManager.loadMessageTypesToDrop(msgTypesToDrop, propertyBean);
        propertyBean.setSecurityManagerClass("org.apache.sandesha2.security.dummy.DummySecurityManager");
        propertyBean.setContextManagerClass("org.apache.sandesha2.context.DummyContextManager");
        propertyBean.setEnableMakeConnection(true);
        propertyBean.setEnableRMAnonURI(true);
        propertyBean.setUseMessageSerialization(false);
        propertyBean.setEnforceRM(false);
    }

    public static SandeshaPolicyBean loadPropertiesFromPropertyFile(InputStream in) throws SandeshaException {
        SandeshaPolicyBean propertyBean = new SandeshaPolicyBean();
        try {
            if (in == null) {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream("sandesha2.properties");
            }
            Properties properties = new Properties();
            if (in != null) {
                properties.load(in);
            }
            String expoBackoffStr = properties.getProperty("ExponentialBackoff");
            PropertyManager.loadExponentialBackoff(expoBackoffStr, propertyBean);
            String retransmissionIntStr = properties.getProperty("RetransmissionInterval");
            PropertyManager.loadRetransmissionInterval(retransmissionIntStr, propertyBean);
            String acknowledgementIntStr = properties.getProperty("AcknowledgementInterval");
            PropertyManager.loadAcknowledgementInterval(acknowledgementIntStr, propertyBean);
            String inactivityTimeoutStr = properties.getProperty("InactivityTimeout");
            String inactivityTimeoutMeasure = properties.getProperty("InactivityTimeoutMeasure");
            PropertyManager.loadInactivityTimeout(inactivityTimeoutStr, inactivityTimeoutMeasure, propertyBean);
            String sequenceRemovalTimeoutStr = properties.getProperty("SequenceRemovalTimeout");
            String sequenceRemovalTimeoutMeasure = properties.getProperty("SequenceRemovalTimeoutMeasure");
            PropertyManager.loadSequenceRemovalTimeout(sequenceRemovalTimeoutStr, sequenceRemovalTimeoutMeasure, propertyBean);
            String inMemoryStorageMgrClassStr = properties.getProperty("InMemoryStorageManager");
            PropertyManager.loadInMemoryStoragemanagerClass(inMemoryStorageMgrClassStr, propertyBean);
            String permanentStorageMgrClassStr = properties.getProperty("PermanentStorageManager");
            PropertyManager.loadPermanentStoragemanagerClass(permanentStorageMgrClassStr, propertyBean);
            String inOrderInvocation = properties.getProperty("InvokeInOrder");
            PropertyManager.loadInOrderInvocation(inOrderInvocation, propertyBean);
            String enableMakeConnection = properties.getProperty("EnableMakeConnection");
            PropertyManager.loadEnableMakeConnection(enableMakeConnection, propertyBean);
            String useSerlialization = properties.getProperty("UseMessageSerialization");
            PropertyManager.loadUseSerialization(useSerlialization, propertyBean);
            String messageTypesToDrop = properties.getProperty("MessageTypesToDrop");
            PropertyManager.loadMessageTypesToDrop(messageTypesToDrop, propertyBean);
            String securityManagerClassStr = properties.getProperty("SecurityManager");
            PropertyManager.loadSecurityManagerClass(securityManagerClassStr, propertyBean);
            String contextManagerClassStr = properties.getProperty("ContextManager");
            PropertyManager.loadContextManagerClass(contextManagerClassStr, propertyBean);
        }
        catch (IOException e) {
            throw new SandeshaException(e);
        }
        return propertyBean;
    }

    public static SandeshaPolicyBean loadPropertiesFromModuleDesc(AxisModule desc) throws SandeshaException {
        SandeshaPolicyBean propertyBean = new SandeshaPolicyBean();
        Parameter expoBackoffParam = desc.getParameter("ExponentialBackoff");
        String expoBackoffStr = (String)expoBackoffParam.getValue();
        PropertyManager.loadExponentialBackoff(expoBackoffStr, propertyBean);
        Parameter retransmissionIntParam = desc.getParameter("RetransmissionInterval");
        String retransmissionIntStr = (String)retransmissionIntParam.getValue();
        PropertyManager.loadRetransmissionInterval(retransmissionIntStr, propertyBean);
        Parameter acknowledgementIntParam = desc.getParameter("AcknowledgementInterval");
        String acknowledgementIntStr = (String)acknowledgementIntParam.getValue();
        PropertyManager.loadAcknowledgementInterval(acknowledgementIntStr, propertyBean);
        Parameter inactivityTimeoutParam = desc.getParameter("InactivityTimeout");
        String inactivityTimeoutStr = (String)inactivityTimeoutParam.getValue();
        Parameter inactivityTimeoutMeasureParam = desc.getParameter("InactivityTimeoutMeasure");
        String inactivityTimeoutMeasure = (String)inactivityTimeoutMeasureParam.getValue();
        PropertyManager.loadInactivityTimeout(inactivityTimeoutStr, inactivityTimeoutMeasure, propertyBean);
        Parameter sequenceRemovalTimeoutParam = desc.getParameter("SequenceRemovalTimeout");
        String sequenceRemovalTimeoutStr = (String)sequenceRemovalTimeoutParam.getValue();
        Parameter sequenceRemovalTimeoutMeasureParam = desc.getParameter("SequenceRemovalTimeoutMeasure");
        String sequenceRemovalTimeoutMeasure = (String)sequenceRemovalTimeoutMeasureParam.getValue();
        PropertyManager.loadSequenceRemovalTimeout(sequenceRemovalTimeoutStr, sequenceRemovalTimeoutMeasure, propertyBean);
        Parameter inMemoryStorageMgrClassParam = desc.getParameter("InMemoryStorageManager");
        String inMemoryStorageMgrClassStr = (String)inMemoryStorageMgrClassParam.getValue();
        PropertyManager.loadInMemoryStoragemanagerClass(inMemoryStorageMgrClassStr, propertyBean);
        Parameter permanentStorageMgrClassParam = desc.getParameter("PermanentStorageManager");
        String permanentStorageMgrClassStr = (String)permanentStorageMgrClassParam.getValue();
        PropertyManager.loadPermanentStoragemanagerClass(permanentStorageMgrClassStr, propertyBean);
        Parameter inOrderInvocationParam = desc.getParameter("InvokeInOrder");
        String inOrderInvocation = (String)inOrderInvocationParam.getValue();
        PropertyManager.loadInOrderInvocation(inOrderInvocation, propertyBean);
        Parameter enableMakeConnectionParam = desc.getParameter("EnableMakeConnection");
        String enableMakeConnection = (String)enableMakeConnectionParam.getValue();
        PropertyManager.loadEnableMakeConnection(enableMakeConnection, propertyBean);
        Parameter useSerializationParam = desc.getParameter("UseMessageSerialization");
        String useSerialization = (String)useSerializationParam.getValue();
        PropertyManager.loadUseSerialization(useSerialization, propertyBean);
        Parameter messageTypesToDropParam = desc.getParameter("MessageTypesToDrop");
        String messageTypesToDrop = (String)messageTypesToDropParam.getValue();
        PropertyManager.loadMessageTypesToDrop(messageTypesToDrop, propertyBean);
        Parameter securityManagerClassParam = desc.getParameter("SecurityManager");
        String securityManagerClassStr = (String)securityManagerClassParam.getValue();
        PropertyManager.loadSecurityManagerClass(securityManagerClassStr, propertyBean);
        return propertyBean;
    }

    public static SandeshaPolicyBean loadPropertiesFromModuleDescPolicy(AxisModule desc, SandeshaPolicyBean parentPropertyBean) throws SandeshaException {
        SandeshaPolicyBean propertyBean = new SandeshaPolicyBean();
        Policy policy = desc.getPolicyInclude().getEffectivePolicy();
        if (policy == null) {
            return null;
        }
        Iterator iterator = policy.getAlternatives();
        if (!iterator.hasNext()) {
            throw new SandeshaException("No Policy Alternative found");
        }
        List assertionList = (List)iterator.next();
        Assertion assertion = null;
        boolean found = false;
        Iterator assertions = assertionList.iterator();
        while (assertions.hasNext()) {
            assertion = (Assertion)assertions.next();
            if (!(assertion instanceof SandeshaPolicyBean)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        propertyBean = (SandeshaPolicyBean)assertion;
        propertyBean.setParent(parentPropertyBean);
        return propertyBean;
    }

    public static SandeshaPolicyBean loadPropertiesFromAxisDescription(AxisDescription desc, SandeshaPolicyBean parentPropertyBean) throws SandeshaException {
        SandeshaPolicyBean propertyBean = new SandeshaPolicyBean();
        Policy policy = desc.getPolicyInclude().getEffectivePolicy();
        if (policy == null) {
            return null;
        }
        Iterator iterator = policy.getAlternatives();
        if (!iterator.hasNext()) {
            throw new SandeshaException("No Policy Alternative found");
        }
        List assertionList = (List)iterator.next();
        Assertion assertion = null;
        boolean found = false;
        Iterator assertions = assertionList.iterator();
        while (assertions.hasNext()) {
            assertion = (Assertion)assertions.next();
            if (!(assertion instanceof SandeshaPolicyBean)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        propertyBean = (SandeshaPolicyBean)assertion;
        if (propertyBean != parentPropertyBean) {
            if (parentPropertyBean != null) {
                propertyBean.setParent(parentPropertyBean);
            }
            return propertyBean;
        }
        return null;
    }

    public static void reloadFromPropertyFile(InputStream stream) throws SandeshaException {
        PropertyManager.loadPropertiesFromPropertyFile(stream);
    }

    private static void loadExponentialBackoff(String expoBackoffStr, SandeshaPolicyBean propertyBean) {
        if (expoBackoffStr != null) {
            if ((expoBackoffStr = expoBackoffStr.trim()).equals("true")) {
                propertyBean.setExponentialBackoff(true);
            } else if (expoBackoffStr.equals("false")) {
                propertyBean.setExponentialBackoff(false);
            }
        }
    }

    private static void loadRetransmissionInterval(String retransmissionIntStr, SandeshaPolicyBean propertyBean) throws SandeshaException {
        if (retransmissionIntStr != null) {
            try {
                retransmissionIntStr = retransmissionIntStr.trim();
                int retransmissionInterval = Integer.parseInt(retransmissionIntStr);
                if (retransmissionInterval > 0) {
                    propertyBean.setRetransmissionInterval(retransmissionInterval);
                }
            }
            catch (NumberFormatException e) {
                String message = SandeshaMessageHelper.getMessage("cannotDerriveRetransInterval");
                throw new SandeshaException(message, e);
            }
        }
    }

    private static void loadAcknowledgementInterval(String acknowledgementIntStr, SandeshaPolicyBean propertyBean) throws SandeshaException {
        if (acknowledgementIntStr != null) {
            try {
                acknowledgementIntStr = acknowledgementIntStr.trim();
                int acknowledgementInt = Integer.parseInt(acknowledgementIntStr);
                if (acknowledgementInt > 0) {
                    propertyBean.setAcknowledgementInterval(acknowledgementInt);
                }
            }
            catch (NumberFormatException e) {
                String message = SandeshaMessageHelper.getMessage("cannotDerriveAckInterval");
                throw new SandeshaException(message, e);
            }
        }
    }

    private static void loadInactivityTimeout(String inactivityTimeoutStr, String inactivityTimeoutMeasure, SandeshaPolicyBean propertyBean) throws SandeshaException {
        if (inactivityTimeoutStr != null && inactivityTimeoutMeasure != null) {
            try {
                inactivityTimeoutStr = inactivityTimeoutStr.trim();
                inactivityTimeoutMeasure = inactivityTimeoutMeasure.trim();
                int inactivityTimeoutVal = Integer.parseInt(inactivityTimeoutStr);
                if (inactivityTimeoutVal > 0) {
                    propertyBean.setInactiveTimeoutInterval(inactivityTimeoutVal, inactivityTimeoutMeasure);
                }
            }
            catch (NumberFormatException e) {
                String message = SandeshaMessageHelper.getMessage("cannotDerriveInactivityTimeout");
                throw new SandeshaException(message, e);
            }
        }
    }

    private static void loadSequenceRemovalTimeout(String sequenceRemovalTimeoutStr, String sequenceRemovalTimeoutMeasure, SandeshaPolicyBean propertyBean) throws SandeshaException {
        if (sequenceRemovalTimeoutStr != null && sequenceRemovalTimeoutMeasure != null) {
            try {
                sequenceRemovalTimeoutStr = sequenceRemovalTimeoutStr.trim();
                sequenceRemovalTimeoutMeasure = sequenceRemovalTimeoutMeasure.trim();
                int sequenceRemovalTimeoutVal = Integer.parseInt(sequenceRemovalTimeoutStr);
                if (sequenceRemovalTimeoutVal > 0) {
                    propertyBean.setSequenceRemovalTimeoutInterval(sequenceRemovalTimeoutVal, sequenceRemovalTimeoutMeasure);
                }
            }
            catch (NumberFormatException e) {
                String message = SandeshaMessageHelper.getMessage("cannotDerriveInactivityTimeout");
                throw new SandeshaException(message, e);
            }
        }
    }

    private static void loadInMemoryStoragemanagerClass(String inMemoryStorageMgrClassStr, SandeshaPolicyBean propertyBean) {
        if (inMemoryStorageMgrClassStr != null) {
            inMemoryStorageMgrClassStr = inMemoryStorageMgrClassStr.trim();
            propertyBean.setInMemoryStorageManagerClass(inMemoryStorageMgrClassStr);
        }
    }

    private static void loadPermanentStoragemanagerClass(String permanentStorageMgrClassStr, SandeshaPolicyBean propertyBean) {
        if (permanentStorageMgrClassStr != null) {
            permanentStorageMgrClassStr = permanentStorageMgrClassStr.trim();
            propertyBean.setPermanentStorageManagerClass(permanentStorageMgrClassStr);
        }
    }

    private static void loadInOrderInvocation(String inOrderInvocation, SandeshaPolicyBean propertyBean) {
        if (inOrderInvocation != null) {
            if ((inOrderInvocation = inOrderInvocation.trim()).equalsIgnoreCase("true")) {
                propertyBean.setInOrder(true);
            } else if (inOrderInvocation.equalsIgnoreCase("false")) {
                propertyBean.setInOrder(false);
            }
        }
    }

    private static void loadEnableMakeConnection(String enableMakeConnection, SandeshaPolicyBean propertyBean) {
        if (enableMakeConnection != null) {
            if ((enableMakeConnection = enableMakeConnection.trim()).equalsIgnoreCase("true")) {
                propertyBean.setEnableMakeConnection(true);
            } else if (enableMakeConnection.equalsIgnoreCase("false")) {
                propertyBean.setEnableMakeConnection(false);
            }
        }
    }

    private static void loadUseSerialization(String useSerialization, SandeshaPolicyBean propertyBean) {
        if (useSerialization != null) {
            if ((useSerialization = useSerialization.trim()).equalsIgnoreCase("true")) {
                propertyBean.setUseMessageSerialization(true);
            } else if (useSerialization.equalsIgnoreCase("false")) {
                propertyBean.setUseMessageSerialization(false);
            }
        }
    }

    private static void loadMessageTypesToDrop(String messageTypesToDrop, SandeshaPolicyBean propertyBean) {
        if (messageTypesToDrop != null && !"none".equals(messageTypesToDrop)) {
            messageTypesToDrop = messageTypesToDrop.trim();
            messageTypesToDrop = "[" + messageTypesToDrop + "]";
            ArrayList messageTypesLst = SandeshaUtil.getArrayListFromString(messageTypesToDrop);
            Iterator itr = messageTypesLst.iterator();
            while (itr.hasNext()) {
                String typeStr = (String)itr.next();
                Integer typeNo = new Integer(typeStr);
                propertyBean.addMsgTypeToDrop(typeNo);
            }
        }
    }

    private static void loadSecurityManagerClass(String securityManagerClassStr, SandeshaPolicyBean propertyBean) {
        if (securityManagerClassStr != null) {
            securityManagerClassStr = securityManagerClassStr.trim();
            propertyBean.setSecurityManagerClass(securityManagerClassStr);
        }
    }

    private static void loadContextManagerClass(String contextManagerClassStr, SandeshaPolicyBean propertyBean) {
        if (contextManagerClassStr != null) {
            contextManagerClassStr = contextManagerClassStr.trim();
            propertyBean.setContextManagerClass(contextManagerClassStr);
        }
    }
}

