/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.beans;

import org.apache.sandesha2.storage.beans.RMBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.util.RangeString;

public class RMDBean
extends RMSequenceBean {
    private static final long serialVersionUID = -2976123838615087562L;
    private String referenceMessageKey;
    private String highestInMessageId;
    private String lastInMessageId;
    private RangeString serverCompletedMessages = null;
    private RangeString outOfOrderRanges = null;
    private String toAddress;
    private String outboundInternalSequence;
    private long nextMsgNoToProcess;
    private long highestInMessageNumber = 0L;
    private int rmdFlags = 0;
    private static final int NEXT_MSG_NO_FLAG = 1;
    private static final int HIGHEST_IN_MSG_FLAG = 16;

    public RMDBean() {
    }

    public RMDBean(RMDBean beanToCopy) {
        super(beanToCopy);
        this.highestInMessageId = beanToCopy.getHighestInMessageId();
        this.highestInMessageNumber = beanToCopy.getHighestInMessageNumber();
        this.lastInMessageId = beanToCopy.getLastInMessageId();
        this.nextMsgNoToProcess = beanToCopy.getNextMsgNoToProcess();
        this.outboundInternalSequence = beanToCopy.getOutboundInternalSequence();
        this.outOfOrderRanges = beanToCopy.getOutOfOrderRanges();
        this.referenceMessageKey = beanToCopy.getReferenceMessageKey();
        this.serverCompletedMessages = new RangeString(beanToCopy.getServerCompletedMessages().toString());
        this.toAddress = beanToCopy.getToAddress();
    }

    public RMDBean(String sequenceID, long nextNsgNo) {
        super(sequenceID);
        this.setNextMsgNoToProcess(nextNsgNo);
    }

    public long getNextMsgNoToProcess() {
        return this.nextMsgNoToProcess;
    }

    public void setNextMsgNoToProcess(long nextMsgNoToProcess) {
        this.nextMsgNoToProcess = nextMsgNoToProcess;
        this.rmdFlags |= 1;
    }

    public String getReferenceMessageKey() {
        return this.referenceMessageKey;
    }

    public void setReferenceMessageKey(String referenceMessageKey) {
        this.referenceMessageKey = referenceMessageKey;
    }

    public String getHighestInMessageId() {
        return this.highestInMessageId;
    }

    public void setHighestInMessageId(String highestInMessageId) {
        this.highestInMessageId = highestInMessageId;
        this.rmdFlags |= 0x10;
    }

    public long getHighestInMessageNumber() {
        return this.highestInMessageNumber;
    }

    public void setHighestInMessageNumber(long highestInMessageNumber) {
        this.highestInMessageNumber = highestInMessageNumber;
    }

    public RangeString getServerCompletedMessages() {
        return this.serverCompletedMessages;
    }

    public void setServerCompletedMessages(RangeString serverCompletedMessages) {
        this.serverCompletedMessages = serverCompletedMessages;
    }

    public String getLastInMessageId() {
        return this.lastInMessageId;
    }

    public void setLastInMessageId(String lastInMessageId) {
        this.lastInMessageId = lastInMessageId;
    }

    public RangeString getOutOfOrderRanges() {
        return this.outOfOrderRanges;
    }

    public void setOutOfOrderRanges(RangeString outOfOrderRanges) {
        this.outOfOrderRanges = outOfOrderRanges;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public String getOutboundInternalSequence() {
        return this.outboundInternalSequence;
    }

    public void setOutboundInternalSequence(String outboundSequence) {
        this.outboundInternalSequence = outboundSequence;
    }

    public int getRmdFlags() {
        return this.rmdFlags;
    }

    public void setRmdFlags(int rmdFlags) {
        this.rmdFlags = rmdFlags;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName());
        result.append(super.toString());
        result.append("\nNext Msg # : ");
        result.append(this.nextMsgNoToProcess);
        result.append("\nRef Msg Key: ");
        result.append(this.referenceMessageKey);
        result.append("\nHishestInMessageNumber: ");
        result.append(this.highestInMessageNumber);
        result.append("\nHishestInMessageKey: ");
        result.append(this.highestInMessageId);
        result.append("\nLastInMessageId: ");
        result.append(this.lastInMessageId);
        result.append("\nOutOfOrderRanges   : ");
        result.append(this.outOfOrderRanges);
        result.append("\nServerCompletedMsgs: ");
        result.append(this.serverCompletedMessages);
        result.append("\nOutbound int seq   : ");
        result.append(this.outboundInternalSequence);
        return result.toString();
    }

    public boolean match(RMBean matchInfo) {
        RMDBean bean = (RMDBean)matchInfo;
        boolean equal = true;
        if (!super.match(matchInfo)) {
            equal = false;
        } else if (bean.getReferenceMessageKey() != null && !bean.getReferenceMessageKey().equals(this.getReferenceMessageKey())) {
            equal = false;
        } else if (bean.getHighestInMessageId() != null && !bean.getHighestInMessageId().equals(this.getHighestInMessageId())) {
            equal = false;
        } else if (bean.getLastInMessageId() != null && !bean.getLastInMessageId().equals(this.getLastInMessageId())) {
            equal = false;
        } else if (bean.getServerCompletedMessages() != null && !bean.getServerCompletedMessages().equals(this.getServerCompletedMessages())) {
            equal = false;
        } else if (bean.getOutOfOrderRanges() != null && !bean.getOutOfOrderRanges().equals(this.getOutOfOrderRanges())) {
            equal = false;
        } else if (bean.getToAddress() != null && !bean.getToAddress().equals(this.getToAddress())) {
            equal = false;
        } else if (bean.getOutboundInternalSequence() != null && !bean.getOutboundInternalSequence().equals(this.getOutboundInternalSequence())) {
            equal = false;
        } else if ((bean.rmdFlags & 1) != 0 && bean.getNextMsgNoToProcess() != this.getNextMsgNoToProcess()) {
            equal = false;
        } else if ((bean.rmdFlags & 0x10) != 0 && bean.getHighestInMessageNumber() != this.getHighestInMessageNumber()) {
            equal = false;
        }
        return equal;
    }
}

