/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.context.ContextManager;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MakeConnectionProcessor;
import org.apache.sandesha2.msgreceivers.RMMessageReceiver;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.wsrm.Sequence;

public class SequenceProcessor {
    private static final Log log = LogFactory.getLog((Class)SequenceProcessor.class);

    public Handler.InvocationResponse processSequenceHeader(RMMsgContext rmMsgCtx, Transaction transaction) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SequenceProcessor::processSequenceHeader");
        }
        Handler.InvocationResponse result = Handler.InvocationResponse.CONTINUE;
        Sequence sequence = (Sequence)rmMsgCtx.getMessagePart(6);
        if (sequence != null) {
            result = this.processReliableMessage(rmMsgCtx, transaction);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Message does not contain a sequence header");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SequenceProcessor::processSequenceHeader " + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler.InvocationResponse processReliableMessage(RMMsgContext rmMsgCtx, Transaction transaction) throws AxisFault {
        SandeshaThread invoker;
        RelatesTo relatesTo;
        ConfigurationContext configCtx;
        OperationContext opCtx;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SequenceProcessor::processReliableMessage");
        }
        Handler.InvocationResponse result = Handler.InvocationResponse.CONTINUE;
        if (rmMsgCtx.getProperty("Sandesha2AppProcessingDone") != null && rmMsgCtx.getProperty("Sandesha2AppProcessingDone").equals("true")) {
            return result;
        }
        MessageContext msgCtx = rmMsgCtx.getMessageContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(msgCtx.getConfigurationContext(), (AxisDescription)msgCtx.getConfigurationContext().getAxisConfiguration());
        Sequence sequence = (Sequence)rmMsgCtx.getMessagePart(6);
        String sequenceId = sequence.getIdentifier().getIdentifier();
        long msgNo = sequence.getMessageNumber().getMessageNumber();
        boolean lastMessage = sequence.getLastMessage() != null;
        RMDBeanMgr mgr = storageManager.getRMDBeanMgr();
        RMDBean bean = mgr.retrieve(sequenceId);
        if (bean != null && bean.getSecurityTokenData() != null) {
            SecurityManager secManager = SandeshaUtil.getSecurityManager(msgCtx.getConfigurationContext());
            QName seqName = new QName(rmMsgCtx.getRMNamespaceValue(), "Sequence");
            SOAPEnvelope envelope = msgCtx.getEnvelope();
            SOAPBody body = envelope.getBody();
            OMElement seqHeader = envelope.getHeader().getFirstChildWithName(seqName);
            SecurityToken token = secManager.recoverSecurityToken(bean.getSecurityTokenData());
            secManager.checkProofOfPossession(token, seqHeader, msgCtx);
            secManager.checkProofOfPossession(token, (OMElement)body, msgCtx);
        }
        if ((opCtx = msgCtx.getOperationContext()) != null) {
            opCtx.setProperty("Sandesha2InboundSequenceId", (Object)sequenceId);
            opCtx.setProperty("Sandesha2InboundMessageNumber", (Object)new Long(msgNo));
            if (lastMessage) {
                opCtx.setProperty("Sandesha2InboundLastMessage", (Object)Boolean.TRUE);
            }
        }
        if ((configCtx = rmMsgCtx.getMessageContext().getConfigurationContext()) == null) {
            String message = SandeshaMessageHelper.getMessage("configContextNotSet");
            log.debug((Object)message);
            throw new SandeshaException(message);
        }
        if (FaultManager.checkForUnknownSequence(rmMsgCtx, sequenceId, storageManager, false)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: SequenceProcessor::processReliableMessage, Unknown sequence");
            }
            return Handler.InvocationResponse.ABORT;
        }
        if (FaultManager.checkForSequenceTerminated(rmMsgCtx, sequenceId, bean, false)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: SequenceProcessor::processReliableMessage, Sequence terminated");
            }
            return Handler.InvocationResponse.ABORT;
        }
        if (FaultManager.checkForSequenceClosed(rmMsgCtx, sequenceId, bean, false)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: SequenceProcessor::processReliableMessage, Sequence closed");
            }
            return Handler.InvocationResponse.ABORT;
        }
        FaultManager.checkForLastMsgNumberExceeded(rmMsgCtx, storageManager);
        if (FaultManager.checkForMessageRolledOver(rmMsgCtx, sequenceId, msgNo)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: SequenceProcessor::processReliableMessage, Message rolled over " + msgNo));
            }
            return Handler.InvocationResponse.ABORT;
        }
        bean.setLastActivatedTime(System.currentTimeMillis());
        if (lastMessage) {
            bean.setLastInMessageId(msgCtx.getMessageID());
        }
        EndpointReference replyTo = rmMsgCtx.getReplyTo();
        String key = SandeshaUtil.getUUID();
        long highestInMsgNo = bean.getHighestInMessageNumber();
        if (msgNo > highestInMsgNo) {
            String messageId = msgCtx.getMessageID();
            if (messageId == null) {
                messageId = SandeshaUtil.getUUID();
                msgCtx.setMessageID(messageId);
            }
            bean.setHighestInMessageId(messageId);
            bean.setHighestInMessageNumber(msgNo);
        }
        String specVersion = rmMsgCtx.getRMSpecVersion();
        if (SandeshaUtil.isDuplicateInOnlyMessage(rmMsgCtx.getMessageContext()) || SandeshaUtil.isDuplicateInOutMessage(rmMsgCtx.getMessageContext())) {
            if ((replyTo == null || replyTo.hasAnonymousAddress()) && specVersion != null && specVersion.equals("Spec_2005_02")) {
                SenderBeanMgr senderBeanMgr = storageManager.getSenderBeanMgr();
                SenderBean findSenderBean = new SenderBean();
                if (rmMsgCtx.getMessageType() == 12) {
                    findSenderBean.setMessageType(12);
                } else {
                    findSenderBean.setMessageType(3);
                }
                findSenderBean.setInboundSequenceId(sequence.getIdentifier().getIdentifier());
                findSenderBean.setInboundMessageNumber(sequence.getMessageNumber().getMessageNumber());
                findSenderBean.setSend(true);
                SenderBean replyMessageBean = senderBeanMgr.findUnique(findSenderBean);
                if (replyMessageBean != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Found matching reply for replayed message");
                    }
                    MakeConnectionProcessor.replyToPoll(rmMsgCtx, replyMessageBean, storageManager, false, null, transaction);
                    result = Handler.InvocationResponse.ABORT;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exit: SequenceProcessor::processReliableMessage, replayed message: " + result));
                    }
                    return result;
                }
            }
            EndpointReference acksTo = new EndpointReference(bean.getAcksToEPR());
            if (!"Spec_2005_02".equals(rmMsgCtx.getRMSpecVersion()) || !rmMsgCtx.getReplyTo().hasAnonymousAddress()) {
                this.sendAckIfNeeded(bean, sequenceId, rmMsgCtx, storageManager, true, acksTo.hasAnonymousAddress());
            }
            result = Handler.InvocationResponse.ABORT;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: SequenceProcessor::processReliableMessage, dropping duplicate: " + result));
            }
            return result;
        }
        EndpointReference toEPR = msgCtx.getTo();
        if (toEPR == null || toEPR.hasAnonymousAddress()) {
            String outboundSequence;
            String toAddress;
            RMSBean outBean = null;
            String string = toAddress = toEPR == null ? null : toEPR.getAddress();
            if (SandeshaUtil.isWSRMAnonymous(toAddress)) {
                RMSBean finderBean = new RMSBean();
                finderBean.setAnonymousUUID(toAddress);
                outBean = storageManager.getRMSBeanMgr().findUnique(finderBean);
            }
            if (outBean == null && (outboundSequence = bean.getOutboundInternalSequence()) != null) {
                outBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, outboundSequence);
            }
            if (outBean != null && outBean.getExpectedReplies() > 0L) {
                outBean.setExpectedReplies(outBean.getExpectedReplies() - 1L);
                RMSBeanMgr outMgr = storageManager.getRMSBeanMgr();
                outMgr.update(outBean);
            }
        }
        bean.setLastActivatedTime(System.currentTimeMillis());
        mgr.update(bean);
        int mep = msgCtx.getAxisOperation().getAxisSpecificMEPConstant();
        if (specVersion != null && specVersion.equals("Spec_2005_02") && mep == 16 && (relatesTo = msgCtx.getRelatesTo()) != null) {
            String messageId = relatesTo.getValue();
            SenderBean matcher = new SenderBean();
            matcher.setMessageID(messageId);
            SenderBean sender = storageManager.getSenderBeanMgr().findUnique(matcher);
            if (sender != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Deleting sender for sync-2-way message");
                }
                storageManager.removeMessageContext(sender.getMessageContextRefKey());
                storageManager.getSenderBeanMgr().delete(messageId);
                RMSBean rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sender.getSequenceID());
                TerminateManager.checkAndTerminate(rmMsgCtx.getConfigurationContext(), storageManager, rmsBean);
            }
        }
        rmMsgCtx.setProperty("WSRMSequenceId", sequenceId);
        rmMsgCtx.setProperty("WSRMMessageNumber", new Long(msgNo));
        boolean backchannelFree = replyTo != null && !replyTo.hasAnonymousAddress() || 10 == mep;
        boolean sendAck = false;
        boolean ackBackChannel = SpecSpecificConstants.sendAckInBackChannel(rmMsgCtx.getMessageType());
        EndpointReference acksTo = new EndpointReference(bean.getAcksToEPR());
        if (acksTo.hasAnonymousAddress() && backchannelFree && ackBackChannel) {
            boolean responseWritten = TransportUtils.isResponseWritten((MessageContext)msgCtx);
            if (!responseWritten) {
                sendAck = true;
            }
        } else if (!acksTo.hasAnonymousAddress()) {
            SandeshaPolicyBean policyBean = SandeshaUtil.getPropertyBean((AxisDescription)msgCtx.getAxisOperation());
            long ackInterval = policyBean.getAcknowledgementInterval();
            long timeToSend = System.currentTimeMillis() + ackInterval;
            RMMsgContext ackRMMsgContext = AcknowledgementManager.generateAckMessage(rmMsgCtx, bean, sequenceId, storageManager, true);
            AcknowledgementManager.addAckBeanEntry(ackRMMsgContext, sequenceId, timeToSend, storageManager);
        }
        if (("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage".equals(msgCtx.getWSAAction()) || "http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage".equals(msgCtx.getSoapAction())) && rmMsgCtx.getRelatesTo() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: SequenceProcessor::processReliableMessage, got WSRM 1.0 lastmessage");
            }
            msgCtx.getAxisOperation().setMessageReceiver((MessageReceiver)new RMMessageReceiver());
        }
        if ((invoker = storageManager.getInvoker()) != null) {
            result = backchannelFree && ackBackChannel ? Handler.InvocationResponse.ABORT : Handler.InvocationResponse.SUSPEND;
            InvokerBeanMgr storageMapMgr = storageManager.getInvokerBeanMgr();
            storageManager.storeMessageContext(key, rmMsgCtx.getMessageContext());
            InvokerBean invokerBean = new InvokerBean(key, msgNo, sequenceId);
            ContextManager contextMgr = SandeshaUtil.getContextManager(configCtx);
            if (contextMgr != null) {
                invokerBean.setContext(contextMgr.storeContext());
            }
            storageMapMgr.insert(invokerBean);
            rmMsgCtx.setProperty("Sandesha2AppProcessingDone", "true");
        }
        if (transaction != null && transaction.isActive()) {
            transaction.commit();
        }
        if (sendAck) {
            try {
                transaction = storageManager.getTransaction();
                RMMsgContext ackRMMsgContext = AcknowledgementManager.generateAckMessage(rmMsgCtx, bean, sequenceId, storageManager, true);
                AcknowledgementManager.sendAckNow(ackRMMsgContext);
                TransportUtils.setResponseWritten((MessageContext)msgCtx, (boolean)true);
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = null;
            }
            finally {
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SequenceProcessor::processReliableMessage " + result));
        }
        return result;
    }

    private void sendAckIfNeeded(RMDBean rmdBean, String sequenceId, RMMsgContext rmMsgCtx, StorageManager storageManager, boolean serverSide, boolean anonymousAcksTo) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: SequenceProcessor::sendAckIfNeeded " + sequenceId));
        }
        RMMsgContext ackRMMsgCtx = AcknowledgementManager.generateAckMessage(rmMsgCtx, rmdBean, sequenceId, storageManager, serverSide);
        if (anonymousAcksTo) {
            AcknowledgementManager.sendAckNow(ackRMMsgCtx);
            TransportUtils.setResponseWritten((MessageContext)rmMsgCtx.getMessageContext(), (boolean)true);
        } else {
            long ackInterval = SandeshaUtil.getPropertyBean((AxisDescription)rmMsgCtx.getMessageContext().getAxisService()).getAcknowledgementInterval();
            long timeToSend = System.currentTimeMillis() + ackInterval;
            AcknowledgementManager.addAckBeanEntry(ackRMMsgCtx, sequenceId, timeToSend, storageManager);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SequenceProcessor::sendAckIfNeeded");
        }
    }
}

