/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.wsrm.AcknowledgementRange;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;

public class AcknowledgementProcessor {
    private static final Log log = LogFactory.getLog((Class)AcknowledgementProcessor.class);

    public void processAckHeaders(RMMsgContext message) throws AxisFault {
        SOAPEnvelope envelope;
        SOAPHeader header;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: AcknowledgementProcessor::processAckHeaders");
        }
        if ((header = (envelope = message.getMessageContext().getEnvelope()).getHeader()) != null) {
            for (int i = 0; i < Sandesha2Constants.SPEC_NS_URIS.length; ++i) {
                QName headerName = new QName(Sandesha2Constants.SPEC_NS_URIS[i], "SequenceAcknowledgement");
                Iterator acks = header.getChildrenWithName(headerName);
                while (acks.hasNext()) {
                    OMElement ack = (OMElement)acks.next();
                    SequenceAcknowledgement seqAck = new SequenceAcknowledgement(headerName.getNamespaceURI());
                    seqAck.fromOMElement(ack);
                    this.processAckHeader(message, ack, seqAck);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeaders");
        }
    }

    private void processAckHeader(RMMsgContext rmMsgCtx, OMElement soapHeader, SequenceAcknowledgement sequenceAck) throws AxisFault {
        PollingManager manager;
        RMDBeanMgr rMDBeanMgr;
        RMDBean rMDBean;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: AcknowledgementProcessor::processAckHeader " + soapHeader));
        }
        boolean piggybackedAck = rmMsgCtx.getMessageType() != 4;
        MessageContext msgCtx = rmMsgCtx.getMessageContext();
        ConfigurationContext configCtx = msgCtx.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configCtx, (AxisDescription)configCtx.getAxisConfiguration());
        SenderBeanMgr retransmitterMgr = storageManager.getSenderBeanMgr();
        String outSequenceId = sequenceAck.getIdentifier().getIdentifier();
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, outSequenceId);
        if (outSequenceId == null || "".equals(outSequenceId)) {
            String message = SandeshaMessageHelper.getMessage("outSeqIDIsNull");
            log.debug((Object)message);
            throw new SandeshaException(message);
        }
        if (FaultManager.checkForUnknownSequence(rmMsgCtx, outSequenceId, storageManager, piggybackedAck)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeader, Unknown sequence");
            }
            return;
        }
        if (FaultManager.checkForSequenceTerminated(rmMsgCtx, outSequenceId, rmsBean, piggybackedAck)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeader, Sequence terminated");
            }
            return;
        }
        String internalSequenceId = rmsBean.getInternalSequenceID();
        if (rmsBean.getSecurityTokenData() != null) {
            SecurityManager secManager = SandeshaUtil.getSecurityManager(configCtx);
            SecurityToken token = secManager.recoverSecurityToken(rmsBean.getSecurityTokenData());
            secManager.checkProofOfPossession(token, soapHeader, msgCtx);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got Ack for RM Sequence: " + outSequenceId + ", internalSeqId: " + internalSequenceId));
        }
        Iterator ackRangeIterator = sequenceAck.getAcknowledgementRanges().iterator();
        if (FaultManager.checkForUnknownSequence(rmMsgCtx, outSequenceId, storageManager, piggybackedAck)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeader, Unknown sequence ");
            }
            return;
        }
        if (FaultManager.checkForInvalidAcknowledgement(rmMsgCtx, sequenceAck, storageManager, rmsBean, piggybackedAck)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeader, Invalid Ack range ");
            }
            return;
        }
        String replyToAddress = rmsBean.getReplyToEPR();
        EndpointReference replyTo = new EndpointReference(replyToAddress);
        boolean anonReplyTo = replyTo.hasAnonymousAddress();
        String rmVersion = rmMsgCtx.getRMSpecVersion();
        RangeString completedMessages = rmsBean.getClientCompletedMessages();
        long numberOfNewMessagesAcked = 0L;
        while (ackRangeIterator.hasNext()) {
            long upper;
            AcknowledgementRange ackRange = (AcknowledgementRange)ackRangeIterator.next();
            long lower = ackRange.getLowerValue();
            Range ackedRange = new Range(lower, upper = ackRange.getUpperValue());
            if (completedMessages.isRangeCompleted(ackedRange)) continue;
            Range[] newRanges = completedMessages.addRange(ackedRange).getRanges();
            for (int rangeIndex = 0; rangeIndex < newRanges.length; ++rangeIndex) {
                for (long messageNo = newRanges[rangeIndex].lowerValue; messageNo <= newRanges[rangeIndex].upperValue; ++messageNo) {
                    ++numberOfNewMessagesAcked;
                    SenderBean matcher = new SenderBean();
                    matcher.setSequenceID(outSequenceId);
                    matcher.setMessageNumber(messageNo);
                    List retransmitterBeans = retransmitterMgr.find(matcher);
                    if (retransmitterBeans.isEmpty()) continue;
                    Iterator retransmitterBeansItr = retransmitterBeans.iterator();
                    while (retransmitterBeansItr.hasNext()) {
                        MessageContext applicationMessage;
                        AxisOperation operation;
                        SenderBean retransmitterBean = (SenderBean)retransmitterBeansItr.next();
                        if (retransmitterBean == null) continue;
                        if (retransmitterBean.getSentCount() == 0) {
                            FaultManager.makeInvalidAcknowledgementFault(rmMsgCtx, sequenceAck, ackRange, storageManager, piggybackedAck);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeader, Invalid Ack");
                            }
                            return;
                        }
                        String storageKey = retransmitterBean.getMessageContextRefKey();
                        boolean syncResponseNeeded = false;
                        if ("Spec_2005_02".equals(rmVersion) && anonReplyTo && (operation = (applicationMessage = storageManager.retrieveMessageContext(storageKey, configCtx)).getAxisOperation()) != null) {
                            int mep = operation.getAxisSpecificMEPConstant();
                            boolean bl = syncResponseNeeded = mep == 16;
                        }
                        if (syncResponseNeeded) continue;
                        retransmitterMgr.delete(retransmitterBean.getMessageID());
                        storageManager.removeMessageContext(storageKey);
                    }
                }
            }
        }
        rmsBean.setLastActivatedTime(System.currentTimeMillis());
        if (rmsBean.getOfferedSequence() != null && (rMDBean = (rMDBeanMgr = storageManager.getRMDBeanMgr()).retrieve(outSequenceId)) != null && rMDBean.isPollingMode() && (manager = storageManager.getPollingManager()) != null) {
            manager.schedulePollingRequest(rMDBean.getSequenceID(), false);
        }
        if (numberOfNewMessagesAcked > 0L) {
            rmsBean.setClientCompletedMessages(completedMessages);
        }
        storageManager.getRMSBeanMgr().update(rmsBean);
        if (!rmsBean.isAvoidAutoTermination()) {
            TerminateManager.checkAndTerminate(rmMsgCtx.getConfigurationContext(), storageManager, rmsBean);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementProcessor::processAckHeader");
        }
    }
}

