/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.handlers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;

public class SequenceIDDispatcher
extends AbstractDispatcher {
    private final String NAME = "SequenceIDDIspatcher";
    private static final Log log = LogFactory.getLog((Class)SequenceIDDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription("SequenceIDDIspatcher"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AxisService findService(MessageContext msgContext) throws AxisFault {
        Parameter unreliableParam;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: SequenceIDDispatcher::findService, " + msgContext.getEnvelope().getHeader()));
        }
        if (msgContext.getAxisService() != null && null != (unreliableParam = msgContext.getAxisService().getParameter(SandeshaClientConstants.UNRELIABLE_MESSAGE)) && "true".equals(unreliableParam.getValue())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: SequenceIDDispatcher::findService, Service has disabled RM ");
            }
            return null;
        }
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        RMMsgContext rmmsgContext = MsgInitializer.initializeMessage(msgContext);
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, (AxisDescription)configurationContext.getAxisConfiguration());
        Transaction transaction = storageManager.getTransaction();
        AxisService service = null;
        try {
            String sequenceID = (String)rmmsgContext.getProperty("WSRMSequenceId");
            service = null;
            if (sequenceID != null) {
                String serviceName;
                RMSBean rmsBean;
                RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceID);
                if (rmdBean != null) {
                    String serviceName2 = null;
                    if (rmdBean != null) {
                        serviceName2 = rmdBean.getServiceName();
                    }
                    if (serviceName2 != null) {
                        service = configurationContext.getAxisConfiguration().getService(serviceName2);
                    }
                }
                if (service == null && rmdBean == null && (rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sequenceID)) != null && (serviceName = rmsBean.getServiceName()) != null) {
                    service = configurationContext.getAxisConfiguration().getService(serviceName);
                }
            }
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SequenceIDDispatcher::findService, " + service));
        }
        return service;
    }
}

