/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.synapse.SynapseException;
import org.apache.synapse.transport.base.BaseConstants;
import org.apache.synapse.util.WrappedTextNodeStreamReader;

public class TextFileDataSource
implements OMDataSource {
    private static final byte[] empty = "<text xmlns=\"http://ws.apache.org/commons/ns/payload\"/>".getBytes();
    private InputStream is = null;

    public TextFileDataSource(DataSource ds) {
        try {
            this.is = ds.getInputStream();
        }
        catch (IOException e) {
            throw new SynapseException("Unable to get an InputStream for DataSource : " + ds.getName(), e);
        }
    }

    public void serialize(OutputStream out, OMOutputFormat format) throws XMLStreamException {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = this.is.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new SynapseException("Error serializing TextFileDataSource to an OutputStream", e);
        }
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            writer.write(new String(empty));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        StreamingOMSerializer serializer = new StreamingOMSerializer();
        serializer.serialize(this.getReader(), xmlWriter);
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        return new WrappedTextNodeStreamReader(BaseConstants.DEFAULT_TEXT_WRAPPER, new InputStreamReader(this.is));
    }
}

