/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.util.UUIDGenerator;

public class MessageHelper {
    public static MessageContext cloneMessageContext(MessageContext synCtx) throws AxisFault {
        MessageContext newCtx = synCtx.getEnvironment().createMessageContext();
        Axis2MessageContext axis2MC = (Axis2MessageContext)newCtx;
        axis2MC.setAxis2MessageContext(MessageHelper.cloneAxis2MessageContext(((Axis2MessageContext)synCtx).getAxis2MessageContext()));
        newCtx.setConfiguration(synCtx.getConfiguration());
        newCtx.setEnvironment(synCtx.getEnvironment());
        newCtx.setContextEntries(synCtx.getContextEntries());
        newCtx.setProperty("aggregateCorelation", synCtx.getMessageID());
        newCtx.setTo(synCtx.getTo());
        newCtx.setReplyTo(synCtx.getReplyTo());
        newCtx.setSoapAction(synCtx.getSoapAction());
        newCtx.setWSAAction(synCtx.getWSAAction());
        newCtx.setResponse(synCtx.isResponse());
        for (Object o : synCtx.getPropertyKeySet()) {
            if (!(o instanceof String)) continue;
            newCtx.setProperty((String)o, synCtx.getProperty((String)o));
        }
        return newCtx;
    }

    public static org.apache.axis2.context.MessageContext cloneAxis2MessageContext(org.apache.axis2.context.MessageContext mc) throws AxisFault {
        org.apache.axis2.context.MessageContext newMC = MessageHelper.clonePartially(mc);
        newMC.setEnvelope(MessageHelper.cloneSOAPEnvelope(mc.getEnvelope()));
        newMC.setServiceContext(mc.getServiceContext());
        newMC.setOperationContext(mc.getOperationContext());
        newMC.setAxisMessage(mc.getAxisMessage());
        if (newMC.getAxisMessage() != null) {
            newMC.getAxisMessage().setParent((AxisDescription)mc.getAxisOperation());
        }
        newMC.setAxisService(mc.getAxisService());
        newMC.setTransportIn(mc.getTransportIn());
        newMC.setTransportOut(mc.getTransportOut());
        newMC.setProperty("OutTransportInfo", mc.getProperty("OutTransportInfo"));
        newMC.setProperty("TRANSPORT_HEADERS", (Object)MessageHelper.getClonedTransportHeaders(mc));
        return newMC;
    }

    public static Map getClonedTransportHeaders(org.apache.axis2.context.MessageContext msgCtx) {
        Map headers = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        HashMap clonedHeaders = new HashMap();
        if (headers != null && headers.isEmpty()) {
            for (Object o : headers.keySet()) {
                String headerName = (String)o;
                clonedHeaders.put(headerName, headers.get(headerName));
            }
        }
        return clonedHeaders;
    }

    public static org.apache.axis2.context.MessageContext clonePartially(org.apache.axis2.context.MessageContext ori) throws AxisFault {
        String key;
        org.apache.axis2.context.MessageContext newMC = new org.apache.axis2.context.MessageContext();
        newMC.setConfigurationContext(ori.getConfigurationContext());
        newMC.setMessageID(UUIDGenerator.getUUID());
        newMC.setTo(ori.getTo());
        newMC.setSoapAction(ori.getSoapAction());
        newMC.setProperty("CHARACTER_SET_ENCODING", ori.getProperty("CHARACTER_SET_ENCODING"));
        newMC.setProperty("enableMTOM", ori.getProperty("enableMTOM"));
        newMC.setProperty("enableSwA", ori.getProperty("enableSwA"));
        newMC.setProperty("HTTP_METHOD", ori.getProperty("HTTP_METHOD"));
        newMC.setDoingREST(ori.isDoingREST());
        newMC.setDoingMTOM(ori.isDoingMTOM());
        newMC.setDoingSwA(ori.isDoingSwA());
        Attachments attachments = ori.getAttachmentMap();
        if (attachments != null && attachments.getAllContentIDs().length > 0) {
            String[] cIDs = attachments.getAllContentIDs();
            String soapPart = attachments.getSOAPPartContentID();
            for (String cID : cIDs) {
                if (cID.equals(soapPart)) continue;
                newMC.addAttachment(cID, attachments.getDataHandler(cID));
            }
        }
        for (Object o : ori.getOptions().getProperties().keySet()) {
            key = (String)o;
            newMC.getOptions().setProperty(key, ori.getOptions().getProperty(key));
        }
        for (Object o1 : ori.getProperties().keySet()) {
            key = (String)o1;
            if (key == null) continue;
            newMC.setNonReplicableProperty(key, ori.getPropertyNonReplicable(key));
        }
        newMC.setServerSide(false);
        return newMC;
    }

    public static SOAPEnvelope cloneSOAPEnvelope(SOAPEnvelope envelope) {
        Iterator itr;
        SOAPEnvelope newEnvelope = "http://schemas.xmlsoap.org/soap/envelope/".equals(envelope.getBody().getNamespace().getNamespaceURI()) ? OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope() : OMAbstractFactory.getSOAP12Factory().getDefaultEnvelope();
        if (envelope.getHeader() != null) {
            itr = envelope.getHeader().cloneOMElement().getChildren();
            while (itr.hasNext()) {
                newEnvelope.getHeader().addChild((OMNode)itr.next());
            }
        }
        if (envelope.getBody() != null) {
            itr = envelope.getBody().cloneOMElement().getChildren();
            while (itr.hasNext()) {
                newEnvelope.getBody().addChild((OMNode)itr.next());
            }
        }
        return newEnvelope;
    }

    public static SOAPEnvelope removeAddressingHeaders(org.apache.axis2.context.MessageContext axisMsgCtx) {
        SOAPEnvelope env = axisMsgCtx.getEnvelope();
        SOAPHeader soapHeader = env.getHeader();
        if (soapHeader != null) {
            ArrayList addressingHeaders = soapHeader.getHeaderBlocksWithNSURI("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            if (addressingHeaders != null && addressingHeaders.size() != 0) {
                MessageHelper.detachAddressingInformation(addressingHeaders);
            } else {
                addressingHeaders = soapHeader.getHeaderBlocksWithNSURI("http://www.w3.org/2005/08/addressing");
                if (addressingHeaders != null && addressingHeaders.size() != 0) {
                    MessageHelper.detachAddressingInformation(addressingHeaders);
                }
            }
        }
        return env;
    }

    private static void detachAddressingInformation(ArrayList headerInformation) {
        for (Object o : headerInformation) {
            OMElement om;
            OMNamespace ns;
            if (o instanceof SOAPHeaderBlock) {
                SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)o;
                headerBlock.detach();
                continue;
            }
            if (!(o instanceof OMElement) || (ns = (om = (OMElement)o).getNamespace()) == null || !"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(ns.getNamespaceURI()) && !"http://www.w3.org/2005/08/addressing".equals(ns.getNamespaceURI())) continue;
            om.detach();
        }
    }
}

