/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.statistics;

import org.apache.synapse.MessageContext;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.statistics.StatisticsCollector;
import org.apache.synapse.statistics.impl.EndPointStatisticsStack;
import org.apache.synapse.statistics.impl.ProxyServiceStatisticsStack;
import org.apache.synapse.statistics.impl.SequenceStatisticsStack;

public class StatisticsUtils {
    public static void processProxyServiceStatistics(MessageContext synCtx) {
        ProxyServiceStatisticsStack synapseServiceStatisticsStack;
        StatisticsCollector statisticsCollector = StatisticsUtils.getStatisticsCollector(synCtx);
        boolean isFault = synCtx.getEnvelope().getBody().hasFault();
        ProxyServiceStatisticsStack proxyServiceStatisticsStack = (ProxyServiceStatisticsStack)synCtx.getProperty("synapse.proxy.stats");
        if (proxyServiceStatisticsStack != null) {
            proxyServiceStatisticsStack.reportToStatisticsCollector(statisticsCollector, isFault);
        }
        if ((synapseServiceStatisticsStack = (ProxyServiceStatisticsStack)synCtx.getProperty("synapse.service.stats")) != null) {
            synapseServiceStatisticsStack.reportToStatisticsCollector(statisticsCollector, isFault);
        }
    }

    public static void processEndPointStatistics(MessageContext synCtx) {
        Object endpointObj;
        StatisticsCollector statisticsCollector = StatisticsUtils.getStatisticsCollector(synCtx);
        boolean isFault = synCtx.getEnvelope().getBody().hasFault();
        EndPointStatisticsStack endPointStatisticsStack = (EndPointStatisticsStack)synCtx.getProperty("synapse.endpoint.stats");
        if (endPointStatisticsStack != null && (endpointObj = synCtx.getProperty("processed_endpoint")) instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)endpointObj;
            String name = endpoint.getName();
            if (name == null) {
                endPointStatisticsStack.reportToStatisticsCollector(statisticsCollector, isFault);
            } else {
                endPointStatisticsStack.reportToStatisticsCollector(statisticsCollector, isFault, name);
            }
            endPointStatisticsStack.reportAllToStatisticsCollector(statisticsCollector, true);
        }
    }

    public static void processSequenceStatistics(MessageContext synCtx) {
        StatisticsCollector statisticsCollector = StatisticsUtils.getStatisticsCollector(synCtx);
        boolean isFault = synCtx.getEnvelope().getBody().hasFault();
        SequenceStatisticsStack sequenceStatisticsStack = (SequenceStatisticsStack)synCtx.getProperty("synapse.sequence.stats");
        if (sequenceStatisticsStack != null) {
            sequenceStatisticsStack.reportToStatisticsCollector(statisticsCollector, isFault);
        }
    }

    public static void processAllSequenceStatistics(MessageContext synCtx) {
        StatisticsCollector statisticsCollector = StatisticsUtils.getStatisticsCollector(synCtx);
        boolean isFault = synCtx.getEnvelope().getBody().hasFault();
        SequenceStatisticsStack sequenceStatisticsStack = (SequenceStatisticsStack)synCtx.getProperty("synapse.sequence.stats");
        if (sequenceStatisticsStack != null) {
            sequenceStatisticsStack.reportAllToStatisticsCollector(statisticsCollector, isFault);
        }
    }

    private static StatisticsCollector getStatisticsCollector(MessageContext synCtx) {
        SynapseEnvironment synEnv = synCtx.getEnvironment();
        StatisticsCollector statisticsCollector = null;
        if (synEnv != null && (statisticsCollector = synEnv.getStatisticsCollector()) == null) {
            statisticsCollector = new StatisticsCollector();
            synEnv.setStatisticsCollector(statisticsCollector);
        }
        return statisticsCollector;
    }
}

