/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.transport.base.BaseConstants;
import org.apache.synapse.util.FixedByteArrayOutputStream;
import org.apache.synapse.util.TextFileDataSource;
import org.jaxen.JaxenException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLTMediator
extends AbstractMediator {
    private static final int BYTE_ARRAY_SIZE = 8192;
    public static final String USE_DOM_SOURCE_AND_RESULTS = "http://ws.apache.org/ns/synapse/transform/feature/dom";
    private String xsltKey = null;
    private String sourceXPathString = null;
    private AXIOMXPath source = null;
    private String targetPropertyName = null;
    private List properties = new ArrayList();
    private List explicitFeatures = new ArrayList();
    private Templates cachedTemplates = null;
    private final TransformerFactory transFact = TransformerFactory.newInstance();
    private final Object transformerLock = new Object();
    private boolean useDOMSourceAndResults = false;
    public static final String DEFAULT_XPATH = "s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]";

    public XSLTMediator() {
        try {
            this.source = new AXIOMXPath(DEFAULT_XPATH);
            this.source.addNamespace("s11", "http://schemas.xmlsoap.org/soap/envelope/");
            this.source.addNamespace("s12", "http://www.w3.org/2003/05/soap-envelope");
        }
        catch (JaxenException e) {
            String msg = "Error creating default source XPath expression : s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]";
            this.log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : XSLT mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        try {
            this.performXSLT(synCtx, traceOrDebugOn, traceOn);
        }
        catch (Exception e) {
            this.handleException("Unable to perform XSLT transformation using : " + this.xsltKey + " against source XPath : " + (this.sourceXPathString == null ? DEFAULT_XPATH : " source XPath : " + this.sourceXPathString), e, synCtx);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : XSLT mediator");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performXSLT(MessageContext synCtx, boolean traceOrDebugOn, boolean traceOn) {
        Object osForSource;
        boolean isSoapBody;
        boolean reCreate = false;
        OMNode sourceNode = this.getTransformSource(synCtx);
        FileOutputStream osForTarget = null;
        ByteArrayInputStream isForSource = null;
        FixedByteArrayOutputStream baosForTarget = new FixedByteArrayOutputStream(8192);
        File tempTargetFile = null;
        File tempSourceFile = null;
        boolean isSoapEnvelope = sourceNode == synCtx.getEnvelope();
        boolean bl = isSoapBody = sourceNode == synCtx.getEnvelope().getBody();
        if (traceOrDebugOn) {
            trace.trace((Object)("Transformation source : " + sourceNode.toString()));
        }
        Source transformSrc = null;
        Result transformTgt = null;
        if (this.useDOMSourceAndResults) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Using a DOMSource for transformation");
            }
            transformSrc = new DOMSource(((Element)ElementHelper.importOMElement((OMElement)((OMElement)sourceNode), (OMFactory)DOOMAbstractFactory.getOMFactory())).getOwnerDocument());
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)true);
            try {
                transformTgt = new DOMResult(DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().newDocument());
            }
            catch (ParserConfigurationException e) {
                this.handleException("Error creating a DOMResult for the transformation, Consider setting optimization feature : http://ws.apache.org/ns/synapse/transform/feature/dom off", e, synCtx);
            }
        } else {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Using byte array serialization for transformation");
            }
            try {
                FixedByteArrayOutputStream baosForSource = new FixedByteArrayOutputStream(8192);
                XMLStreamWriter xsWriterForSource = XMLOutputFactory.newInstance().createXMLStreamWriter(baosForSource);
                sourceNode.serialize(xsWriterForSource);
                isForSource = new ByteArrayInputStream(baosForSource.toByteArray());
                transformSrc = new StreamSource(isForSource);
                transformTgt = new StreamResult(baosForTarget);
            }
            catch (XMLStreamException e) {
                this.handleException("Error creating a StreamResult for the transformation", e, synCtx);
            }
            catch (SynapseException x) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Error creating a StreamResult using a byte array - attempting using temporary files for serialization");
                }
                osForSource = null;
                try {
                    tempSourceFile = File.createTempFile("xs_", ".xml");
                    tempTargetFile = File.createTempFile("xt_", ".xml");
                    osForSource = new FileOutputStream(tempSourceFile);
                    osForTarget = new FileOutputStream(tempTargetFile);
                    XMLStreamWriter xsWriterForSource = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)osForSource);
                    sourceNode.serialize(xsWriterForSource);
                    transformSrc = new StreamSource(tempSourceFile);
                    transformTgt = new StreamResult(osForTarget);
                }
                catch (XMLStreamException e) {
                    this.handleException("Error creating a StreamResult for the transformation", e, synCtx);
                }
                catch (IOException e) {
                    this.handleException("Error using a temporary file/s for the transformation", e, synCtx);
                }
                finally {
                    try {
                        ((OutputStream)osForSource).close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        if (transformTgt == null) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Was unable to get a javax.xml.transform.Result created");
            }
            return;
        }
        Entry dp = synCtx.getConfiguration().getEntryDefinition(this.xsltKey);
        if (dp != null && dp.isDynamic() && (!dp.isCached() || dp.isExpired())) {
            reCreate = true;
        }
        osForSource = this.transformerLock;
        synchronized (osForSource) {
            if (reCreate || this.cachedTemplates == null) {
                try {
                    this.cachedTemplates = this.transFact.newTemplates(SynapseConfigUtils.getStreamSource(synCtx.getEntry(this.xsltKey)));
                    if (this.cachedTemplates == null) {
                        this.handleException("Error compiling the XSLT with key : " + this.xsltKey, synCtx);
                    }
                }
                catch (Exception e) {
                    this.handleException("Error creating XSLT transformer using : " + this.xsltKey, e, synCtx);
                }
            }
        }
        try {
            XMLStreamReader reader;
            boolean deleted;
            Transformer transformer = this.cachedTemplates.newTransformer();
            if (!this.properties.isEmpty()) {
                for (int i = 0; i < this.properties.size(); ++i) {
                    MediatorProperty prop = (MediatorProperty)this.properties.get(i);
                    if (prop == null) continue;
                    if (prop.getValue() != null) {
                        transformer.setParameter(prop.getName(), prop.getValue());
                        continue;
                    }
                    transformer.setParameter(prop.getName(), Axis2MessageContext.getStringValue(prop.getExpression(), synCtx));
                }
            }
            try {
                transformer.transform(transformSrc, transformTgt);
            }
            catch (TransformerException x) {
                try {
                    tempTargetFile = File.createTempFile("xt_", ".xml");
                    osForTarget = new FileOutputStream(tempTargetFile);
                    transformTgt = new StreamResult(osForTarget);
                    ((InputStream)isForSource).reset();
                    transformer.reset();
                    transformer.transform(transformSrc, transformTgt);
                }
                catch (IOException e) {
                    this.handleException("Error using a temporary file/s for the transformation", e, synCtx);
                }
            }
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Transformation completed - processing result");
            }
            if (tempSourceFile != null && !(deleted = tempSourceFile.delete())) {
                tempSourceFile.deleteOnExit();
            }
            Object result = null;
            if (transformTgt instanceof DOMResult) {
                Node node = ((DOMResult)transformTgt).getNode();
                if (node == null) {
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "Transformation result (DOMResult) was null");
                    }
                    return;
                }
                Node resultNode = node.getFirstChild();
                if (resultNode == null) {
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "Transformation result (DOMResult) was empty");
                    }
                    return;
                }
                result = ElementHelper.importOMElement((OMElement)((OMElement)resultNode), (OMFactory)OMAbstractFactory.getOMFactory());
            } else if (tempTargetFile != null) {
                try {
                    reader = StAXUtils.createXMLStreamReader((InputStream)new FileInputStream(tempTargetFile));
                    if (isSoapEnvelope) {
                        result = new StAXSOAPModelBuilder(reader).getSOAPEnvelope();
                    }
                    result = new StAXOMBuilder(reader).getDocumentElement();
                }
                catch (XMLStreamException e) {
                    this.handleException("Error building result element from XSLT transformation", e, synCtx);
                }
                catch (Exception e) {
                    result = this.handleNonXMLResult(tempTargetFile, traceOrDebugOn, traceOn);
                }
                finally {
                    boolean deleted2 = tempTargetFile.delete();
                    if (!deleted2) {
                        tempTargetFile.deleteOnExit();
                    }
                }
            } else {
                try {
                    reader = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(baosForTarget.toByteArray()));
                    result = isSoapEnvelope ? new StAXSOAPModelBuilder(reader).getSOAPEnvelope() : new StAXOMBuilder(reader).getDocumentElement();
                }
                catch (XMLStreamException e) {
                    this.handleException("Error building result element from XSLT transformation", e, synCtx);
                }
                catch (Exception e) {
                    result = this.handleNonXMLResult(baosForTarget.toString(), traceOrDebugOn, traceOn);
                }
            }
            if (result == null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Transformation result was null");
                }
                return;
            }
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Transformation result : " + result.toString()));
            }
            if (this.targetPropertyName != null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Adding result as message context property : " + this.targetPropertyName);
                }
                synCtx.setProperty(this.targetPropertyName, result);
            } else {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Replace " + (isSoapEnvelope ? "SOAP envelope" : (isSoapBody ? "SOAP body" : "node")) + " with result");
                }
                if (isSoapEnvelope) {
                    try {
                        synCtx.setEnvelope((SOAPEnvelope)result);
                    }
                    catch (AxisFault ex) {
                        this.handleException("Unable to replace SOAP envelope with result", (Exception)((Object)ex), synCtx);
                    }
                } else if (isSoapBody) {
                    OMElement child;
                    Iterator iter = synCtx.getEnvelope().getBody().getChildElements();
                    while (iter.hasNext()) {
                        child = (OMElement)iter.next();
                        child.detach();
                    }
                    iter = result.getChildElements();
                    while (iter.hasNext()) {
                        child = (OMElement)iter.next();
                        synCtx.getEnvelope().getBody().addChild((OMNode)child);
                    }
                } else {
                    sourceNode.insertSiblingAfter((OMNode)result);
                    sourceNode.detach();
                }
            }
        }
        catch (TransformerException e) {
            this.handleException("Error performing XSLT transformation using : " + this.xsltKey, e, synCtx);
        }
    }

    private OMNode getTransformSource(MessageContext synCtx) {
        try {
            Object o = this.source.evaluate((Object)synCtx.getEnvelope());
            if (o instanceof OMNode) {
                return (OMNode)o;
            }
            if (o instanceof List && !((List)o).isEmpty()) {
                return (OMNode)((List)o).get(0);
            }
            this.handleException("The evaluation of the XPath expression " + this.source + " did not result in an OMNode", synCtx);
        }
        catch (JaxenException e) {
            this.handleException("Error evaluating XPath expression : " + this.source, (Exception)((Object)e), synCtx);
        }
        return null;
    }

    public AXIOMXPath getSource() {
        return this.source;
    }

    public void setSource(AXIOMXPath source) {
        this.source = source;
    }

    public String getXsltKey() {
        return this.xsltKey;
    }

    public void setXsltKey(String xsltKey) {
        this.xsltKey = xsltKey;
    }

    public void addProperty(MediatorProperty p) {
        this.properties.add(p);
    }

    public void addFeature(String featureName, boolean isFeatureEnable) {
        try {
            MediatorProperty mp = new MediatorProperty();
            mp.setName(featureName);
            if (isFeatureEnable) {
                mp.setValue("true");
            } else {
                mp.setValue("false");
            }
            this.explicitFeatures.add(mp);
            if (USE_DOM_SOURCE_AND_RESULTS.equals(featureName)) {
                this.useDOMSourceAndResults = isFeatureEnable;
            } else {
                this.transFact.setFeature(featureName, isFeatureEnable);
            }
        }
        catch (TransformerConfigurationException e) {
            String msg = "Error occured when setting features to the TransformerFactory";
            this.log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    private OMElement handleNonXMLResult(File file, boolean traceOrDebugOn, boolean traceOn) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMSourcedElementImpl wrapper = null;
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Processing non SOAP/XML (text) transformation result");
        }
        if (traceOn && trace.isTraceEnabled()) {
            trace.trace((Object)("Wrapping text transformation result from : " + file));
        }
        if (file != null) {
            TextFileDataSource txtFileDS = new TextFileDataSource((DataSource)new FileDataSource(file));
            wrapper = new OMSourcedElementImpl(BaseConstants.DEFAULT_TEXT_WRAPPER, fac, (OMDataSource)txtFileDS);
        }
        return wrapper;
    }

    private OMElement handleNonXMLResult(String textPayload, boolean traceOrDebugOn, boolean traceOn) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement wrapper = null;
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Processing non SOAP/XML (text) transformation result");
        }
        if (traceOn && trace.isTraceEnabled()) {
            trace.trace((Object)("Wrapping text transformation result : " + textPayload));
        }
        if (textPayload != null) {
            OMTextImpl textData = (OMTextImpl)fac.createOMText(textPayload);
            wrapper = fac.createOMElement(BaseConstants.DEFAULT_TEXT_WRAPPER, null);
            wrapper.addChild((OMNode)textData);
        }
        return wrapper;
    }

    public List getFeatures() {
        return this.explicitFeatures;
    }

    public void addAllProperties(List list) {
        this.properties.addAll(list);
    }

    public List getProperties() {
        return this.properties;
    }

    public void setSourceXPathString(String sourceXPathString) {
        this.sourceXPathString = sourceXPathString;
    }

    public String getTargetPropertyName() {
        return this.targetPropertyName;
    }

    public void setTargetPropertyName(String targetPropertyName) {
        this.targetPropertyName = targetPropertyName;
    }
}

