/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.filters;

import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.FilterMediator;

public class InMediator
extends AbstractListMediator
implements FilterMediator {
    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : In mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        boolean result = true;
        if (this.test(synCtx)) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Current message is incoming - executing child mediators");
            }
            result = super.mediate(synCtx);
        } else if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Current message is a response - skipping child mediators");
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : In mediator");
        }
        return result;
    }

    public boolean test(MessageContext synCtx) {
        return !synCtx.isResponse();
    }
}

