/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.ext;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.Command;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.annotations.Namespaces;
import org.apache.synapse.mediators.annotations.ReadAndUpdate;
import org.apache.synapse.mediators.annotations.ReadFromMessage;
import org.apache.synapse.mediators.annotations.UpdateMessage;
import org.apache.synapse.mediators.ext.POJOCommandMediator;
import org.jaxen.JaxenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedCommandMediator
extends POJOCommandMediator {
    protected Map<Field, AXIOMXPath> beforeFields;
    protected Map<Method, AXIOMXPath> beforeMethods;
    protected Map<Field, AXIOMXPath> afterFields;
    protected Map<Method, AXIOMXPath> afterMethods;

    @Override
    public boolean mediate(MessageContext synCtx) {
        String v;
        AXIOMXPath xpath;
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : POJOCommand mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Creating a new instance of POJO class : " + this.getCommand().getClass());
        }
        Object commandObject = null;
        try {
            commandObject = this.getCommand().newInstance();
        }
        catch (Exception e) {
            this.handleException("Error creating an instance of the POJO command class : " + this.getCommand().getClass(), e, synCtx);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Instance created, setting static and dynamic properties");
        }
        for (String name : this.getStaticSetterProperties().keySet()) {
            this.setInstanceProperty(name, (String)this.getStaticSetterProperties().get(name), commandObject, synCtx);
        }
        for (Field f : this.beforeFields.keySet()) {
            xpath = this.beforeFields.get(f);
            if (!f.getType().equals(String.class)) {
                throw new UnsupportedOperationException("non-String types not supportted yet");
            }
            v = Axis2MessageContext.getStringValue(xpath, synCtx);
            try {
                f.set(commandObject, v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Method m : this.beforeMethods.keySet()) {
            xpath = this.beforeMethods.get(m);
            if (m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].equals(String.class)) {
                throw new UnsupportedOperationException("non-String types not supportted yet");
            }
            v = Axis2MessageContext.getStringValue(xpath, synCtx);
            try {
                m.invoke(commandObject, v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "POJO initialized successfully, invoking the execute() method");
        }
        if (commandObject instanceof Command) {
            try {
                ((Command)commandObject).execute();
            }
            catch (Exception e) {
                this.handleException("Error invoking POJO command class : " + this.getCommand().getClass(), e, synCtx);
            }
        } else {
            Method exeMethod = null;
            try {
                exeMethod = this.getCommand().getMethod("execute", new Class[0]);
                exeMethod.invoke(commandObject, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.handleException("Cannot locate an execute() method on POJO class : " + this.getCommand().getClass(), e, synCtx);
            }
            catch (Exception e) {
                this.handleException("Error invoking the execute() method on POJO class : " + this.getCommand().getClass(), e, synCtx);
            }
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : POJOCommand mediator");
        }
        return true;
    }

    @Override
    public void setCommand(Class commandClass) {
        super.setCommand(commandClass);
        this.introspectClass(commandClass);
    }

    protected void introspectClass(Class<?> commandClass) {
        AXIOMXPath axiomXpath;
        UpdateMessage updateMessage;
        ReadFromMessage readFromMessage;
        this.beforeFields = new HashMap<Field, AXIOMXPath>();
        this.afterFields = new HashMap<Field, AXIOMXPath>();
        this.beforeMethods = new HashMap<Method, AXIOMXPath>();
        this.afterMethods = new HashMap<Method, AXIOMXPath>();
        for (Field field : commandClass.getDeclaredFields()) {
            ReadAndUpdate readAndUpdate;
            readFromMessage = field.getAnnotation(ReadFromMessage.class);
            if (readFromMessage != null) {
                AXIOMXPath axiomXpath2 = this.createAxiomXPATH(readFromMessage.value(), field.getAnnotation(Namespaces.class));
                this.beforeFields.put(field, axiomXpath2);
            }
            if ((updateMessage = field.getAnnotation(UpdateMessage.class)) != null) {
                axiomXpath = this.createAxiomXPATH(updateMessage.value(), field.getAnnotation(Namespaces.class));
                this.afterFields.put(field, axiomXpath);
            }
            if ((readAndUpdate = field.getAnnotation(ReadAndUpdate.class)) == null) continue;
            AXIOMXPath axiomXpath3 = this.createAxiomXPATH(readAndUpdate.value(), field.getAnnotation(Namespaces.class));
            this.beforeFields.put(field, axiomXpath3);
            this.afterFields.put(field, axiomXpath3);
        }
        for (AccessibleObject accessibleObject : commandClass.getDeclaredMethods()) {
            readFromMessage = ((Method)accessibleObject).getAnnotation(ReadFromMessage.class);
            if (readFromMessage != null) {
                AXIOMXPath axiomXpath2 = this.createAxiomXPATH(readFromMessage.value(), ((Method)accessibleObject).getAnnotation(Namespaces.class));
                this.beforeMethods.put((Method)accessibleObject, axiomXpath2);
            }
            if ((updateMessage = ((Method)accessibleObject).getAnnotation(UpdateMessage.class)) == null) continue;
            axiomXpath = this.createAxiomXPATH(updateMessage.value(), ((Method)accessibleObject).getAnnotation(Namespaces.class));
            this.afterMethods.put((Method)accessibleObject, axiomXpath);
        }
    }

    protected AXIOMXPath createAxiomXPATH(String xpath, Namespaces nsAnnotation) {
        Map<String, String> namespaces = this.getNamespaces(nsAnnotation);
        try {
            AXIOMXPath axiomXPath = new AXIOMXPath(xpath);
            for (String prefix : namespaces.keySet()) {
                axiomXPath.addNamespace(prefix, namespaces.get(prefix));
            }
            return axiomXPath;
        }
        catch (JaxenException e) {
            throw new RuntimeException("Error creating AXIOMXPath: " + xpath, e);
        }
    }

    protected Map<String, String> getNamespaces(Namespaces namespaces) {
        String namespace;
        String prefix;
        int i;
        HashMap<String, String> allNamespaces = new HashMap<String, String>();
        Namespaces defaultNamespaces = this.getCommand().getAnnotation(Namespaces.class);
        if (defaultNamespaces != null) {
            for (String namespaceValue : defaultNamespaces.value()) {
                i = namespaceValue.indexOf(58);
                if (i <= 0) continue;
                prefix = namespaceValue.substring(0, i);
                namespace = namespaceValue.substring(i + 1);
                allNamespaces.put(prefix, namespace);
            }
        }
        if (namespaces != null) {
            for (String namespaceValue : namespaces.value()) {
                i = namespaceValue.indexOf(58);
                if (i <= 0) continue;
                prefix = namespaceValue.substring(0, i);
                namespace = namespaceValue.substring(i + 1);
                allNamespaces.put(prefix, namespace);
            }
        }
        return allNamespaces;
    }
}

