/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip;

import org.apache.axis2.addressing.EndpointReference;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;

public class Target {
    private String toAddress = null;
    private String soapAction = null;
    private SequenceMediator sequence = null;
    private String sequenceRef = null;
    private Endpoint endpoint = null;
    private String endpointRef = null;

    public void mediate(MessageContext synCtx) {
        Endpoint epr;
        if (this.soapAction != null) {
            synCtx.setSoapAction(this.soapAction);
        }
        if (this.toAddress != null) {
            if (synCtx.getTo() != null) {
                synCtx.getTo().setAddress(this.toAddress);
            } else {
                synCtx.setTo(new EndpointReference(this.toAddress));
            }
        }
        if (this.sequence != null) {
            synCtx.getEnvironment().injectAsync(synCtx, this.sequence);
        } else if (this.sequenceRef != null) {
            SequenceMediator refSequence = (SequenceMediator)synCtx.getSequence(this.sequenceRef);
            if (refSequence != null) {
                synCtx.getEnvironment().injectAsync(synCtx, refSequence);
            }
        } else if (this.endpoint != null) {
            this.endpoint.send(synCtx);
        } else if (this.endpointRef != null && (epr = synCtx.getConfiguration().getEndpoint(this.endpointRef)) != null) {
            epr.send(synCtx);
        }
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public SequenceMediator getSequence() {
        return this.sequence;
    }

    public void setSequence(SequenceMediator sequence) {
        this.sequence = sequence;
    }

    public String getSequenceRef() {
        return this.sequenceRef;
    }

    public void setSequenceRef(String sequenceRef) {
        this.sequenceRef = sequenceRef;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpointRef() {
        return this.endpointRef;
    }

    public void setEndpointRef(String endpointRef) {
        this.endpointRef = endpointRef;
    }
}

