/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.db.AbstractDBMediator;
import org.apache.synapse.mediators.db.Statement;

public class DBReportMediator
extends AbstractDBMediator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStatement(Statement stmnt, MessageContext msgCtx) {
        boolean traceOn = this.isTraceOn(msgCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        Connection con = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(stmnt, msgCtx);
            con = ps.getConnection();
            int count = ps.executeUpdate();
            if (count > 0) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Inserted " + count + " row/s using statement : " + stmnt.getRawStatement());
                }
            } else if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "No rows were inserted for statement : " + stmnt.getRawStatement());
            }
            con.commit();
        }
        catch (SQLException e) {
            this.handleException("Error execuring insert statement : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName(), e, msgCtx);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }
}

