/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.Entry;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.UUIDGenerator;
import org.jaxen.JaxenException;

public class RMSequenceMediator
extends AbstractMediator {
    private AXIOMXPath correlation = null;
    private AXIOMXPath lastMessage = null;
    private Boolean single = null;
    private String version = null;
    private static final String WSRM_SpecVersion_1_0 = "Spec_2005_02";
    private static final String WSRM_SpecVersion_1_1 = "Spec_2007_02";
    private static final long SEQUENCE_EXPIRY_TIME = 300000L;
    private static Map sequenceMap = Collections.synchronizedMap(new HashMap());

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : RMSequence mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (!(synCtx instanceof Axis2MessageContext)) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Only axis2 message contexts are supported");
            }
        } else {
            Axis2MessageContext axis2MessageCtx = (Axis2MessageContext)synCtx;
            org.apache.axis2.context.MessageContext orgMessageCtx = axis2MessageCtx.getAxis2MessageContext();
            this.cleanupSequenceMap();
            String version = this.getVersionValue();
            orgMessageCtx.getOptions().setProperty("Sandesha2RMSpecVersion", (Object)version);
            if (this.isSingle()) {
                String sequenceID = UUIDGenerator.getUUID();
                String offeredSeqID = UUIDGenerator.getUUID();
                orgMessageCtx.getOptions().setProperty("Sandesha2SequenceKey", (Object)sequenceID);
                orgMessageCtx.getOptions().setProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID, (Object)offeredSeqID);
                orgMessageCtx.getOptions().setProperty("Sandesha2LastMessage", (Object)"true");
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Using WS-RM version " + version + " and a single message sequence : " + sequenceID + " and offering sequence : " + offeredSeqID);
                }
            } else {
                String correlationValue = this.getCorrelationValue(synCtx);
                boolean lastMessage = this.isLastMessage(synCtx);
                String offeredSeqID = null;
                if (!sequenceMap.containsKey(correlationValue)) {
                    offeredSeqID = UUIDGenerator.getUUID();
                    orgMessageCtx.getOptions().setProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID, (Object)offeredSeqID);
                }
                String sequenceID = this.retrieveSequenceID(correlationValue);
                orgMessageCtx.getOptions().setProperty("Sandesha2SequenceKey", (Object)sequenceID);
                if (lastMessage) {
                    orgMessageCtx.getOptions().setProperty("Sandesha2LastMessage", (Object)"true");
                    sequenceMap.remove(correlationValue);
                }
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Correlation value : " + correlationValue + " last message = " + lastMessage + " using sequence : " + sequenceID + (offeredSeqID != null ? " offering sequence : " + offeredSeqID : ""));
                }
            }
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : RMSequence mediator");
        }
        return true;
    }

    private String retrieveSequenceID(String correlationValue) {
        String sequenceID = null;
        if (!sequenceMap.containsKey(correlationValue)) {
            sequenceID = UUIDGenerator.getUUID();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("setting sequenceID " + sequenceID + " for correlation " + correlationValue));
            }
            Entry sequenceEntry = new Entry();
            sequenceEntry.setValue(sequenceID);
            sequenceEntry.setExpiryTime(System.currentTimeMillis() + 300000L);
            sequenceMap.put(correlationValue, sequenceEntry);
        } else {
            sequenceID = (String)((Entry)sequenceMap.get(correlationValue)).getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("got sequenceID " + sequenceID + " for correlation " + correlationValue));
            }
        }
        return sequenceID;
    }

    private String getCorrelationValue(MessageContext smc) {
        OMElement node = null;
        try {
            node = (OMElement)this.getCorrelation().selectSingleNode((Object)smc.getEnvelope());
            if (node != null) {
                return node.getText();
            }
            this.handleException("XPath expression : " + this.getCorrelation() + " did not return any node", smc);
        }
        catch (JaxenException e) {
            this.handleException("Error evaluating XPath expression to determine correlation : " + this.getCorrelation(), (Exception)((Object)e), smc);
        }
        return null;
    }

    private String getVersionValue() {
        if ("1.1".equals(this.getVersion())) {
            return WSRM_SpecVersion_1_1;
        }
        return WSRM_SpecVersion_1_0;
    }

    private boolean isLastMessage(MessageContext smc) {
        if (this.getLastMessage() == null) {
            return false;
        }
        try {
            return this.getLastMessage().booleanValueOf((Object)smc.getEnvelope());
        }
        catch (JaxenException e) {
            this.handleException("Error evaluating XPath expression to determine if last message : " + this.getLastMessage(), (Exception)((Object)e), smc);
            return false;
        }
    }

    private synchronized void cleanupSequenceMap() {
        for (Object key : sequenceMap.keySet()) {
            Entry sequenceEntry = (Entry)sequenceMap.get(key);
            if (!sequenceEntry.isExpired()) continue;
            sequenceMap.remove(key);
        }
    }

    public boolean isSingle() {
        return this.getSingle() != null && this.getSingle() != false;
    }

    public AXIOMXPath getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(AXIOMXPath correlation) {
        this.correlation = correlation;
    }

    public AXIOMXPath getLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(AXIOMXPath lastMessage) {
        this.lastMessage = lastMessage;
    }

    public Boolean getSingle() {
        return this.single;
    }

    public void setSingle(Boolean single) {
        this.single = single;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

