/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.base;

import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.statistics.StatisticsStack;
import org.apache.synapse.statistics.StatisticsUtils;
import org.apache.synapse.statistics.impl.SequenceStatisticsStack;

public class SynapseMediator
extends AbstractListMediator {
    public boolean mediate(MessageContext synCtx) {
        StatisticsStack sequenceStack;
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Mediation using 'main' sequence Message is a : " + (synCtx.isResponse() ? "response" : "request"));
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (synCtx.isResponse()) {
            StatisticsUtils.processAllSequenceStatistics(synCtx);
        }
        if ((sequenceStack = (StatisticsStack)synCtx.getProperty("synapse.sequence.stats")) == null) {
            sequenceStack = new SequenceStatisticsStack();
            synCtx.setProperty("synapse.sequence.stats", sequenceStack);
        }
        String seqName = "MainSequence";
        boolean isFault = synCtx.getEnvelope().getBody().hasFault();
        sequenceStack.put(seqName, System.currentTimeMillis(), !synCtx.isResponse(), true, isFault);
        boolean result = super.mediate(synCtx);
        if (traceOrDebugOn) {
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
            this.traceOrDebug(traceOn, "End : Mediation using 'main' sequence");
        }
        return result;
    }
}

