/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class GetPropertyFunction
implements Function {
    private static final Log log = LogFactory.getLog(GetPropertyFunction.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    public static final String NULL_STRING = "";
    private MessageContext synCtx = null;

    public MessageContext getSynCtx() {
        return this.synCtx;
    }

    public void setSynCtx(MessageContext synCtx) {
        this.synCtx = synCtx;
    }

    public Object call(Context context, List args) throws FunctionCallException {
        boolean traceOrDebugOn;
        boolean traceOn = this.synCtx.getTracingState() == 1;
        boolean bl = traceOrDebugOn = traceOn || log.isDebugEnabled();
        if (args == null || args.size() == 0) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Property key value for lookup is not specified");
            }
            return NULL_STRING;
        }
        int size = args.size();
        if (size == 1) {
            return this.evaluate("default", args.get(0), null, context.getNavigator());
        }
        if (size == 2) {
            String argOne = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            if (argOne != null) {
                if (!("axis2".equals(argOne) || "default".equals(argOne) || "transport".equals(argOne))) {
                    return this.evaluate("default", args.get(0), args.get(1), context.getNavigator());
                }
                return this.evaluate(args.get(0), args.get(1), null, context.getNavigator());
            }
        } else {
            if (size == 3) {
                return this.evaluate(args.get(0), args.get(1), args.get(2), context.getNavigator());
            }
            String msg = "Invalid arguments for synapse:get-property(prop-name) 0r  synapse:get-property(scope, prop-name) XPath function ";
            if (traceOn) {
                trace.error((Object)msg);
            }
            log.error((Object)msg);
            throw new FunctionCallException(msg);
        }
        return NULL_STRING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object evaluate(Object scopeObject, Object keyObject, Object dateformat, Navigator navigator) {
        boolean traceOrDebugOn;
        boolean traceOn = this.synCtx.getTracingState() == 1;
        boolean bl = traceOrDebugOn = traceOn || log.isDebugEnabled();
        if (this.synCtx == null) {
            if (!traceOrDebugOn) return null;
            this.traceOrDebug(traceOn, "Synapse message context has not been set for the XPath extension function 'synapse:get-property(prop-name)'");
            return null;
        }
        String scope = StringFunction.evaluate((Object)scopeObject, (Navigator)navigator);
        String key = StringFunction.evaluate((Object)keyObject, (Navigator)navigator);
        if (key == null || NULL_STRING.equals(key)) {
            if (!traceOrDebugOn) return NULL_STRING;
            this.traceOrDebug(traceOn, "property-name should be provided when executing synapse:get-property(scope,prop-name) or synapse:get-property(prop-name) Xpath function");
            return NULL_STRING;
        }
        if ("SYSTEM_DATE".equals(key)) {
            if (dateformat != null) {
                SimpleDateFormat formatter = new SimpleDateFormat(dateformat.toString());
                return formatter.format((Object)new Date());
            }
            SimpleDateFormat formatter = new SimpleDateFormat();
            return formatter.format((Object)new Date());
        }
        if ("SYSTEM_TIME".equals(key)) {
            return Long.toString(System.currentTimeMillis());
        }
        if ("default".equals(scope)) {
            if ("To".equals(key)) {
                EndpointReference toEPR = this.synCtx.getTo();
                if (toEPR == null) return NULL_STRING;
                return toEPR.getAddress();
            }
            if ("From".equals(key)) {
                EndpointReference fromEPR = this.synCtx.getFrom();
                if (fromEPR == null) return NULL_STRING;
                return fromEPR.getAddress();
            }
            if ("Action".equals(key)) {
                String wsaAction = this.synCtx.getWSAAction();
                if (wsaAction == null) return NULL_STRING;
                return wsaAction;
            }
            if ("FaultTo".equals(key)) {
                EndpointReference faultEPR = this.synCtx.getFaultTo();
                if (faultEPR == null) return NULL_STRING;
                return faultEPR.getAddress();
            }
            if ("ReplyTo".equals(key)) {
                EndpointReference replyToEPR = this.synCtx.getReplyTo();
                if (replyToEPR == null) return NULL_STRING;
                return replyToEPR.getAddress();
            }
            if ("MessageID".equals(key)) {
                String messageID = this.synCtx.getMessageID();
                if (messageID == null) return NULL_STRING;
                return messageID;
            }
            if ("MESSAGE_FORMAT".equals(key)) {
                if (this.synCtx.isDoingPOX()) {
                    return "pox";
                }
                if (this.synCtx.isDoingGET()) {
                    return "get";
                }
                if (!this.synCtx.isSOAP11()) return "soap12";
                return "soap11";
            }
            if ("OperationName".equals(key) || "OperationNamespace".equals(key)) {
                AxisOperation axisOperation;
                if (!(this.synCtx instanceof Axis2MessageContext) || (axisOperation = ((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getAxisOperation()) == null) return NULL_STRING;
                if (!"OperationNamespace".equals(key)) return axisOperation.getName().getLocalPart();
                return axisOperation.getName().getNamespaceURI();
            }
            Object result = this.synCtx.getProperty(key);
            if (result == null) return this.synCtx.getEntry(key);
            return result;
        }
        if ("axis2".equals(scope) && this.synCtx instanceof Axis2MessageContext) {
            org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)this.synCtx).getAxis2MessageContext();
            return axis2MessageContext.getProperty(key);
        }
        if ("transport".equals(scope) && this.synCtx instanceof Axis2MessageContext) {
            org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)this.synCtx).getAxis2MessageContext();
            Object headers = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
            if (headers == null || !(headers instanceof Map)) return NULL_STRING;
            HashMap headersMap = (HashMap)headers;
            return headersMap.get(key);
        }
        if (!traceOrDebugOn) return NULL_STRING;
        this.traceOrDebug(traceOn, "Invalid scope : '" + scope + "' has been set for the " + "synapse:get-property(scope,prop-name) XPath function");
        return NULL_STRING;
    }

    private void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }
}

