/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.statistics.impl.ProxyServiceStatisticsStack;

public class SynapseMessageReceiver
implements MessageReceiver {
    private static final Log log = LogFactory.getLog(SynapseMessageReceiver.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");

    public void receive(org.apache.axis2.context.MessageContext mc) throws AxisFault {
        boolean traceOrDebugOn;
        MessageContext synCtx = MessageContextCreatorForAxis2.getSynapseMessageContext(mc);
        boolean traceOn = synCtx.getMainSequence().getTraceState() == 1;
        boolean bl = traceOrDebugOn = traceOn || log.isDebugEnabled();
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Synapse received a new message for message mediation...");
            this.traceOrDebug(traceOn, "Received To: " + (mc.getTo() != null ? mc.getTo().getAddress() : "null"));
            this.traceOrDebug(traceOn, "SOAPAction: " + (mc.getSoapAction() != null ? mc.getSoapAction() : "null"));
            this.traceOrDebug(traceOn, "WSA-Action: " + (mc.getWSAAction() != null ? mc.getWSAAction() : "null"));
            if (traceOn && trace.isTraceEnabled()) {
                String[] cids = mc.getAttachmentMap().getAllContentIDs();
                if (cids != null && cids.length > 0) {
                    for (int i = 0; i < cids.length; ++i) {
                        trace.trace((Object)("Attachment : " + cids[i]));
                    }
                }
                trace.trace((Object)("Envelope : " + mc.getEnvelope()));
            }
        }
        Log serviceLog = LogFactory.getLog((String)"SERVICE_LOGGER.__SynapseService");
        ((Axis2MessageContext)synCtx).setServiceLog(serviceLog);
        try {
            ProxyServiceStatisticsStack synapseServiceStack = new ProxyServiceStatisticsStack();
            boolean isFault = synCtx.getEnvelope().getBody().hasFault();
            synapseServiceStack.put("__SynapseService", System.currentTimeMillis(), !synCtx.isResponse(), true, isFault);
            synCtx.setProperty("synapse.service.stats", synapseServiceStack);
            synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getSequence("fault")));
            synCtx.getEnvironment().injectMessage(synCtx);
        }
        catch (SynapseException syne) {
            if (!synCtx.getFaultStack().isEmpty()) {
                this.warn(traceOn, "Executing fault handler due to exception encountered", synCtx);
                ((FaultHandler)synCtx.getFaultStack().pop()).handleFault(synCtx, syne);
            }
            this.warn(traceOn, "Exception encountered but no fault handler found - message dropped", synCtx);
        }
    }

    private void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }

    private void warn(boolean traceOn, String msg, MessageContext msgContext) {
        if (traceOn) {
            trace.warn((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.warn((Object)msg);
        }
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().warn((Object)msg);
        }
    }
}

