/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.MessageHelper;

public class SOAPUtils {
    private static final Log log = LogFactory.getLog(SOAPUtils.class);
    private static String SOAP_ATR_ACTOR = "actor";
    private static String SOAP_ATR_ROLE = "role";
    private static String SOAP_ATR_MUST_UNDERSTAND = "mustUnderstand";

    public static void convertSoapVersion(MessageContext axisOutMsgCtx, String soapVersionURI) throws AxisFault {
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            SOAPUtils.convertSOAP11toSOAP12(axisOutMsgCtx);
        } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapVersionURI)) {
            SOAPUtils.convertSOAP12toSOAP11(axisOutMsgCtx);
        } else {
            throw new SynapseException("Invalid soapVersionURI:" + soapVersionURI);
        }
    }

    public static void convertSOAP11toSOAP12(MessageContext axisOutMsgCtx) throws AxisFault {
        OMNode omNode;
        if (log.isDebugEnabled()) {
            log.debug((Object)"convert SOAP11 to SOAP12");
        }
        SOAPEnvelope oldEnvelope = MessageHelper.cloneSOAPEnvelope(axisOutMsgCtx.getEnvelope());
        SOAPFactory soap12Factory = OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope newEnvelope = soap12Factory.getDefaultEnvelope();
        if (oldEnvelope.getHeader() != null) {
            Iterator itr = oldEnvelope.getHeader().getChildren();
            while (itr.hasNext()) {
                omNode = (OMNode)itr.next();
                if (omNode instanceof SOAPHeaderBlock) {
                    SOAPHeaderBlock soapHeader = (SOAPHeaderBlock)omNode;
                    SOAPHeaderBlock newSOAPHeader = soap12Factory.createSOAPHeaderBlock(soapHeader.getLocalName(), soapHeader.getNamespace());
                    Iterator allAttributes = soapHeader.getAllAttributes();
                    while (allAttributes.hasNext()) {
                        OMAttribute attr = (OMAttribute)allAttributes.next();
                        if (attr.getNamespace() != null && "http://schemas.xmlsoap.org/soap/envelope/".equals(attr.getNamespace().getNamespaceURI())) {
                            String attrName = attr.getLocalName();
                            if (SOAP_ATR_ACTOR.equals(attrName)) {
                                OMAttribute newAtr = omNode.getOMFactory().createOMAttribute(SOAP_ATR_ROLE, newEnvelope.getNamespace(), attr.getAttributeValue());
                                newSOAPHeader.addAttribute(newAtr);
                            } else if (SOAP_ATR_MUST_UNDERSTAND.equals(attrName)) {
                                boolean isMustUnderstand = soapHeader.getMustUnderstand();
                                newSOAPHeader.setMustUnderstand(isMustUnderstand);
                            } else {
                                log.warn((Object)("removed unsupported attribute from SOAP 1.1 namespace when converting to SOAP 1.2:" + attrName));
                            }
                        } else {
                            newSOAPHeader.addAttribute(attr);
                        }
                        Iterator itrChildren = soapHeader.getChildren();
                        while (itrChildren.hasNext()) {
                            newSOAPHeader.addChild((OMNode)itrChildren.next());
                        }
                        newEnvelope.getHeader().addChild((OMNode)newSOAPHeader);
                    }
                    continue;
                }
                newEnvelope.getHeader().addChild(omNode);
            }
        }
        if (oldEnvelope.getBody() != null) {
            Iterator itrBodyChildren = oldEnvelope.getBody().getChildren();
            while (itrBodyChildren.hasNext()) {
                omNode = (OMNode)itrBodyChildren.next();
                if (omNode instanceof SOAPFault) {
                    SOAPFaultReason reason;
                    SOAPFault soapFault = (SOAPFault)omNode;
                    if (soapFault == null) continue;
                    SOAPFault newSOAPFault = soap12Factory.createSOAPFault();
                    newEnvelope.getBody().addChild((OMNode)newSOAPFault);
                    SOAPFaultCode code = soapFault.getCode();
                    if (code != null) {
                        SOAPFaultCode newSOAPFaultCode = soap12Factory.createSOAPFaultCode();
                        newSOAPFault.setCode(newSOAPFaultCode);
                        String value = code.getText();
                        if (value != null) {
                            SOAPFaultValue newSOAPFaultValue = soap12Factory.createSOAPFaultValue(newSOAPFaultCode);
                            newSOAPFaultValue.setText(value);
                        }
                    }
                    if ((reason = soapFault.getReason()) == null) continue;
                    SOAPFaultReason newSOAPFaultReason = soap12Factory.createSOAPFaultReason(newSOAPFault);
                    String reasonText = reason.getText();
                    if (reasonText != null) {
                        SOAPFaultText newSOAPFaultText = soap12Factory.createSOAPFaultText(newSOAPFaultReason);
                        newSOAPFaultText.setLang("en");
                        newSOAPFaultText.setText(reasonText);
                    }
                    newSOAPFault.setReason(newSOAPFaultReason);
                    continue;
                }
                newEnvelope.getBody().addChild(omNode);
            }
        }
        axisOutMsgCtx.setEnvelope(newEnvelope);
    }

    public static void convertSOAP12toSOAP11(MessageContext axisOutMsgCtx) throws AxisFault {
        OMNode omNode;
        Iterator itr;
        if (log.isDebugEnabled()) {
            log.debug((Object)"convert SOAP12 to SOAP11");
        }
        SOAPEnvelope oldEnvelope = MessageHelper.cloneSOAPEnvelope(axisOutMsgCtx.getEnvelope());
        SOAPFactory soap11Factory = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope newEnvelope = soap11Factory.getDefaultEnvelope();
        if (oldEnvelope.getHeader() != null) {
            itr = oldEnvelope.getHeader().getChildren();
            while (itr.hasNext()) {
                omNode = (OMNode)itr.next();
                if (omNode instanceof SOAPHeaderBlock) {
                    SOAPHeaderBlock soapHeaderBlock = (SOAPHeaderBlock)omNode;
                    SOAPHeaderBlock newSOAPHeader = soap11Factory.createSOAPHeaderBlock(soapHeaderBlock.getLocalName(), soapHeaderBlock.getNamespace());
                    Iterator allAttributes = soapHeaderBlock.getAllAttributes();
                    while (allAttributes.hasNext()) {
                        OMAttribute attr = (OMAttribute)allAttributes.next();
                        if (attr.getNamespace() != null && "http://www.w3.org/2003/05/soap-envelope".equals(attr.getNamespace().getNamespaceURI())) {
                            String attrName = attr.getLocalName();
                            if (SOAP_ATR_ROLE.equals(attrName)) {
                                OMAttribute newAtr = omNode.getOMFactory().createOMAttribute(SOAP_ATR_ACTOR, newEnvelope.getNamespace(), attr.getAttributeValue());
                                newSOAPHeader.addAttribute(newAtr);
                            } else if (SOAP_ATR_MUST_UNDERSTAND.equals(attrName)) {
                                boolean isMustUnderstand = soapHeaderBlock.getMustUnderstand();
                                newSOAPHeader.setMustUnderstand(isMustUnderstand);
                            } else {
                                log.warn((Object)("removed unsupported attribute from SOAP 1.2 namespace when converting to SOAP 1.1:" + attrName));
                            }
                        } else {
                            newSOAPHeader.addAttribute(attr);
                        }
                        Iterator itrChildren = soapHeaderBlock.getChildren();
                        while (itrChildren.hasNext()) {
                            newSOAPHeader.addChild((OMNode)itrChildren.next());
                        }
                        newEnvelope.getHeader().addChild((OMNode)newSOAPHeader);
                    }
                    continue;
                }
                newEnvelope.getHeader().addChild(omNode);
            }
        }
        if (oldEnvelope.getBody() != null) {
            itr = oldEnvelope.getBody().getChildren();
            while (itr.hasNext()) {
                omNode = (OMNode)itr.next();
                if (omNode instanceof SOAPFault) {
                    SOAPFaultReason reason;
                    SOAPFault soapFault = (SOAPFault)omNode;
                    if (soapFault == null) continue;
                    SOAPFault newSOAPFault = soap11Factory.createSOAPFault();
                    newEnvelope.getBody().addChild((OMNode)newSOAPFault);
                    SOAPFaultCode code = soapFault.getCode();
                    if (code != null) {
                        SOAPFaultCode newSOAPFaultCode = soap11Factory.createSOAPFaultCode(newSOAPFault);
                        SOAPFaultValue value = code.getValue();
                        if (value != null) {
                            soap11Factory.createSOAPFaultValue(newSOAPFaultCode);
                            if (value.getText() != null) {
                                newSOAPFaultCode.setText(value.getText());
                            }
                        }
                    }
                    if ((reason = soapFault.getReason()) == null) continue;
                    SOAPFaultReason newSOAPFaultReason = soap11Factory.createSOAPFaultReason(newSOAPFault);
                    List allSoapTexts = reason.getAllSoapTexts();
                    Iterator iterAllSoapTexts = allSoapTexts.iterator();
                    if (!iterAllSoapTexts.hasNext()) continue;
                    SOAPFaultText soapFaultText = (SOAPFaultText)iterAllSoapTexts.next();
                    SOAPFaultText newSOAPFaultText = soap11Factory.createSOAPFaultText(newSOAPFaultReason);
                    newSOAPFaultReason.setText(soapFaultText.getText());
                    continue;
                }
                newEnvelope.getBody().addChild(omNode);
            }
        }
        axisOutMsgCtx.setEnvelope(newEnvelope);
    }
}

