/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.core.axis2.SynapseMessageReceiver;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.statistics.impl.ProxyServiceStatisticsStack;

public class ProxyServiceMessageReceiver
extends SynapseMessageReceiver {
    private static final Log log = LogFactory.getLog(ProxyServiceMessageReceiver.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private String name = null;
    private ProxyService proxy = null;

    public void receive(org.apache.axis2.context.MessageContext mc) throws AxisFault {
        boolean traceOn = this.proxy.getTraceState() == 1;
        boolean traceOrDebugOn = traceOn || log.isDebugEnabled();
        String remoteAddr = (String)mc.getProperty("REMOTE_ADDR");
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Proxy Service " + this.name + " received a new message" + (remoteAddr != null ? " from : " + remoteAddr : "..."));
            this.traceOrDebug(traceOn, "Message To: " + (mc.getTo() != null ? mc.getTo().getAddress() : "null"));
            this.traceOrDebug(traceOn, "SOAPAction: " + (mc.getSoapAction() != null ? mc.getSoapAction() : "null"));
            this.traceOrDebug(traceOn, "WSA-Action: " + (mc.getWSAAction() != null ? mc.getWSAAction() : "null"));
            if (traceOn && trace.isTraceEnabled()) {
                String[] cids = mc.getAttachmentMap().getAllContentIDs();
                if (cids != null && cids.length > 0) {
                    for (int i = 0; i < cids.length; ++i) {
                        trace.trace((Object)("With attachment content ID : " + cids[i]));
                    }
                }
                trace.trace((Object)("Envelope : " + mc.getEnvelope()));
            }
        }
        MessageContext synCtx = MessageContextCreatorForAxis2.getSynapseMessageContext(mc);
        Log serviceLog = LogFactory.getLog((String)("SERVICE_LOGGER." + this.name));
        ((Axis2MessageContext)synCtx).setServiceLog(serviceLog);
        synCtx.setProperty("proxy.name", this.name);
        synCtx.setTracingState(this.proxy.getTraceState());
        try {
            boolean statsOn;
            boolean bl = statsOn = 1 == this.proxy.getStatisticsState();
            if (statsOn) {
                ProxyServiceStatisticsStack proxyServiceStatisticsStack = new ProxyServiceStatisticsStack();
                boolean isFault = synCtx.getEnvelope().getBody().hasFault();
                proxyServiceStatisticsStack.put(this.name, System.currentTimeMillis(), !synCtx.isResponse(), statsOn, isFault);
                synCtx.setProperty("synapse.proxy.stats", proxyServiceStatisticsStack);
            }
            if (this.proxy.getTargetFaultSequence() != null) {
                Mediator faultSequence = synCtx.getSequence(this.proxy.getTargetFaultSequence());
                if (faultSequence != null) {
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "Setting the fault-sequence to : " + faultSequence);
                    }
                    synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getSequence(this.proxy.getTargetFaultSequence())));
                } else {
                    this.traceOrDebug(traceOn, "Unable to find fault-sequence : " + this.proxy.getTargetFaultSequence() + "; using default fault sequence");
                    synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getSequence("fault")));
                }
            } else if (this.proxy.getTargetInLineFaultSequence() != null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Setting specified anonymous fault-sequence for proxy");
                }
                synCtx.pushFaultHandler(new MediatorFaultHandler(this.proxy.getTargetInLineFaultSequence()));
            }
            if (this.proxy.getTargetInSequence() != null) {
                Mediator inSequence = synCtx.getSequence(this.proxy.getTargetInSequence());
                if (inSequence != null) {
                    this.traceOrDebug(traceOn, "Using sequence named : " + this.proxy.getTargetInSequence() + " for incoming message mediation");
                    inSequence.mediate(synCtx);
                } else {
                    this.handleException("Unable to find in-sequence : " + this.proxy.getTargetInSequence(), synCtx);
                }
            } else if (this.proxy.getTargetInLineInSequence() != null) {
                this.traceOrDebug(traceOn, "Using the anonymous in-sequence of the proxy service for mediation");
                this.proxy.getTargetInLineInSequence().mediate(synCtx);
            }
            if (this.proxy.getTargetEndpoint() != null) {
                Endpoint endpoint = synCtx.getEndpoint(this.proxy.getTargetEndpoint());
                if (endpoint != null) {
                    this.traceOrDebug(traceOn, "Forwarding message to the endpoint : " + this.proxy.getTargetEndpoint());
                    endpoint.send(synCtx);
                } else {
                    this.handleException("Unable to find the endpoint specified : " + this.proxy.getTargetEndpoint(), synCtx);
                }
            } else if (this.proxy.getTargetInLineEndpoint() != null) {
                this.traceOrDebug(traceOn, "Forwarding the message to the anonymous endpoint of the proxy service");
                this.proxy.getTargetInLineEndpoint().send(synCtx);
            }
        }
        catch (SynapseException syne) {
            if (!synCtx.getFaultStack().isEmpty()) {
                this.warn(traceOn, "Executing fault handler due to exception encountered", synCtx);
                ((FaultHandler)synCtx.getFaultStack().pop()).handleFault(synCtx, syne);
            }
            this.warn(traceOn, "Exception encountered but no fault handler found - message dropped", synCtx);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProxy(ProxyService proxy) {
        this.proxy = proxy;
    }

    private void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }

    private void warn(boolean traceOn, String msg, MessageContext msgContext) {
        if (traceOn) {
            trace.warn((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.warn((Object)msg);
        }
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().warn((Object)msg);
        }
    }

    private void handleException(String msg, MessageContext msgContext) {
        log.error((Object)msg);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().error((Object)msg);
        }
        if (this.proxy.getTraceState() == 1) {
            trace.error((Object)msg);
        }
        throw new SynapseException(msg);
    }
}

