/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.MediatorFactory;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.MediatorSerializer;
import org.apache.synapse.config.xml.MediatorSerializerFinder;

public class MediatorDeployer
implements Deployer {
    private static final Log log = LogFactory.getLog(MediatorDeployer.class);
    private ConfigurationContext cfgCtx = null;

    public void init(ConfigurationContext configurationContext) {
        this.cfgCtx = configurationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        log.info((Object)("Loading mediator from: " + deploymentFileData.getAbsolutePath()));
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        try {
            DeploymentClassLoader urlCl = new DeploymentClassLoader(new URL[]{deploymentFileData.getFile().toURL()}, null, prevCl);
            Thread.currentThread().setContextClassLoader((ClassLoader)urlCl);
            URL facURL = urlCl.findResource("META-INF/services/org.apache.synapse.config.xml.MediatorFactory");
            if (facURL != null) {
                int c;
                InputStream facStream = facURL.openStream();
                InputStreamReader facreader = new InputStreamReader(facStream);
                StringBuffer facSB = new StringBuffer();
                while ((c = facreader.read()) != -1) {
                    facSB.append((char)c);
                }
                String[] facClassName = facSB.toString().split("\n");
                for (int i = 0; i < facClassName.length; ++i) {
                    log.info((Object)("Registering the Mediator factory: " + facClassName[i]));
                    Class facClass = urlCl.loadClass(facClassName[i]);
                    MediatorFactory facInst = (MediatorFactory)facClass.newInstance();
                    MediatorFactoryFinder.getInstance().getFactoryMap().put(facInst.getTagQName(), facClass);
                    log.info((Object)("Mediator loaded and registered for the tag name: " + facInst.getTagQName()));
                }
            } else {
                this.handleException("Unable to find the MediatorFactory implementation. Unable to register the MediatorFactory with the FactoryFinder");
            }
            URL serURL = urlCl.findResource("META-INF/services/org.apache.synapse.config.xml.MediatorSerializer");
            if (serURL != null) {
                int c;
                InputStream serStream = serURL.openStream();
                InputStreamReader serReader = new InputStreamReader(serStream);
                StringBuffer serSB = new StringBuffer();
                while ((c = serReader.read()) != -1) {
                    serSB.append((char)c);
                }
                String[] serClassName = serSB.toString().split("\n");
                for (int i = 0; i < serClassName.length; ++i) {
                    log.info((Object)("Registering the Mediator serializer: " + serClassName[i]));
                    Class serClass = urlCl.loadClass(serClassName[i]);
                    MediatorSerializer serInst = (MediatorSerializer)serClass.newInstance();
                    MediatorSerializerFinder.getInstance().getSerializerMap().put(serInst.getMediatorClassName(), serInst);
                    log.info((Object)("Mediator loaded and registered for the serialization as: " + serInst.getMediatorClassName()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to find the MediatorSerializer implementation. Unable to register the MediatorSerializer with the SerializerFinder");
            }
        }
        catch (IOException e) {
            this.handleException("I/O error in reading the mediator jar file", e);
        }
        catch (ClassNotFoundException e) {
            this.handleException("Unable to find the specified class on the path or in the jar file", e);
        }
        catch (IllegalAccessException e) {
            this.handleException("Unable to load the class from the jar", e);
        }
        catch (InstantiationException e) {
            this.handleException("Unable to instantiate the class specified", e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Restoring the context class loader to the original");
            }
            Thread.currentThread().setContextClassLoader(prevCl);
        }
    }

    public void setDirectory(String string) {
    }

    public void setExtension(String string) {
    }

    public void unDeploy(String string) throws DeploymentException {
    }

    private void handleException(String message, Exception e) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)message, (Throwable)e);
        }
        throw new DeploymentException(message, (Throwable)e);
    }

    private void handleException(String message) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
        throw new DeploymentException(message);
    }
}

