/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.OMDocumentImpl;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.GetPropertyFunction;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.jaxen.Function;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.XPathFunctionContext;

public class Axis2MessageContext
implements MessageContext {
    private static final Log log = LogFactory.getLog(Axis2MessageContext.class);
    private SynapseConfiguration synCfg = null;
    private SynapseEnvironment synEnv = null;
    private Map properties = new HashMap();
    private Map localEntries = new HashMap();
    private Stack faultStack = new Stack();
    private org.apache.axis2.context.MessageContext axis2MessageContext = null;
    private boolean response = false;
    private boolean faultResponse = false;
    private int tracingState = 2;
    private Log serviceLog = null;

    public SynapseConfiguration getConfiguration() {
        return this.synCfg;
    }

    public void setConfiguration(SynapseConfiguration synCfg) {
        this.synCfg = synCfg;
    }

    public SynapseEnvironment getEnvironment() {
        return this.synEnv;
    }

    public void setEnvironment(SynapseEnvironment synEnv) {
        this.synEnv = synEnv;
    }

    public Map getContextEntries() {
        return this.localEntries;
    }

    public void setContextEntries(Map entries) {
        this.localEntries = entries;
    }

    public Mediator getMainSequence() {
        Object o = this.localEntries.get("main");
        if (o != null && o instanceof Mediator) {
            return (Mediator)o;
        }
        Mediator main = this.getConfiguration().getMainSequence();
        this.localEntries.put("main", main);
        return main;
    }

    public Mediator getFaultSequence() {
        Object o = this.localEntries.get("fault");
        if (o != null && o instanceof Mediator) {
            return (Mediator)o;
        }
        Mediator fault = this.getConfiguration().getFaultSequence();
        this.localEntries.put("fault", fault);
        return fault;
    }

    public Mediator getSequence(String key) {
        Object o = this.localEntries.get(key);
        if (o != null && o instanceof Mediator) {
            return (Mediator)o;
        }
        Mediator m = this.getConfiguration().getSequence(key);
        this.localEntries.put(key, m);
        return m;
    }

    public Endpoint getEndpoint(String key) {
        Object o = this.localEntries.get(key);
        if (o != null && o instanceof Endpoint) {
            return (Endpoint)o;
        }
        Endpoint e = this.getConfiguration().getEndpoint(key);
        this.localEntries.put(key, e);
        return e;
    }

    public Object getEntry(String key) {
        Object o = this.localEntries.get(key);
        if (o != null && o instanceof Entry) {
            return ((Entry)o).getValue();
        }
        Object e = this.getConfiguration().getEntry(key);
        if (e != null) {
            this.localEntries.put(key, e);
            return e;
        }
        this.getConfiguration().getEntryDefinition(key);
        return this.getConfiguration().getEntry(key);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
        if ("RESPONSE".equals(key) && this.getAxis2MessageContext().getOperationContext() != null) {
            this.getAxis2MessageContext().getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        }
    }

    public Set getPropertyKeySet() {
        return this.properties.keySet();
    }

    public Axis2MessageContext(org.apache.axis2.context.MessageContext axisMsgCtx, SynapseConfiguration synCfg, SynapseEnvironment synEnv) {
        this.setAxis2MessageContext(axisMsgCtx);
        this.synCfg = synCfg;
        this.synEnv = synEnv;
        this.pushFaultHandler(new MediatorFaultHandler(synCfg.getFaultSequence()));
    }

    public EndpointReference getFaultTo() {
        return this.axis2MessageContext.getFaultTo();
    }

    public void setFaultTo(EndpointReference reference) {
        this.axis2MessageContext.setFaultTo(reference);
    }

    public EndpointReference getFrom() {
        return this.axis2MessageContext.getFrom();
    }

    public void setFrom(EndpointReference reference) {
        this.axis2MessageContext.setFrom(reference);
    }

    public SOAPEnvelope getEnvelope() {
        return this.axis2MessageContext.getEnvelope();
    }

    public void setEnvelope(SOAPEnvelope envelope) throws AxisFault {
        this.axis2MessageContext.setEnvelope(envelope);
    }

    public String getMessageID() {
        return this.axis2MessageContext.getMessageID();
    }

    public void setMessageID(String string) {
        this.axis2MessageContext.setMessageID(string);
    }

    public RelatesTo getRelatesTo() {
        return this.axis2MessageContext.getRelatesTo();
    }

    public void setRelatesTo(RelatesTo[] reference) {
        this.axis2MessageContext.setRelationships(reference);
    }

    public EndpointReference getReplyTo() {
        return this.axis2MessageContext.getReplyTo();
    }

    public void setReplyTo(EndpointReference reference) {
        this.axis2MessageContext.setReplyTo(reference);
    }

    public EndpointReference getTo() {
        return this.axis2MessageContext.getTo();
    }

    public void setTo(EndpointReference reference) {
        this.axis2MessageContext.setTo(reference);
    }

    public void setWSAAction(String actionURI) {
        this.axis2MessageContext.setWSAAction(actionURI);
    }

    public String getWSAAction() {
        return this.axis2MessageContext.getWSAAction();
    }

    public void setWSAMessageID(String messageID) {
        this.axis2MessageContext.setWSAMessageId(messageID);
    }

    public String getWSAMessageID() {
        return this.axis2MessageContext.getMessageID();
    }

    public String getSoapAction() {
        return this.axis2MessageContext.getSoapAction();
    }

    public void setSoapAction(String string) {
        this.axis2MessageContext.setSoapAction(string);
    }

    public boolean isDoingMTOM() {
        return this.axis2MessageContext.isDoingMTOM();
    }

    public boolean isDoingSWA() {
        return this.axis2MessageContext.isDoingSwA();
    }

    public void setDoingMTOM(boolean b) {
        this.axis2MessageContext.setDoingMTOM(b);
    }

    public void setDoingSWA(boolean b) {
        this.axis2MessageContext.setDoingSwA(b);
    }

    public boolean isDoingPOX() {
        return this.axis2MessageContext.isDoingREST();
    }

    public void setDoingPOX(boolean b) {
        this.axis2MessageContext.setDoingREST(b);
    }

    public boolean isDoingGET() {
        return "GET".equals(this.axis2MessageContext.getProperty("HTTP_METHOD")) && this.axis2MessageContext.isDoingREST();
    }

    public void setDoingGET(boolean b) {
        if (b) {
            this.axis2MessageContext.setDoingREST(b);
            this.axis2MessageContext.setProperty("HTTP_METHOD", (Object)"GET");
        } else {
            this.axis2MessageContext.removeProperty("HTTP_METHOD");
        }
    }

    public boolean isSOAP11() {
        return this.axis2MessageContext.isSOAP11();
    }

    public void setResponse(boolean b) {
        this.response = b;
        this.axis2MessageContext.setProperty("synapse.isresponse", (Object)b);
    }

    public boolean isResponse() {
        Object o = this.properties.get("RESPONSE");
        if (o != null && o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        return this.response;
    }

    public void setFaultResponse(boolean b) {
        this.faultResponse = b;
    }

    public boolean isFaultResponse() {
        return this.faultResponse;
    }

    public int getTracingState() {
        return this.tracingState;
    }

    public void setTracingState(int tracingState) {
        this.tracingState = tracingState;
    }

    public Stack getFaultStack() {
        return this.faultStack;
    }

    public void pushFaultHandler(FaultHandler fault) {
        this.faultStack.push(fault);
    }

    public Log getServiceLog() {
        if (this.serviceLog != null) {
            return this.serviceLog;
        }
        String serviceName = (String)this.getProperty("proxy.name");
        if (serviceName != null && this.synCfg.getProxyService(serviceName) != null) {
            this.serviceLog = LogFactory.getLog((String)("SERVICE_LOGGER." + serviceName));
            return this.serviceLog;
        }
        this.serviceLog = LogFactory.getLog((String)"SERVICE_LOGGER.".substring(0, "SERVICE_LOGGER.".length() - 1));
        return this.serviceLog;
    }

    public void setServiceLog(Log serviceLog) {
        this.serviceLog = serviceLog;
    }

    public org.apache.axis2.context.MessageContext getAxis2MessageContext() {
        return this.axis2MessageContext;
    }

    public void setAxis2MessageContext(org.apache.axis2.context.MessageContext axisMsgCtx) {
        this.axis2MessageContext = axisMsgCtx;
        Boolean resp = (Boolean)axisMsgCtx.getProperty("synapse.isresponse");
        if (resp != null) {
            this.response = resp;
        }
    }

    public void setPaused(boolean value) {
        this.axis2MessageContext.setPaused(value);
    }

    public boolean isPaused() {
        return this.axis2MessageContext.isPaused();
    }

    public boolean isServerSide() {
        return this.axis2MessageContext.isServerSide();
    }

    public void setServerSide(boolean value) {
        this.axis2MessageContext.setServerSide(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringValue(AXIOMXPath xpath, MessageContext synCtx) {
        AXIOMXPath aXIOMXPath = xpath;
        synchronized (aXIOMXPath) {
            if (xpath != null) {
                try {
                    GetPropertyFunction getPropertyFunc = new GetPropertyFunction();
                    getPropertyFunc.setSynCtx(synCtx);
                    XPathFunctionContext fc = new XPathFunctionContext();
                    fc.registerFunction("http://ws.apache.org/ns/synapse", "get-property", (Function)getPropertyFunc);
                    fc.registerFunction(null, "get-property", (Function)getPropertyFunc);
                    xpath.setFunctionContext((FunctionContext)fc);
                    xpath.addNamespace("synapse", "http://ws.apache.org/ns/synapse");
                    xpath.addNamespace("syn", "http://ws.apache.org/ns/synapse");
                }
                catch (JaxenException je) {
                    Axis2MessageContext.handleException("Error setting up the Synapse XPath extension function for XPath : " + xpath, (Exception)((Object)je));
                }
                try {
                    Object result = xpath.evaluate((Object)synCtx.getEnvelope());
                    if (result == null) {
                        return null;
                    }
                    StringBuffer textValue = new StringBuffer();
                    if (result instanceof List) {
                        List list = (List)result;
                        for (Object o : list) {
                            if (o == null && list.size() == 1) {
                                return null;
                            }
                            if (o instanceof OMTextImpl) {
                                textValue.append(((OMTextImpl)o).getText());
                                continue;
                            }
                            if (o instanceof OMElementImpl) {
                                String s = ((OMElementImpl)o).getText();
                                if (s.trim().length() == 0) {
                                    s = o.toString();
                                }
                                textValue.append(s);
                                continue;
                            }
                            if (!(o instanceof OMDocumentImpl)) continue;
                            textValue.append(((OMDocumentImpl)o).getOMDocumentElement().toString());
                        }
                    } else {
                        textValue.append(result.toString());
                    }
                    return textValue.toString();
                }
                catch (JaxenException je) {
                    Axis2MessageContext.handleException("Evaluation of the XPath expression " + xpath.toString() + " resulted in an error", (Exception)((Object)je));
                }
            } else {
                Axis2MessageContext.handleException("Invalid (null) XPath expression");
            }
            return null;
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public String toString() {
        SOAPHeader soapHeader;
        StringBuffer sb = new StringBuffer();
        String separator = "\n";
        if (this.getTo() != null) {
            sb.append("To: " + this.getTo().getAddress());
        } else {
            sb.append("To: ");
        }
        if (this.getFrom() != null) {
            sb.append(separator + "From: " + this.getFrom().getAddress());
        }
        if (this.getWSAAction() != null) {
            sb.append(separator + "WSAction: " + this.getWSAAction());
        }
        if (this.getSoapAction() != null) {
            sb.append(separator + "SOAPAction: " + this.getSoapAction());
        }
        if (this.getReplyTo() != null) {
            sb.append(separator + "ReplyTo: " + this.getReplyTo().getAddress());
        }
        if (this.getMessageID() != null) {
            sb.append(separator + "MessageID: " + this.getMessageID());
        }
        if ((soapHeader = this.getEnvelope().getHeader()) != null) {
            sb.append(separator + "Headers : ");
            Iterator iter = soapHeader.examineAllHeaderBlocks();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof SOAPHeaderBlock) {
                    SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)o;
                    sb.append(separator + headerBlock.getLocalName() + " : " + headerBlock.getText());
                    continue;
                }
                if (!(o instanceof OMElement)) continue;
                OMElement headerElem = (OMElement)o;
                sb.append(separator + headerElem.getLocalName() + " : " + headerElem.getText());
            }
        }
        return sb.toString();
    }
}

