/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.DynamicAxisOperation;
import org.apache.synapse.core.axis2.SynapseCallbackReceiver;

public class AnonymousServiceFactory {
    private static final Log log = LogFactory.getLog(AnonymousServiceFactory.class);
    private static final String NONE = "__NONE__";
    private static final String ADDR_ONLY = "__ADDR_ONLY__";
    private static final String RM_AND_ADDR = "__RM_AND_ADDR__";
    private static final String SEC_AND_ADDR = "__SEC_AND_ADDR__";
    private static final String RM_SEC_AND_ADDR = "__RM_SEC_AND_ADDR__";
    public static final String OUT_IN_OPERATION = "__OUT_IN_OPERATION__";
    public static final String OUT_ONLY_OPERATION = "__OUT_ONLY_OPERATION__";
    private static SynapseCallbackReceiver synapseCallbackReceiver = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AxisService getAnonymousService(SynapseConfiguration synCfg, AxisConfiguration axisCfg, boolean wsAddrOn, boolean wsRMOn, boolean wsSecOn) {
        String servicekey = null;
        servicekey = !wsAddrOn ? NONE : (!wsSecOn && !wsRMOn ? ADDR_ONLY : (wsRMOn && !wsSecOn ? RM_AND_ADDR : (wsSecOn && !wsRMOn ? SEC_AND_ADDR : RM_SEC_AND_ADDR)));
        try {
            AxisService service = axisCfg.getService(servicekey);
            if (service != null) return service;
            Class<AnonymousServiceFactory> clazz = AnonymousServiceFactory.class;
            synchronized (AnonymousServiceFactory.class) {
                service = axisCfg.getService(servicekey);
                if (service != null) {
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                    return service;
                }
                service = AnonymousServiceFactory.createAnonymousService(synCfg, axisCfg, servicekey);
                if (!wsAddrOn) return service;
                service.engageModule(axisCfg.getModule("addressing"), (AxisDescription)axisCfg);
                if (wsRMOn) {
                    service.engageModule(axisCfg.getModule("sandesha2"), (AxisDescription)axisCfg);
                }
                if (!wsSecOn) return service;
                service.engageModule(axisCfg.getModule("rampart"), (AxisDescription)axisCfg);
                // ** MonitorExit[var7_8] (shouldn't be in output)
                return service;
            }
        }
        catch (AxisFault e) {
            AnonymousServiceFactory.handleException("Error retrieving anonymous service for QoS : " + servicekey, (Exception)((Object)e));
            return null;
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static AxisService createAnonymousService(SynapseConfiguration synCfg, AxisConfiguration axisCfg, String serviceKey) {
        try {
            DynamicAxisOperation dynamicOperation = new DynamicAxisOperation(new QName(OUT_IN_OPERATION));
            dynamicOperation.setMessageReceiver(AnonymousServiceFactory.getCallbackReceiver(synCfg));
            AxisMessage inMsg = new AxisMessage();
            inMsg.setName("in-message");
            inMsg.setParent((AxisDescription)dynamicOperation);
            AxisMessage outMsg = new AxisMessage();
            outMsg.setName("out-message");
            outMsg.setParent((AxisDescription)dynamicOperation);
            dynamicOperation.addMessage(inMsg, "Out");
            dynamicOperation.addMessage(outMsg, "In");
            OutOnlyAxisOperation asyncOperation = new OutOnlyAxisOperation(new QName(OUT_ONLY_OPERATION));
            asyncOperation.setMessageReceiver((MessageReceiver)AnonymousServiceFactory.getCallbackReceiver(synCfg));
            AxisMessage outOnlyMsg = new AxisMessage();
            outOnlyMsg.setName("out-message");
            outOnlyMsg.setParent((AxisDescription)asyncOperation);
            asyncOperation.addMessage(outMsg, "Out");
            AxisService axisAnonymousService = new AxisService(serviceKey);
            axisAnonymousService.addOperation((AxisOperation)dynamicOperation);
            axisAnonymousService.addOperation((AxisOperation)asyncOperation);
            axisCfg.addService(axisAnonymousService);
            axisCfg.getPhasesInfo().setOperationPhases((AxisOperation)dynamicOperation);
            return axisAnonymousService;
        }
        catch (AxisFault e) {
            AnonymousServiceFactory.handleException("Error occured while creating an anonymous service for QoS : " + serviceKey, (Exception)((Object)e));
            return null;
        }
    }

    private static synchronized SynapseCallbackReceiver getCallbackReceiver(SynapseConfiguration synCfg) {
        if (synapseCallbackReceiver == null) {
            synapseCallbackReceiver = new SynapseCallbackReceiver(synCfg);
        }
        return synapseCallbackReceiver;
    }
}

