/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.EndpointAbstractSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.SALoadbalanceEndpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.algorithms.RoundRobin;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.HttpSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SimpleClientSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SoapSessionDispatcher;

public class SALoadbalanceEndpointSerializer
implements EndpointSerializer {
    private static final Log log = LogFactory.getLog(SALoadbalanceEndpointSerializer.class);
    private OMFactory fac = null;

    public OMElement serializeEndpoint(Endpoint endpoint) {
        OMElement sessionElement;
        Dispatcher dispatcher;
        if (!(endpoint instanceof SALoadbalanceEndpoint)) {
            this.handleException("Invalid endpoint type for serializing. Expected: SALoadbalanceEndpoint Found: " + endpoint.getClass().getName());
        }
        SALoadbalanceEndpoint loadbalanceEndpoint = (SALoadbalanceEndpoint)endpoint;
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        String name = loadbalanceEndpoint.getName();
        if (name != null) {
            endpointElement.addAttribute("name", name, null);
        }
        if ((dispatcher = loadbalanceEndpoint.getDispatcher()) instanceof SoapSessionDispatcher) {
            sessionElement = this.fac.createOMElement("session", SynapseConstants.SYNAPSE_OMNAMESPACE);
            sessionElement.addAttribute("type", "soap", null);
            endpointElement.addChild((OMNode)sessionElement);
        } else if (dispatcher instanceof HttpSessionDispatcher) {
            sessionElement = this.fac.createOMElement("session", SynapseConstants.SYNAPSE_OMNAMESPACE);
            sessionElement.addAttribute("type", "http", null);
            endpointElement.addChild((OMNode)sessionElement);
        } else if (dispatcher instanceof SimpleClientSessionDispatcher) {
            sessionElement = this.fac.createOMElement("session", SynapseConstants.SYNAPSE_OMNAMESPACE);
            sessionElement.addAttribute("type", "simpleClientSession", null);
            endpointElement.addChild((OMNode)sessionElement);
        }
        OMElement loadbalanceElement = this.fac.createOMElement("loadbalance", SynapseConstants.SYNAPSE_OMNAMESPACE);
        endpointElement.addChild((OMNode)loadbalanceElement);
        LoadbalanceAlgorithm algorithm = loadbalanceEndpoint.getAlgorithm();
        String algorithmName = "roundRobin";
        if (algorithm instanceof RoundRobin) {
            algorithmName = "roundRobin";
        }
        loadbalanceElement.addAttribute("algorithm", algorithmName, null);
        List endpoints = loadbalanceEndpoint.getEndpoints();
        for (int i = 0; i < endpoints.size(); ++i) {
            Endpoint childEndpoint = (Endpoint)endpoints.get(i);
            EndpointSerializer serializer = EndpointAbstractSerializer.getEndpointSerializer(childEndpoint);
            OMElement aeElement = serializer.serializeEndpoint(childEndpoint);
            loadbalanceElement.addChild((OMNode)aeElement);
        }
        return endpointElement;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

