/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.EndpointAbstractFactory;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.LoadbalanceEndpointFactory;
import org.apache.synapse.config.xml.endpoints.utils.LoadbalanceAlgorithmFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.SALoadbalanceEndpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.dispatch.HttpSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SimpleClientSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SoapSessionDispatcher;

public class SALoadbalanceEndpointFactory
implements EndpointFactory {
    private static Log log = LogFactory.getLog(LoadbalanceEndpointFactory.class);
    private static SALoadbalanceEndpointFactory instance = new SALoadbalanceEndpointFactory();

    private SALoadbalanceEndpointFactory() {
    }

    public static SALoadbalanceEndpointFactory getInstance() {
        return instance;
    }

    public Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint) {
        SALoadbalanceEndpoint loadbalanceEndpoint = new SALoadbalanceEndpoint();
        OMElement sessionElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "session"));
        if (sessionElement != null) {
            String type = sessionElement.getAttributeValue(new QName("type"));
            if (type.equalsIgnoreCase("soap")) {
                SoapSessionDispatcher soapDispatcher = new SoapSessionDispatcher();
                loadbalanceEndpoint.setDispatcher(soapDispatcher);
            } else if (type.equalsIgnoreCase("http")) {
                HttpSessionDispatcher httpDispatcher = new HttpSessionDispatcher();
                loadbalanceEndpoint.setDispatcher(httpDispatcher);
            } else if (type.equalsIgnoreCase("simpleClientSession")) {
                SimpleClientSessionDispatcher csDispatcher = new SimpleClientSessionDispatcher();
                loadbalanceEndpoint.setDispatcher(csDispatcher);
            }
        } else {
            SALoadbalanceEndpointFactory.handleException("Session affinity endpoints should have a session element in the configuration.");
        }
        OMAttribute name = epConfig.getAttribute(new QName("", "name"));
        if (name != null) {
            loadbalanceEndpoint.setName(name.getAttributeValue());
        }
        OMElement loadbalanceElement = null;
        loadbalanceElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "loadbalance"));
        if (loadbalanceElement != null) {
            ArrayList endpoints = this.getEndpoints(loadbalanceElement, loadbalanceEndpoint);
            loadbalanceEndpoint.setEndpoints(endpoints);
            LoadbalanceAlgorithm algorithm = LoadbalanceAlgorithmFactory.createLoadbalanceAlgorithm(loadbalanceElement, endpoints);
            loadbalanceEndpoint.setAlgorithm(algorithm);
            return loadbalanceEndpoint;
        }
        return null;
    }

    public Object getObjectFromOMNode(OMNode om) {
        if (om instanceof OMElement) {
            return this.createEndpoint((OMElement)om, false);
        }
        SALoadbalanceEndpointFactory.handleException("Invalid XML configuration for an Endpoint. OMElement expected");
        return null;
    }

    private ArrayList getEndpoints(OMElement loadbalanceElement, Endpoint parent) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        Iterator iter = loadbalanceElement.getChildrenWithName(XMLConfigConstants.ENDPOINT_ELT);
        while (iter.hasNext()) {
            OMElement endptElem = (OMElement)iter.next();
            EndpointFactory epFac = EndpointAbstractFactory.getEndpointFactroy(endptElem);
            Endpoint endpoint = epFac.createEndpoint(endptElem, true);
            endpoint.setParentEndpoint(parent);
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

