/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.EndpointAbstractFactory;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.FailoverEndpoint;

public class FailoverEndpointFactory
implements EndpointFactory {
    private static Log log = LogFactory.getLog(FailoverEndpointFactory.class);
    private static FailoverEndpointFactory instance = new FailoverEndpointFactory();

    private FailoverEndpointFactory() {
    }

    public static FailoverEndpointFactory getInstance() {
        return instance;
    }

    public Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint) {
        OMElement failoverElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "failover"));
        if (failoverElement != null) {
            FailoverEndpoint failoverEndpoint = new FailoverEndpoint();
            String name = epConfig.getAttributeValue(new QName("name"));
            if (name != null) {
                failoverEndpoint.setName(name);
            }
            ArrayList endpoints = this.getEndpoints(failoverElement, failoverEndpoint);
            failoverEndpoint.setEndpoints(endpoints);
            return failoverEndpoint;
        }
        return null;
    }

    public Object getObjectFromOMNode(OMNode om) {
        if (om instanceof OMElement) {
            return this.createEndpoint((OMElement)om, false);
        }
        FailoverEndpointFactory.handleException("Invalid XML configuration for an Endpoint. OMElement expected");
        return null;
    }

    private ArrayList getEndpoints(OMElement failoverElement, Endpoint parent) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        Iterator iter = failoverElement.getChildrenWithName(XMLConfigConstants.ENDPOINT_ELT);
        while (iter.hasNext()) {
            OMElement endptElem = (OMElement)iter.next();
            EndpointFactory epFac = EndpointAbstractFactory.getEndpointFactroy(endptElem);
            Endpoint endpoint = epFac.createEndpoint(endptElem, true);
            endpoint.setParentEndpoint(parent);
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

