/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractListMediatorSerializer;
import org.apache.synapse.mediators.base.SequenceMediator;

public class SequenceMediatorSerializer
extends AbstractListMediatorSerializer {
    public OMElement serializeAnonymousSequence(OMElement parent, SequenceMediator mediator) {
        OMElement sequence = fac.createOMElement("sequence", synNS);
        int isEnableStatistics = mediator.getStatisticsState();
        String statisticsValue = null;
        if (isEnableStatistics == 1) {
            statisticsValue = "enable";
        } else if (isEnableStatistics == 0) {
            statisticsValue = "disable";
        }
        if (statisticsValue != null) {
            sequence.addAttribute(fac.createOMAttribute("statistics", nullNS, statisticsValue));
        }
        if (mediator.getErrorHandler() != null) {
            sequence.addAttribute(fac.createOMAttribute("onError", nullNS, mediator.getErrorHandler()));
        }
        SequenceMediatorSerializer.saveTracingState(sequence, mediator);
        this.serializeChildren(sequence, mediator.getList());
        if (parent != null) {
            parent.addChild((OMNode)sequence);
        }
        return sequence;
    }

    public OMElement serializeMediator(OMElement parent, Mediator m) {
        if (!(m instanceof SequenceMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        SequenceMediator mediator = (SequenceMediator)m;
        OMElement sequence = fac.createOMElement("sequence", synNS);
        if (mediator.isDynamic()) {
            sequence.addAttribute(fac.createOMAttribute("name", nullNS, mediator.getName()));
            sequence.addAttribute(fac.createOMAttribute("key", nullNS, mediator.getRegistryKey()));
        } else {
            int isEnableStatistics = mediator.getStatisticsState();
            String statisticsValue = null;
            if (isEnableStatistics == 1) {
                statisticsValue = "enable";
            } else if (isEnableStatistics == 0) {
                statisticsValue = "disable";
            }
            if (statisticsValue != null) {
                sequence.addAttribute(fac.createOMAttribute("statistics", nullNS, statisticsValue));
            }
            if (mediator.getKey() != null) {
                sequence.addAttribute(fac.createOMAttribute("key", nullNS, mediator.getKey()));
            } else if (mediator.getName() != null) {
                sequence.addAttribute(fac.createOMAttribute("name", nullNS, mediator.getName()));
                if (mediator.getErrorHandler() != null) {
                    sequence.addAttribute(fac.createOMAttribute("onError", nullNS, mediator.getErrorHandler()));
                }
                SequenceMediatorSerializer.saveTracingState(sequence, mediator);
                this.serializeChildren(sequence, mediator.getList());
            }
        }
        if (parent != null) {
            parent.addChild((OMNode)sequence);
        }
        return sequence;
    }

    public String getMediatorClassName() {
        return SequenceMediator.class.getName();
    }
}

