/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.mediators.ext.POJOCommandMediator;

public class POJOCommandMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeMediator(OMElement parent, Mediator m) {
        AXIOMXPath exprn;
        OMElement prop;
        Object value;
        if (!(m instanceof POJOCommandMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        POJOCommandMediator mediator = (POJOCommandMediator)m;
        OMElement pojoCommand = fac.createOMElement("pojoCommand", synNS);
        POJOCommandMediatorSerializer.saveTracingState(pojoCommand, mediator);
        if (mediator.getCommand() != null && mediator.getCommand().getClass().getName() != null) {
            pojoCommand.addAttribute(fac.createOMAttribute("name", nullNS, mediator.getCommand().getName()));
        } else {
            this.handleException("Invalid POJO Command mediator. The command class name is required");
        }
        for (String propName : mediator.getStaticSetterProperties().keySet()) {
            value = mediator.getStaticSetterProperties().get(propName);
            prop = fac.createOMElement(PROP_Q);
            prop.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            if (value instanceof String) {
                prop.addAttribute(fac.createOMAttribute("value", nullNS, (String)value));
            } else if (value instanceof OMElement) {
                prop.addChild((OMNode)((OMElement)value));
            } else {
                this.handleException("Unable to serialize the command mediator property with the naem " + propName + " : Unknown type");
            }
            if (mediator.getContextGetterProperties().containsKey(propName)) {
                prop.addAttribute(fac.createOMAttribute("context-name", nullNS, mediator.getContextGetterProperties().get(propName)));
            } else if (mediator.getMessageGetterProperties().containsKey(propName)) {
                AXIOMXPath xpath = mediator.getMessageGetterProperties().get(propName);
                prop.addAttribute(fac.createOMAttribute("expression", nullNS, xpath.toString()));
                this.serializeNamespaces(prop, xpath);
            }
            pojoCommand.addChild((OMNode)prop);
        }
        for (String propName : mediator.getMessageSetterProperties().keySet()) {
            exprn = mediator.getMessageSetterProperties().get(propName);
            prop = fac.createOMElement(PROP_Q);
            prop.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            prop.addAttribute(fac.createOMAttribute("expression", nullNS, exprn.toString()));
            this.serializeNamespaces(prop, exprn);
            if (mediator.getMessageGetterProperties().containsKey(propName)) {
                prop.addAttribute(fac.createOMAttribute("action", nullNS, "ReadAndUpdateMessage"));
            } else if (mediator.getContextGetterProperties().containsKey(propName)) {
                prop.addAttribute(fac.createOMAttribute("context-name", nullNS, mediator.getContextGetterProperties().get(propName)));
                prop.addAttribute(fac.createOMAttribute("action", nullNS, "ReadMessage"));
            } else {
                prop.addAttribute(fac.createOMAttribute("action", nullNS, "ReadMessage"));
            }
            pojoCommand.addChild((OMNode)prop);
        }
        for (String propName : mediator.getContextSetterProperties().keySet()) {
            OMElement prop2 = fac.createOMElement(PROP_Q);
            prop2.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            prop2.addAttribute(fac.createOMAttribute("context-name", nullNS, mediator.getContextSetterProperties().get(propName)));
            if (mediator.getContextGetterProperties().containsKey(propName)) {
                prop2.addAttribute(fac.createOMAttribute("action", nullNS, "ReadAndUpdateContext"));
            } else if (mediator.getMessageGetterProperties().containsKey(propName)) {
                AXIOMXPath exprn2 = mediator.getMessageGetterProperties().get(propName);
                prop2.addAttribute(fac.createOMAttribute("expression", nullNS, exprn2.toString()));
                this.serializeNamespaces(prop2, exprn2);
                prop2.addAttribute(fac.createOMAttribute("action", nullNS, "ReadContext"));
            } else {
                prop2.addAttribute(fac.createOMAttribute("action", nullNS, "ReadContext"));
            }
            pojoCommand.addChild((OMNode)prop2);
        }
        for (String propName : mediator.getContextGetterProperties().keySet()) {
            if (this.isSerialized(propName, mediator)) continue;
            value = mediator.getContextGetterProperties().get(propName);
            prop = fac.createOMElement(PROP_Q);
            prop.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            prop.addAttribute(fac.createOMAttribute("context-name", nullNS, (String)value));
            prop.addAttribute(fac.createOMAttribute("action", nullNS, "UpdateContext"));
            pojoCommand.addChild((OMNode)prop);
        }
        for (String propName : mediator.getMessageGetterProperties().keySet()) {
            if (this.isSerialized(propName, mediator)) continue;
            exprn = mediator.getMessageGetterProperties().get(propName);
            prop = fac.createOMElement(PROP_Q);
            prop.addAttribute(fac.createOMAttribute("name", nullNS, propName));
            prop.addAttribute(fac.createOMAttribute("expression", nullNS, exprn.toString()));
            this.serializeNamespaces(prop, exprn);
            prop.addAttribute(fac.createOMAttribute("action", nullNS, "UpdateMessage"));
            pojoCommand.addChild((OMNode)prop);
        }
        if (parent != null) {
            parent.addChild((OMNode)pojoCommand);
        }
        return pojoCommand;
    }

    private boolean isSerialized(String propName, POJOCommandMediator m) {
        return m.getContextSetterProperties().containsKey(propName) || m.getStaticSetterProperties().containsKey(propName) || m.getMessageSetterProperties().containsKey(propName);
    }

    public String getMediatorClassName() {
        return POJOCommandMediator.class.getName();
    }
}

