/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.jaxen.JaxenException;

public class OMElementUtils {
    private static final Log log = LogFactory.getLog(OMElementUtils.class);

    public static String getNameSpaceWithPrefix(String prefix, OMElement elem) {
        if (prefix == null || elem == null) {
            log.warn((Object)"Searching for null NS prefix and/or using null OMElement");
            return null;
        }
        OMElement currentElem = elem;
        while (true) {
            Iterator iter = currentElem.getAllDeclaredNamespaces();
            while (iter.hasNext()) {
                OMNamespace ns = (OMNamespace)iter.next();
                if (!prefix.equals(ns.getPrefix())) continue;
                return ns.getNamespaceURI();
            }
            OMContainer parent = currentElem.getParent();
            if (parent == null || !(parent instanceof OMElement)) break;
            currentElem = (OMElement)parent;
        }
        return null;
    }

    public static void addNameSpaces(AXIOMXPath xpath, OMElement elem, Log log) {
        OMElement currentElem = elem;
        while (currentElem != null) {
            Iterator it = currentElem.getAllDeclaredNamespaces();
            while (it.hasNext()) {
                OMNamespace n = (OMNamespace)it.next();
                if (n == null) continue;
                try {
                    xpath.addNamespace(n.getPrefix(), n.getNamespaceURI());
                }
                catch (JaxenException je) {
                    String msg = "Error adding declared name space with prefix : " + n.getPrefix() + "and uri : " + n.getNamespaceURI() + " to the XPath : " + xpath;
                    log.error((Object)msg);
                    throw new SynapseException(msg, je);
                }
            }
            OMContainer parent = currentElem.getParent();
            if (parent == null || parent instanceof OMDocument) {
                return;
            }
            if (!(parent instanceof OMElement)) continue;
            currentElem = (OMElement)parent;
        }
    }
}

