/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.mediators.MediatorProperty;
import org.jaxen.JaxenException;

public class MediatorPropertyFactory {
    private static final Log log = LogFactory.getLog(MediatorPropertyFactory.class);

    public static List getMediatorProperties(OMElement elem) {
        ArrayList<MediatorProperty> propertyList = new ArrayList<MediatorProperty>();
        Iterator iter = elem.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "property"));
        while (iter.hasNext()) {
            String msg;
            OMElement propEle = (OMElement)iter.next();
            OMAttribute attName = propEle.getAttribute(MediatorProperty.ATT_NAME_Q);
            OMAttribute attValue = propEle.getAttribute(MediatorProperty.ATT_VALUE_Q);
            OMAttribute attExpr = propEle.getAttribute(MediatorProperty.ATT_EXPR_Q);
            MediatorProperty prop = new MediatorProperty();
            if (attName == null || attName.getAttributeValue() == null || attName.getAttributeValue().trim().length() == 0) {
                msg = "Entry name is a required attribute for a Log property";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            prop.setName(attName.getAttributeValue());
            if (attValue != null) {
                if (attValue.getAttributeValue() == null || attValue.getAttributeValue().trim().length() == 0) {
                    msg = "Entry attribute value (if specified) is required for a Log property";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
                prop.setValue(attValue.getAttributeValue());
            } else if (attExpr != null) {
                if (attExpr.getAttributeValue() == null || attExpr.getAttributeValue().trim().length() == 0) {
                    msg = "Entry attribute expression (if specified) is required for a mediator property";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
                try {
                    AXIOMXPath xp = new AXIOMXPath(attExpr.getAttributeValue());
                    OMElementUtils.addNameSpaces(xp, propEle, log);
                    prop.setExpression(xp);
                }
                catch (JaxenException e) {
                    String msg2 = "Invalid XPapth expression : " + attExpr.getAttributeValue();
                    log.error((Object)msg2);
                    throw new SynapseException(msg2, e);
                }
            } else {
                msg = "Entry attribute value OR expression must be specified for a mediator property";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            propertyList.add(prop);
        }
        return propertyList;
    }
}

