/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.XMLToObjectMapper;

public class EntryFactory
implements XMLToObjectMapper {
    private static Log log = LogFactory.getLog(EntryFactory.class);

    public static Entry createEntry(OMElement elem) {
        OMAttribute key = elem.getAttribute(new QName("", "key"));
        if (key == null) {
            EntryFactory.handleException("The 'key' attribute is required for a local registry entry");
            return null;
        }
        Entry entry = new Entry(key.getAttributeValue());
        String src = elem.getAttributeValue(new QName("", "src"));
        if (src != null) {
            try {
                entry.setSrc(new URL(src.trim()));
                entry.setType(2);
                entry.setValue(SynapseConfigUtils.getObject(entry.getSrc()));
            }
            catch (MalformedURLException e) {
                EntryFactory.handleException("The entry with key : " + key + " refers to an invalid URL");
            }
        } else {
            OMNode nodeValue = elem.getFirstOMChild();
            OMElement elemValue = elem.getFirstElement();
            if (elemValue != null) {
                entry.setType(1);
                entry.setValue(elemValue);
            } else if (nodeValue != null && nodeValue instanceof OMText) {
                entry.setType(0);
                entry.setValue(((OMText)nodeValue).getText().trim());
            }
        }
        return entry;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public Object getObjectFromOMNode(OMNode om) {
        if (om instanceof OMElement) {
            return EntryFactory.createEntry((OMElement)om);
        }
        EntryFactory.handleException("Invalid XML configuration for an Entry. OMElement expected");
        return null;
    }
}

