/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.mediators.builtin.CalloutMediator;
import org.jaxen.JaxenException;

public class CalloutMediatorFactory
extends AbstractMediatorFactory {
    private static final QName TAG_NAME = new QName("http://ws.apache.org/ns/synapse", "callout");
    private static final QName ATT_URL = new QName("serviceURL");
    private static final QName ATT_ACTION = new QName("action");
    private static final QName Q_SOURCE = new QName("http://ws.apache.org/ns/synapse", "source");
    private static final QName Q_TARGET = new QName("http://ws.apache.org/ns/synapse", "target");

    public Mediator createMediator(OMElement elem) {
        CalloutMediator callout = new CalloutMediator();
        OMAttribute attServiceURL = elem.getAttribute(ATT_URL);
        OMAttribute attAction = elem.getAttribute(ATT_ACTION);
        OMElement sourceElt = elem.getFirstChildWithName(Q_SOURCE);
        OMElement targetElt = elem.getFirstChildWithName(Q_TARGET);
        if (attServiceURL != null) {
            callout.setServiceURL(attServiceURL.getAttributeValue());
        } else {
            this.handleException("The 'serviceURL' attribute is required for the Callout mediator");
        }
        if (attAction != null) {
            callout.setAction(attAction.getAttributeValue());
        }
        if (sourceElt != null) {
            if (sourceElt.getAttribute(ATT_XPATH) != null) {
                try {
                    callout.setRequestXPathString(sourceElt.getAttributeValue(ATT_XPATH));
                    OMElementUtils.addNameSpaces(callout.getRequestXPath(), sourceElt, log);
                }
                catch (JaxenException e) {
                    this.handleException("Invalid source XPath : " + sourceElt.getAttributeValue(ATT_XPATH));
                }
            } else if (sourceElt.getAttribute(ATT_KEY) != null) {
                callout.setRequestKey(sourceElt.getAttributeValue(ATT_KEY));
            } else {
                this.handleException("A 'xpath' or 'key' attribute is required for the Callout 'source'");
            }
        } else {
            this.handleException("The message 'source' must be specified for a Callout mediator");
        }
        if (targetElt != null) {
            if (targetElt.getAttribute(ATT_XPATH) != null) {
                try {
                    callout.setTargetXPathString(targetElt.getAttributeValue(ATT_XPATH));
                    OMElementUtils.addNameSpaces(callout.getTargetXPath(), targetElt, log);
                }
                catch (JaxenException e) {
                    this.handleException("Invalid target XPath : " + targetElt.getAttributeValue(ATT_XPATH));
                }
            } else if (targetElt.getAttribute(ATT_KEY) != null) {
                callout.setTargetKey(targetElt.getAttributeValue(ATT_KEY));
            } else {
                this.handleException("A 'xpath' or 'key' attribute is required for the Callout 'target'");
            }
        } else {
            this.handleException("The message 'target' must be specified for a Callout mediator");
        }
        return callout;
    }

    public QName getTagQName() {
        return TAG_NAME;
    }
}

