/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.MediatorSerializer;
import org.apache.synapse.mediators.MediatorProperty;

public abstract class AbstractMediatorSerializer
implements MediatorSerializer {
    protected static Log log;
    protected static final OMFactory fac;
    protected static final OMNamespace synNS;
    protected static final OMNamespace nullNS;
    protected static final QName PROP_Q;

    protected AbstractMediatorSerializer() {
        log = LogFactory.getLog(this.getClass());
    }

    protected static void saveTracingState(OMElement mediatorOmElement, Mediator mediator) {
        int traceState = mediator.getTraceState();
        String traceValue = null;
        if (traceState == 1) {
            traceValue = "enable";
        } else if (traceState == 0) {
            traceValue = "disable";
        }
        if (traceValue != null) {
            mediatorOmElement.addAttribute(fac.createOMAttribute("trace", nullNS, traceValue));
        }
    }

    protected void serializeMediatorProperties(OMElement parent, Collection props) {
        for (MediatorProperty mp : props) {
            OMElement prop = fac.createOMElement("property", synNS, (OMContainer)parent);
            if (mp.getName() != null) {
                prop.addAttribute(fac.createOMAttribute("name", nullNS, mp.getName()));
            } else {
                this.handleException("Mediator property name missing");
            }
            if (mp.getValue() != null) {
                prop.addAttribute(fac.createOMAttribute("value", nullNS, mp.getValue()));
                continue;
            }
            if (mp.getExpression() != null) {
                prop.addAttribute(fac.createOMAttribute("expression", nullNS, mp.getExpression().toString()));
                this.serializeNamespaces(prop, mp.getExpression());
                continue;
            }
            this.handleException("Mediator property must have a literal value or be an expression");
        }
    }

    protected void serializeProperties(OMElement parent, Collection props) {
        this.serializeMediatorProperties(parent, props);
    }

    protected void serializeNamespaces(OMElement elem, AXIOMXPath xpath) {
        for (String prefix : xpath.getNamespaces().keySet()) {
            String uri = xpath.getNamespaceContext().translateNamespacePrefixToUri(prefix);
            if ("http://ws.apache.org/ns/synapse".equals(uri)) continue;
            elem.declareNamespace(uri, prefix);
        }
    }

    protected void handleException(String msg) {
        LogFactory.getLog(this.getClass()).error((Object)msg);
        throw new SynapseException(msg);
    }

    protected void handleException(String msg, Exception e) {
        LogFactory.getLog(this.getClass()).error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    static {
        fac = OMAbstractFactory.getOMFactory();
        synNS = fac.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
        nullNS = fac.createOMNamespace("", "");
        PROP_Q = new QName("http://ws.apache.org/ns/synapse", "property", "syn");
    }
}

