/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.XMLConfigurationBuilder;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.builtin.DropMediator;
import org.apache.synapse.mediators.builtin.LogMediator;

public class SynapseConfigurationBuilder {
    private static Log log = LogFactory.getLog(SynapseConfigurationBuilder.class);

    public static SynapseConfiguration getDefaultConfiguration() {
        SynapseConfiguration config = new SynapseConfiguration();
        SequenceMediator mainmediator = new SequenceMediator();
        mainmediator.addChild(new LogMediator());
        mainmediator.addChild(new DropMediator());
        config.addSequence("main", mainmediator);
        SequenceMediator faultmediator = new SequenceMediator();
        LogMediator fault = new LogMediator();
        fault.setLogLevel(3);
        faultmediator.addChild(fault);
        config.addSequence("fault", faultmediator);
        return config;
    }

    public static SynapseConfiguration getConfiguration(String configFile) {
        try {
            SynapseConfiguration synCfg = XMLConfigurationBuilder.getConfiguration(new FileInputStream(configFile));
            log.info((Object)("Loaded Synapse configuration from : " + configFile));
            synCfg.setPathToConfigFile(new File(configFile).getAbsolutePath());
            SynapseConfigurationBuilder.loadSynapseProperties(synCfg);
            return synCfg;
        }
        catch (FileNotFoundException fnf) {
            SynapseConfigurationBuilder.handleException("Cannot load Synapse configuration from : " + configFile, fnf);
        }
        catch (Exception e) {
            SynapseConfigurationBuilder.handleException("Could not initialize Synapse : " + e.getMessage(), e);
        }
        return null;
    }

    private static void loadSynapseProperties(SynapseConfiguration synCfg) {
        block3: {
            String props = System.getProperty("synapse.properties");
            if (props == null) {
                props = "synapse.properties";
            }
            try {
                synCfg.getProperties().load(Thread.currentThread().getContextClassLoader().getResourceAsStream(props));
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Unable to load synapse properties : Using the default tunning parameters for Synapse");
            }
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

