/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.endpoints.XMLToEndpointMapper;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.registry.Registry;

public class SynapseConfiguration
implements ManagedLifecycle {
    private static final Log log = LogFactory.getLog(SynapseConfiguration.class);
    Registry registry = null;
    private QName defaultQName = null;
    private Map proxyServices = new HashMap();
    private Map startups = new HashMap();
    private Map localRegistry = new HashMap();
    private Properties properties = new Properties();
    private Timer synapseTimer = new Timer(true);
    private AxisConfiguration axisConfiguration = null;
    private String pathToConfigFile = null;

    public void addSequence(String key, Mediator mediator) {
        this.localRegistry.put(key, mediator);
    }

    public void addSequence(String key, Entry entry) {
        this.localRegistry.put(key, entry);
    }

    public Map getDefinedSequences() {
        HashMap definedSequences = new HashMap();
        for (Object o : this.localRegistry.values()) {
            if (!(o instanceof SequenceMediator)) continue;
            definedSequences.put(((SequenceMediator)o).getName(), o);
        }
        return definedSequences;
    }

    public Mediator getSequence(String key) {
        Object o = this.localRegistry.get(key);
        if (o != null && o instanceof Mediator) {
            return (Mediator)o;
        }
        Entry entry = null;
        if (o != null && o instanceof Entry) {
            entry = (Entry)o;
        } else {
            entry = new Entry(key);
            entry.setType(3);
            entry.setMapper(MediatorFactoryFinder.getInstance());
        }
        if (this.registry != null && (o = this.registry.getResource(entry)) != null && o instanceof Mediator) {
            this.localRegistry.put(key, entry);
            return (Mediator)o;
        }
        return null;
    }

    public void removeSequence(String key) {
        this.localRegistry.remove(key);
    }

    public Mediator getMainSequence() {
        return this.getSequence("main");
    }

    public Mediator getFaultSequence() {
        return this.getSequence("fault");
    }

    public void addEntry(String key, Entry entry) {
        if (entry.getType() == 2) {
            try {
                entry.setValue(SynapseConfigUtils.getOMElementFromURL(entry.getSrc().toString()));
                this.localRegistry.put(key, entry);
            }
            catch (IOException e) {
                this.handleException("Can not read from source URL : " + entry.getSrc());
            }
        } else {
            this.localRegistry.put(key, entry);
        }
    }

    public Map getCachedEntries() {
        HashMap<String, Entry> cachedEntries = new HashMap<String, Entry>();
        for (Object o : this.localRegistry.values()) {
            Entry entry;
            if (o == null || !(o instanceof Entry) || !(entry = (Entry)o).isDynamic() || !entry.isCached()) continue;
            cachedEntries.put(entry.getKey(), entry);
        }
        return cachedEntries;
    }

    public Map getDefinedEntries() {
        HashMap definedEntries = new HashMap();
        for (Object o : this.localRegistry.values()) {
            if (!(o instanceof Entry) || ((Entry)o).getType() == 3) continue;
            definedEntries.put(((Entry)o).getKey(), o);
        }
        return definedEntries;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getEntry(String key) {
        void var2_4;
        Object v = this.localRegistry.get(key);
        if (v == null || !(v instanceof Entry)) return var2_4;
        Entry entry = (Entry)v;
        if (!entry.isDynamic()) return entry.getValue();
        if (entry.isCached() && !entry.isExpired()) {
            return entry.getValue();
        }
        if (this.registry != null) {
            Object object = this.registry.getResource(entry);
            return var2_4;
        } else {
            if (!log.isDebugEnabled()) return null;
            log.debug((Object)("Will not  evaluate the value of the remote entry with a key " + key + ",  because the registry is not available"));
            return null;
        }
    }

    public Entry getEntryDefinition(String key) {
        Object o = this.localRegistry.get(key);
        if (o == null || o instanceof Entry) {
            if (o == null) {
                Entry entry = new Entry(key);
                entry.setType(3);
                this.addEntry(key, entry);
                return entry;
            }
            return (Entry)o;
        }
        this.handleException("Invalid local registry entry : " + key);
        return null;
    }

    public void removeEntry(String key) {
        this.localRegistry.remove(key);
    }

    public void clearCachedEntry(String key) {
        Entry entry = this.getEntryDefinition(key);
        if (entry.isDynamic() && entry.isCached()) {
            entry.clearCache();
        }
    }

    public void clearCache() {
        for (Object o : this.localRegistry.values()) {
            Entry entry;
            if (o == null || !(o instanceof Entry) || !(entry = (Entry)o).isDynamic() || !entry.isCached()) continue;
            entry.clearCache();
        }
    }

    public void addEndpoint(String key, Endpoint endpoint) {
        this.localRegistry.put(key, endpoint);
    }

    public void addEndpoint(String key, Entry entry) {
        this.localRegistry.put(key, entry);
    }

    public Map getDefinedEndpoints() {
        HashMap definedEndpoints = new HashMap();
        for (Object o : this.localRegistry.values()) {
            if (!(o instanceof Endpoint)) continue;
            definedEndpoints.put(((Endpoint)o).getName(), o);
        }
        return definedEndpoints;
    }

    public Endpoint getEndpoint(String key) {
        Object o = this.localRegistry.get(key);
        if (o != null && o instanceof Endpoint) {
            return (Endpoint)o;
        }
        Entry entry = null;
        if (o != null && o instanceof Entry) {
            entry = (Entry)o;
        } else {
            entry = new Entry(key);
            entry.setType(3);
            entry.setMapper(XMLToEndpointMapper.getInstance());
        }
        if (this.registry != null && (o = this.registry.getResource(entry)) != null && o instanceof Endpoint) {
            this.localRegistry.put(key, entry);
            return (Endpoint)o;
        }
        return null;
    }

    public void removeEndpoint(String key) {
        this.localRegistry.remove(key);
    }

    public void addProxyService(String name, ProxyService proxy) {
        this.proxyServices.put(name, proxy);
    }

    public ProxyService getProxyService(String name) {
        return (ProxyService)this.proxyServices.get(name);
    }

    public void removeProxyService(String name) {
        Object o = this.proxyServices.get(name);
        if (o == null) {
            this.handleException("Unknown proxy service for name : " + name);
        } else {
            try {
                if (this.getAxisConfiguration().getServiceForActivation(name) != null) {
                    if (this.getAxisConfiguration().getServiceForActivation(name).isActive()) {
                        this.getAxisConfiguration().getService(name).setActive(false);
                    }
                    this.getAxisConfiguration().removeService(name);
                }
                this.proxyServices.remove(name);
            }
            catch (AxisFault axisFault) {
                this.handleException(axisFault.getMessage());
            }
        }
    }

    public Collection getProxyServices() {
        return this.proxyServices.values();
    }

    public Map getLocalRegistry() {
        return Collections.unmodifiableMap(this.localRegistry);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setAxisConfiguration(AxisConfiguration axisConfig) {
        this.axisConfiguration = axisConfig;
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.axisConfiguration;
    }

    public String getPathToConfigFile() {
        return this.pathToConfigFile;
    }

    public void setPathToConfigFile(String pathToConfigFile) {
        this.pathToConfigFile = pathToConfigFile;
    }

    public void setDefaultQName(QName defaultQName) {
        this.defaultQName = defaultQName;
    }

    public QName getDefaultQName() {
        return this.defaultQName;
    }

    public Timer getSynapseTimer() {
        return this.synapseTimer;
    }

    public Collection getStartups() {
        return this.startups.values();
    }

    public Startup getStartup(String id) {
        return (Startup)this.startups.get(id);
    }

    public void addStartup(Startup startup) {
        this.startups.put(startup.getName(), startup);
    }

    public void removeStartup(String name) {
        this.startups.remove(name);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String propKey, String def) {
        String val = System.getProperty(propKey);
        if (val == null) {
            val = this.properties.getProperty(propKey);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using synapse tuning parameter : " + propKey + " = " + val));
            }
            return val;
        }
        return def;
    }

    public String getProperty(String propKey) {
        String val = System.getProperty(propKey);
        if (val == null) {
            val = this.properties.getProperty(propKey);
        }
        if (val != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using synapse tuning parameter : " + propKey + " = " + val));
            }
            return val;
        }
        return null;
    }

    public void destroy() {
        ManagedLifecycle m;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Destroying the Synapse Configuration");
        }
        this.synapseTimer.cancel();
        this.synapseTimer = null;
        for (Object o : this.getProxyServices()) {
            if (!(o instanceof ProxyService)) continue;
            ProxyService p = (ProxyService)o;
            if (p.getTargetInLineInSequence() != null) {
                p.getTargetInLineInSequence().destroy();
            }
            if (p.getTargetInLineOutSequence() == null) continue;
            p.getTargetInLineOutSequence().destroy();
        }
        Map sequences = this.getDefinedSequences();
        for (Map.Entry o : sequences.entrySet()) {
            if (!(o instanceof ManagedLifecycle)) continue;
            m = (ManagedLifecycle)((Object)o);
            m.destroy();
        }
        if (this.startups != null) {
            for (Map.Entry o : this.startups.values()) {
                if (!(o instanceof ManagedLifecycle)) continue;
                m = (ManagedLifecycle)((Object)o);
                m.destroy();
            }
        }
    }

    public void init(SynapseEnvironment se) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing the Synapse Configuration");
        }
        if (this.registry != null && this.registry instanceof ManagedLifecycle) {
            ((ManagedLifecycle)((Object)this.registry)).init(se);
        }
        for (Object o : this.getProxyServices()) {
            if (!(o instanceof ProxyService)) continue;
            ProxyService p = (ProxyService)o;
            if (p.getTargetInLineInSequence() != null) {
                p.getTargetInLineInSequence().init(se);
            }
            if (p.getTargetInLineOutSequence() == null) continue;
            p.getTargetInLineOutSequence().init(se);
        }
        Map sequences = this.getDefinedSequences();
        for (Object o : sequences.values()) {
            if (!(o instanceof ManagedLifecycle)) continue;
            ManagedLifecycle m = (ManagedLifecycle)o;
            m.init(se);
        }
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

