/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.XMLToObjectMapper;
import org.xml.sax.InputSource;

public class SynapseConfigUtils {
    private static final Log log = LogFactory.getLog(SynapseConfigUtils.class);

    public static StreamSource getStreamSource(Object o) {
        if (o == null) {
            SynapseConfigUtils.handleException("Cannot convert null to a StreamSource");
        } else if (o instanceof OMNode) {
            OMNode omNode = (OMNode)o;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                omNode.serialize((OutputStream)baos);
                return new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (XMLStreamException e) {
                SynapseConfigUtils.handleException("Error converting to a StreamSource", e);
            }
        } else {
            SynapseConfigUtils.handleException("Cannot convert object to a StreamSource");
        }
        return null;
    }

    public static InputStream getInputStream(Object o) {
        if (o == null) {
            SynapseConfigUtils.handleException("Cannot convert null to a StreamSource");
        } else if (o instanceof OMElement) {
            OMElement omElement = (OMElement)o;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                omElement.serialize((OutputStream)baos);
                return new ByteArrayInputStream(baos.toByteArray());
            }
            catch (XMLStreamException e) {
                SynapseConfigUtils.handleException("Error converting to a StreamSource", e);
            }
        } else if (o instanceof URI) {
            try {
                return ((URI)o).toURL().openStream();
            }
            catch (IOException e) {
                SynapseConfigUtils.handleException("Error opening stream form URI", e);
            }
        } else {
            SynapseConfigUtils.handleException("Cannot convert object to a StreamSource");
        }
        return null;
    }

    public static Object getObject(URL url) {
        try {
            block15: {
                if (url != null && "file".equals(url.getProtocol())) {
                    try {
                        url.openStream();
                    }
                    catch (IOException ignored) {
                        String synapseHome;
                        String path = url.getPath();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Can not open a connection to the URL with a path :" + path));
                        }
                        if ((synapseHome = System.getProperty("synapse.home")) == null) break block15;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Trying  to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                        }
                        if (synapseHome.endsWith("/")) {
                            synapseHome = synapseHome.substring(0, synapseHome.lastIndexOf("/"));
                        }
                        url = new URL(url.getProtocol() + ":" + synapseHome + "/" + path);
                        try {
                            url.openStream();
                        }
                        catch (IOException e) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Faild to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                            }
                            log.warn((Object)("IO Error reading from URL " + url.getPath() + e));
                        }
                    }
                }
            }
            if (url == null) {
                return null;
            }
            URLConnection urlc = url.openConnection();
            XMLToObjectMapper xmlToObject = SynapseConfigUtils.getXmlToObjectMapper(urlc.getContentType());
            try {
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(urlc.getInputStream());
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement omElem = builder.getDocumentElement();
                omElem.build();
                if (xmlToObject != null) {
                    return xmlToObject.getObjectFromOMNode((OMNode)omElem);
                }
                return omElem;
            }
            catch (XMLStreamException e) {
                log.warn((Object)("Content at URL : " + url + " is non XML.."));
                return urlc.getContent();
            }
        }
        catch (IOException e) {
            SynapseConfigUtils.handleException("Error connecting to URL : " + url, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMElement getOMElementFromURL(String urlStr) throws IOException {
        URL url = SynapseConfigUtils.getURLFromPath(urlStr);
        if (url == null) {
            return null;
        }
        URLConnection conn = url.openConnection();
        conn.setReadTimeout(SynapseConfigUtils.getReadTimeout());
        conn.setConnectTimeout(SynapseConfigUtils.getConnectionTimeout());
        conn.setRequestProperty("Connection", "close");
        InputStream urlInStream = conn.getInputStream();
        if (urlInStream != null) {
            try {
                StAXOMBuilder builder = new StAXOMBuilder(urlInStream);
                OMElement doc = builder.getDocumentElement();
                doc.build();
                OMElement oMElement = doc;
                return oMElement;
            }
            catch (Exception e) {
                SynapseConfigUtils.handleException("Error parsing resource at URL : " + url + " as XML", e);
            }
            finally {
                try {
                    urlInStream.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }

    public static InputSource getInputSourceFormURI(URI uri) {
        if (uri == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Can not create a URL from 'null' ");
            }
            return null;
        }
        try {
            URL url = uri.toURL();
            String protocol = url.getProtocol();
            String path = url.getPath();
            if (protocol == null || "".equals(protocol)) {
                url = new URL("file:" + path);
            }
            URLConnection conn = url.openConnection();
            conn.setReadTimeout(SynapseConfigUtils.getReadTimeout());
            conn.setConnectTimeout(SynapseConfigUtils.getConnectionTimeout());
            conn.setRequestProperty("Connection", "close");
            InputStream urlInStream = conn.getInputStream();
            return new InputSource(urlInStream);
        }
        catch (MalformedURLException e) {
            SynapseConfigUtils.handleException("Invalid URL ' " + uri + " '", e);
        }
        catch (IOException e) {
            SynapseConfigUtils.handleException("Error reading at URI ' " + uri + " ' ", e);
        }
        return null;
    }

    private static int getReadTimeout() {
        String readTO = System.getProperty("Connection.ReadTimeout");
        int readTimeout = 100000;
        if (readTO != null && !"".equals(readTO)) {
            try {
                readTimeout = Integer.parseInt(readTO);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return readTimeout;
    }

    private static int getConnectionTimeout() {
        String connectionTO = System.getProperty("Connection.ConnectTimeout");
        int connectionTimeout = 20000;
        if (connectionTO != null && !"".equals(connectionTO)) {
            try {
                connectionTimeout = Integer.parseInt(connectionTO);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return connectionTimeout;
    }

    private static void handleException(String msg, Exception e) {
        log.warn((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static void handleException(String msg) {
        log.warn((Object)msg);
        throw new SynapseException(msg);
    }

    public static XMLToObjectMapper getXmlToObjectMapper(String contentType) {
        return null;
    }

    public static URL getURLFromPath(String path) {
        URL url;
        block15: {
            if (path == null || "null".equals(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can not create a URL from 'null' ");
                }
                return null;
            }
            url = null;
            try {
                url = new URL(path);
                if (!"file".equals(url.getProtocol())) break block15;
                try {
                    url.openStream();
                }
                catch (MalformedURLException e) {
                    SynapseConfigUtils.handleException("Invalid URL reference : " + path, e);
                }
                catch (IOException ignored) {
                    String synapseHome;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Can not open a connection to the URL with a path :" + path));
                    }
                    if ((synapseHome = System.getProperty("synapse.home")) == null) break block15;
                    if (synapseHome.endsWith("/")) {
                        synapseHome = synapseHome.substring(0, synapseHome.lastIndexOf("/"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Trying  to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                    }
                    try {
                        url = new URL(url.getProtocol() + ":" + synapseHome + "/" + url.getPath());
                        url.openStream();
                    }
                    catch (MalformedURLException e) {
                        SynapseConfigUtils.handleException("Invalid URL reference " + url.getPath() + e);
                    }
                    catch (IOException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Faild to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                        }
                        log.warn((Object)("IO Error reading from URL : " + url.getPath() + e));
                    }
                }
            }
            catch (MalformedURLException e) {
                SynapseConfigUtils.handleException("Invalid URL reference :  " + path, e);
            }
            catch (IOException e) {
                SynapseConfigUtils.handleException("IO Error reading from URL : " + path, e);
            }
        }
        return url;
    }

    public static InputSource resolveRelativeURI(String parentLocation, String relativeLocation) {
        if (relativeLocation == null) {
            throw new IllegalArgumentException("Import URI cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving import URI ' " + parentLocation + " '  against base URI ' " + relativeLocation + " '  "));
        }
        URI importUri = null;
        try {
            importUri = new URI(relativeLocation);
            if (importUri.isAbsolute()) {
                return SynapseConfigUtils.getInputSourceFormURI(importUri);
            }
        }
        catch (URISyntaxException e) {
            SynapseConfigUtils.handleException("Invalid URI", e);
        }
        if (parentLocation == null) {
            return SynapseConfigUtils.getInputSourceFormURI(importUri);
        }
        if (relativeLocation.startsWith("/") || relativeLocation.startsWith("\\")) {
            if (importUri != null && !importUri.isAbsolute()) {
                try {
                    importUri = new URI("file:" + relativeLocation);
                    return SynapseConfigUtils.getInputSourceFormURI(importUri);
                }
                catch (URISyntaxException e) {
                    SynapseConfigUtils.handleException("Invalid URI ' " + importUri.getPath() + " '", e);
                }
            }
        } else {
            int index = parentLocation.lastIndexOf("/");
            if (index == -1) {
                index = parentLocation.lastIndexOf("\\");
            }
            if (index != -1) {
                String basepath = parentLocation.substring(0, index + 1);
                String resolvedPath = basepath + relativeLocation;
                try {
                    URI resolvedUri = new URI(resolvedPath);
                    if (!resolvedUri.isAbsolute()) {
                        resolvedUri = new URI("file:" + resolvedPath);
                    }
                    return SynapseConfigUtils.getInputSourceFormURI(resolvedUri);
                }
                catch (URISyntaxException e) {
                    SynapseConfigUtils.handleException("Invalid URI ' " + resolvedPath + " '", e);
                }
            } else {
                return SynapseConfigUtils.getInputSourceFormURI(importUri);
            }
        }
        return null;
    }
}

