/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerManager;

public class SynapseServer {
    private static final Log log = LogFactory.getLog(SynapseServer.class);

    public static void printUsage() {
        System.out.println("Usage: SynapseServer <repository>");
        System.out.println(" Opts: -? this message");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1 || !new File(args[0]).exists()) {
            SynapseServer.printUsage();
        }
        ServerManager serverManager = ServerManager.getInstance();
        serverManager.setAxis2Repolocation(args[0]);
        serverManager.start();
        SynapseServer.addShutdownHook();
    }

    private static void addShutdownHook() {
        Thread shutdownHook = new Thread(){

            public void run() {
                log.info((Object)"Shutting down Apache Synapse ...");
                try {
                    ServerManager.getInstance().stop();
                    log.info((Object)"Shutdown complete");
                    log.info((Object)"Halting JVM");
                }
                catch (Exception e) {
                    log.warn((Object)("Error occurred while shutting down Apache Synapse : " + e));
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }
}

