/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.CallerConfiguration;
import org.wso2.throttle.ThrottleContext;
import org.wso2.throttle.ThrottleException;

public abstract class CallerContext
implements Serializable {
    private static Log log = LogFactory.getLog((String)CallerContext.class.getName());
    private long nextAccessTime = 0L;
    private long firstAccessTime = 0L;
    private long nextTimeWindow = 0L;
    private int count = 0;
    private String ID;
    private static final long serialVersionUID = 1652165180220263492L;

    public CallerContext(String ID) {
        if (ID == null || "".equals(ID)) {
            throw new InstantiationError("Couldn't create a CallContext for an empty remote caller ID");
        }
        this.ID = ID;
    }

    public String getID() {
        return this.ID;
    }

    private void initAccess(CallerConfiguration configuration, ThrottleContext throttleContext, long currentTime) {
        this.firstAccessTime = currentTime;
        this.nextTimeWindow = currentTime + configuration.getUnitTime();
        throttleContext.addCallerContext(this, this.ID);
    }

    private boolean canAccessIfUnitTimeNotOver(CallerConfiguration configuration, ThrottleContext throttleContext, long currentTime) {
        boolean canAcess = false;
        int maxRequest = configuration.getMaximumRequestPerUnitTime();
        if (maxRequest != 0) {
            if (this.count <= maxRequest - 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Access allowed :: " + (maxRequest - this.count) + " of available of " + maxRequest + " connections"));
                }
                canAcess = true;
                ++this.count;
                throttleContext.flushCallerContext(this, this.ID);
            } else if (this.nextAccessTime == 0L) {
                long prohititTime = configuration.getProhibitTimePeriod();
                this.nextAccessTime = prohititTime == 0L ? this.firstAccessTime + configuration.getUnitTime() : currentTime + prohititTime;
                if (log.isDebugEnabled()) {
                    String type = 0 == configuration.getType() ? "IP address" : "domain";
                    log.debug((Object)("Maximum Number of requests are reached for caller with " + type + " - " + this.ID));
                }
                throttleContext.flushCallerContext(this, this.ID);
            } else if (this.nextAccessTime <= currentTime) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Access allowed :: " + maxRequest + " of available of " + maxRequest + " connections"));
                }
                if (this.nextTimeWindow != 0L) {
                    throttleContext.removeCallerContext(this.ID);
                }
                this.nextAccessTime = 0L;
                canAcess = true;
                this.count = 1;
                this.firstAccessTime = currentTime;
                this.nextTimeWindow = currentTime + configuration.getUnitTime();
                throttleContext.addAndFlushCallerContext(this, this.ID);
            } else if (log.isDebugEnabled()) {
                String type = 0 == configuration.getType() ? "IP address" : "domain";
                log.debug((Object)("Prohibit period is not yet over for caller with " + type + " - " + this.ID));
            }
        }
        return canAcess;
    }

    private boolean canAccessIfUnitTimeOver(CallerConfiguration configuration, ThrottleContext throttleContext, long currentTime) {
        boolean canAcess = false;
        int maxRequest = configuration.getMaximumRequestPerUnitTime();
        if (maxRequest != 0) {
            if (this.count <= maxRequest - 1) {
                if (this.nextTimeWindow != 0L) {
                    throttleContext.removeAndFlushCaller(this.ID);
                }
                canAcess = true;
            } else if (this.nextAccessTime == 0L || this.nextAccessTime <= currentTime) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Access allowed :: " + maxRequest + " of available of " + maxRequest + " connections"));
                }
                if (this.nextTimeWindow != 0L) {
                    throttleContext.removeCallerContext(this.ID);
                }
                this.nextAccessTime = 0L;
                canAcess = true;
                this.count = 1;
                this.firstAccessTime = currentTime;
                this.nextTimeWindow = currentTime + configuration.getUnitTime();
                throttleContext.addAndFlushCallerContext(this, this.ID);
            } else if (log.isDebugEnabled()) {
                String type = 0 == configuration.getType() ? "IP address" : "domain";
                log.debug((Object)("Even unit time has overed , CallerContext in prohibit state :" + type + " - " + this.ID));
            }
        }
        return canAcess;
    }

    public void cleanUpCallers(CallerConfiguration configuration, ThrottleContext throttleContext, long currentTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cleaning up the inactive caller's states ... ");
        }
        if (configuration == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Couldn't find the configuration .");
            }
            return;
        }
        int maxRequest = configuration.getMaximumRequestPerUnitTime();
        if (maxRequest != 0) {
            if (this.count <= maxRequest - 1) {
                if (this.nextTimeWindow != 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removing caller with id " + this.ID));
                    }
                    throttleContext.removeAndFlushCaller(this.ID);
                }
            } else if ((this.nextAccessTime == 0L || this.nextAccessTime <= currentTime) && this.nextTimeWindow != 0L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing caller with id " + this.ID));
                }
                throttleContext.removeAndFlushCaller(this.ID);
            }
        }
    }

    public boolean canAccess(ThrottleContext throttleContext, CallerConfiguration configuration, long currentTime) throws ThrottleException {
        if (configuration == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Couldn't find the configuration .");
            }
            return true;
        }
        if (configuration.getMaximumRequestPerUnitTime() < 0 || configuration.getUnitTime() <= 0L || configuration.getProhibitTimePeriod() < 0L) {
            throw new ThrottleException("Invalid Throttle Configuration");
        }
        if (this.firstAccessTime == 0L) {
            this.initAccess(configuration, throttleContext, currentTime);
        }
        boolean canAcess = this.nextTimeWindow > currentTime ? this.canAccessIfUnitTimeNotOver(configuration, throttleContext, currentTime) : this.canAccessIfUnitTimeOver(configuration, throttleContext, currentTime);
        return canAcess;
    }

    public long getNextTimeWindow() {
        return this.nextTimeWindow;
    }

    public abstract int getType();
}

