/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.CallerConfiguration;
import org.wso2.throttle.CallerContext;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleContext;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.factory.CallerContextFactory;

public class AccessRateController {
    private static Log log = LogFactory.getLog((String)AccessRateController.class.getName());
    private static final String ACCESS_DENIED_TEMPORALLY = "You cannot access this service since you have exceeded the allocated quota.";
    private static final String ACCESS_DENIED = "You cannot access this service since you have prohibited permanently.";
    private final Object lock = new Object();
    private boolean debugOn = log.isDebugEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAccess(ThrottleContext throttleContext, String callerID, int callerType) throws ThrottleException {
        String type = 0 == callerType ? "IP address" : "domain";
        ThrottleConfiguration throttleConfigurationBean = throttleContext.getThrottleConfiguration();
        if (throttleConfigurationBean == null) {
            if (this.debugOn) {
                log.debug((Object)"Thorttle Configuration couldn't find - Throttling will not occur");
            }
            return true;
        }
        if (callerID == null) {
            if (this.debugOn) {
                log.debug((Object)"Caller host or ip  couldn't find !! - Access will be denied ");
            }
            return false;
        }
        CallerConfiguration configuration = throttleConfigurationBean.getCallerConfiguration(callerID);
        if (configuration == null) {
            if (this.debugOn) {
                log.debug((Object)("Caller configuration couldn't find for " + type + " and for caller " + callerID));
            }
            return true;
        }
        if (configuration.getAccessState() == 1) {
            log.info((Object)ACCESS_DENIED);
            return false;
        }
        if (configuration.getAccessState() == 2) {
            return true;
        }
        if (configuration.getAccessState() == 0) {
            Object object = this.lock;
            synchronized (object) {
                CallerContext caller = throttleContext.getCallerContext(callerID);
                if (caller == null) {
                    caller = CallerContextFactory.createCaller(callerType, callerID);
                }
                if (caller != null) {
                    long currentTime = System.currentTimeMillis();
                    if (!caller.canAccess(throttleContext, configuration, currentTime)) {
                        log.info((Object)ACCESS_DENIED_TEMPORALLY);
                        throttleContext.processCleanList(currentTime);
                        return false;
                    }
                    if (this.debugOn) {
                        log.debug((Object)("Access  from " + type + " " + callerID + " is successful."));
                    }
                    return true;
                }
                if (this.debugOn) {
                    log.debug((Object)("Caller " + type + " not found! " + callerID));
                }
                return true;
            }
        }
        return true;
    }
}

