/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.ftp.FTPClientWrapper;
import org.apache.commons.vfs.provider.ftp.FtpFileNameParser;
import org.apache.commons.vfs.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs.provider.ftp.FtpFileSystemConfigBuilder;

public class FtpFileProvider
extends AbstractOriginatingFileProvider {
    public static final String ATTR_FILE_ENTRY_PARSER = "FEP";
    public static final String PASSIVE_MODE = "vfs.passive";
    static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.GET_LAST_MODIFIED, Capability.URI, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT, Capability.RANDOM_ACCESS_READ));
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};

    public FtpFileProvider() {
        this.setFileNameParser(FtpFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        URLFileName rootName = (URLFileName)name;
        String queryString = rootName.getQueryString();
        FileSystemOptions opts = fileSystemOptions;
        if (opts == null) {
            opts = new FileSystemOptions();
        }
        if (queryString != null) {
            FtpFileSystemConfigBuilder cfgBuilder = FtpFileSystemConfigBuilder.getInstance();
            StringTokenizer st = new StringTokenizer(queryString, "?&!=");
            while (st.hasMoreTokens()) {
                if (!PASSIVE_MODE.equalsIgnoreCase(st.nextToken()) || !st.hasMoreTokens() || !"true".equalsIgnoreCase(st.nextToken())) continue;
                cfgBuilder.setPassiveMode(opts, true);
            }
        }
        FTPClientWrapper ftpClient = new FTPClientWrapper(rootName, opts);
        return new FtpFileSystem(rootName, ftpClient, fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return FtpFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

