/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.throttle;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.throttle.ThrottleMediator;

public class ThrottleMediatorSerializer
extends AbstractMediatorSerializer {
    private static final Log log = LogFactory.getLog(ThrottleMediatorSerializer.class);
    private static final OMNamespace throttleNS = fac.createOMNamespace("http://ws.apache.org/ns/synapse", "throttle");

    public OMElement serializeMediator(OMElement parent, Mediator m) {
        String onReject;
        if (!(m instanceof ThrottleMediator)) {
            this.handleException("Invalid Mediator has passed to serializer");
        }
        ThrottleMediator throttleMediator = (ThrottleMediator)m;
        OMElement throttle = fac.createOMElement("throttle", synNS);
        OMElement policy = fac.createOMElement("policy", synNS);
        String key = throttleMediator.getPolicyKey();
        if (key != null) {
            policy.addAttribute(fac.createOMAttribute("key", nullNS, key));
            throttle.addChild((OMNode)policy);
        } else {
            OMElement inlinePolicy = throttleMediator.getInLinePolicy();
            if (inlinePolicy != null) {
                policy.addChild((OMNode)inlinePolicy);
                throttle.addChild((OMNode)policy);
            }
        }
        ThrottleMediatorSerializer.saveTracingState((OMElement)throttle, (Mediator)throttleMediator);
        String id = throttleMediator.getId();
        if (id != null) {
            throttle.addAttribute(fac.createOMAttribute("id", nullNS, id));
        }
        if ((onReject = throttleMediator.getOnRejectSeqKey()) != null) {
            throttle.addAttribute(fac.createOMAttribute("onReject", nullNS, onReject));
        } else {
            Mediator mediator = throttleMediator.getOnRejectMediator();
            SequenceMediatorSerializer serializer = new SequenceMediatorSerializer();
            if (mediator != null && mediator instanceof SequenceMediator) {
                OMElement element = serializer.serializeAnonymousSequence(null, (SequenceMediator)mediator);
                element.setLocalName("onReject");
                throttle.addChild((OMNode)element);
            }
        }
        String onAccept = throttleMediator.getOnAcceptSeqKey();
        if (onAccept != null) {
            throttle.addAttribute(fac.createOMAttribute("onAccept", nullNS, onAccept));
        } else {
            Mediator mediator = throttleMediator.getOnAcceptMediator();
            SequenceMediatorSerializer serializer = new SequenceMediatorSerializer();
            if (mediator != null && mediator instanceof SequenceMediator) {
                OMElement element = serializer.serializeAnonymousSequence(null, (SequenceMediator)mediator);
                element.setLocalName("onAccept");
                throttle.addChild((OMNode)element);
            }
        }
        if (parent != null) {
            parent.addChild((OMNode)throttle);
        }
        return throttle;
    }

    public String getMediatorClassName() {
        return ThrottleMediator.class.getName();
    }
}

