/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.spring;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.mediators.spring.SpringMediator;

public class SpringMediatorFactory
extends AbstractMediatorFactory {
    private static final Log log = LogFactory.getLog(SpringMediatorFactory.class);
    private static final QName TAG_NAME = new QName("http://ws.apache.org/ns/synapse/spring", "spring");

    public Mediator createMediator(OMElement elem) {
        SpringMediator sm = new SpringMediator();
        OMAttribute bean = elem.getAttribute(new QName("", "bean"));
        OMAttribute key = elem.getAttribute(new QName("", "key"));
        if (bean == null) {
            this.handleException("The 'bean' attribute is required for a Spring mediator definition");
        } else if (key == null) {
            this.handleException("A 'key' attribute is required for a Spring mediator definition");
        } else {
            this.processTraceState((Mediator)sm, elem);
            sm.setBeanName(bean.getAttributeValue());
            sm.setConfigKey(key.getAttributeValue());
            return sm;
        }
        return null;
    }

    public QName getTagQName() {
        return TAG_NAME;
    }
}

