/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.spring;

import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.mediators.AbstractMediator;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class SpringMediator
extends AbstractMediator {
    private String beanName = null;
    private String configKey = null;
    private ApplicationContext appContext = null;

    public boolean mediate(MessageContext synCtx) {
        Entry entry;
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Spring mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if ((entry = synCtx.getConfiguration().getEntryDefinition(this.configKey)) != null && entry.isDynamic()) {
            if (!entry.isCached() || entry.isExpired()) {
                this.buildAppContext(synCtx, traceOrDebugOn, traceOn);
            }
        } else if (this.appContext == null) {
            this.buildAppContext(synCtx, traceOrDebugOn, traceOn);
        }
        if (this.appContext != null) {
            Object o = this.appContext.getBean(this.beanName);
            if (o != null && Mediator.class.isAssignableFrom(o.getClass())) {
                Mediator m = (Mediator)o;
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Loaded mediator from bean : " + this.beanName + " executing...");
                }
                return m.mediate(synCtx);
            }
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Unable to load mediator from bean : " + this.beanName);
            }
            this.handleException("Could not load bean named : " + this.beanName + " from the Spring configuration with key : " + this.configKey, synCtx);
        } else {
            this.handleException("Cannot reference application context with key : " + this.configKey, synCtx);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Spring mediator");
        }
        return true;
    }

    private synchronized void buildAppContext(MessageContext synCtx, boolean traceOrDebugOn, boolean traceOn) {
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Creating Spring ApplicationContext from key : " + this.configKey);
        }
        GenericApplicationContext appContext = new GenericApplicationContext();
        XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
        xbdr.setValidating(false);
        xbdr.loadBeanDefinitions((Resource)new InputStreamResource(SynapseConfigUtils.getStreamSource((Object)synCtx.getEntry(this.configKey)).getInputStream()));
        appContext.refresh();
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Spring ApplicationContext from key : " + this.configKey + " created");
        }
        this.appContext = appContext;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public ApplicationContext getAppContext() {
        return this.appContext;
    }

    public void setAppContext(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    public String getType() {
        return "SpringMediator";
    }
}

