/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.net.xmlrpc.RPCServer;
import groovy.net.xmlrpc.XMLRPCMessageProcessor;
import java.io.IOException;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import uk.co.wilson.net.MinMLJabberPacketServer;
import uk.co.wilson.net.MinMLThreadPool;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;
import uk.co.wilson.smackx.packet.JabberRPC;

public class JabberRPCServer
extends RPCServer {
    static final String startError = "<methodResponse>\n\t<fault>\n\t\t<value>\n\t\t\t<struct>\n\t\t\t\t<member>\n\t\t\t\t\t<name>faultCode</name>\n\t\t\t\t\t<value><int>";
    static final String middleError = "</int></value>\n\t\t\t\t</member>\n\t\t\t\t<member>\n\t\t\t\t\t<name>faultString</name>\n\t\t\t\t\t<value><string>";
    static final String endError = "</string></value>\n\t\t\t\t</member>\n\t\t\t</struct>\n\t\t</value>\n\t</fault>\n</methodResponse>\n";
    private XMPPConnection connection;
    private MinMLJabberPacketServer server = null;
    private final int minWorkers;
    private final int maxWorkers;
    private final int workerIdleLife;

    public JabberRPCServer(int minWorkers, int maxWorkers, int workerIdleLife) {
        this.minWorkers = minWorkers;
        this.maxWorkers = maxWorkers;
        this.workerIdleLife = workerIdleLife;
    }

    public JabberRPCServer() {
        this(2, 10, 60000);
    }

    public void startServer(XMPPConnection connection) throws IOException {
        this.connection = connection;
        this.connection.addConnectionListener(new ConnectionListener(){

            public void connectionClosed() {
                try {
                    JabberRPCServer.this.server.shutDown();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void connectionClosedOnError(Exception e) {
                try {
                    JabberRPCServer.this.server.shutDown();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.connection.sendPacket((Packet)new Presence(Presence.Type.AVAILABLE, "Jabber.RPC Server", 5, Presence.Mode.AVAILABLE));
        if (this.server != null) {
            this.stopServer();
        }
        this.server = new MinMLJabberPacketServer(connection.createPacketCollector(new PacketFilter(){

            public boolean accept(Packet packet) {
                return packet instanceof JabberRPC && ((JabberRPC)packet).getType() == IQ.Type.SET;
            }
        }), this.minWorkers, this.maxWorkers, this.workerIdleLife){

            protected MinMLThreadPool.Worker makeNewWorker() {
                return new MinMLJabberPacketServer.JabberPacketWorker(){

                    protected void process(Object resource) throws Exception {
                        JabberRPC request = (JabberRPC)((Object)resource);
                        StringBuffer buffer = new StringBuffer();
                        try {
                            XMLRPCMessageProcessor requestParser = new XMLRPCMessageProcessor();
                            requestParser.parseMessage(request.getChildElementXML());
                            String methodName = requestParser.getMethodname();
                            List params = requestParser.getParams();
                            Closure closure = (Closure)(this).JabberRPCServer.this.registeredMethods.get(methodName);
                            Object result = null;
                            if ((this).JabberRPCServer.this.preCallMethod != null) {
                                (this).JabberRPCServer.this.preCallMethod.call(new Object[]{methodName, params.toArray()});
                            }
                            if (closure == null) {
                                if ((this).JabberRPCServer.this.defaultMethod == null) {
                                    throw new GroovyRuntimeException("Method " + methodName + " is not supported on this server");
                                }
                                result = (this).JabberRPCServer.this.defaultMethod.call(new Object[]{methodName, params.toArray()});
                            } else {
                                result = closure.call(params.toArray());
                            }
                            if (result == null) {
                                result = new Integer(0);
                            }
                            if ((this).JabberRPCServer.this.postCallMethod != null) {
                                (this).JabberRPCServer.this.postCallMethod.call(new Object[]{methodName, result});
                            }
                            XMLRPCMessageProcessor.emitResult(buffer, result);
                            this.sendResponse(request, buffer.toString());
                        }
                        catch (Throwable e) {
                            int codeValue;
                            String message;
                            if (e instanceof InvokerInvocationException) {
                                e = ((InvokerInvocationException)e).getCause();
                            }
                            if (e instanceof XMLRPCFailException) {
                                message = ((XMLRPCFailException)e).getFaultString();
                                codeValue = ((XMLRPCFailException)e).getFaultCode();
                            } else {
                                message = e.getMessage();
                                codeValue = 0;
                            }
                            if ((this).JabberRPCServer.this.faultMethod != null) {
                                try {
                                    (this).JabberRPCServer.this.faultMethod.call(new Object[]{message, new Integer(codeValue)});
                                }
                                catch (Throwable e1) {
                                    // empty catch block
                                }
                            }
                            buffer.setLength(0);
                            buffer.append(JabberRPCServer.startError);
                            buffer.append(String.valueOf(codeValue));
                            buffer.append(JabberRPCServer.middleError);
                            buffer.append(message == null ? e.getClass().getName() : message);
                            buffer.append(JabberRPCServer.endError);
                            this.sendResponse(request, buffer.toString());
                        }
                    }

                    private void sendResponse(JabberRPC request, String response) {
                        JabberRPC responsePacket = new JabberRPC(response.toString());
                        responsePacket.setFrom(request.getTo());
                        responsePacket.setTo(request.getFrom());
                        responsePacket.setPacketID(request.getPacketID());
                        responsePacket.setType(IQ.Type.RESULT);
                        JabberRPCServer.this.connection.sendPacket((Packet)responsePacket);
                    }
                };
            }
        };
        Thread startingThread = new Thread(){

            public void run() {
                JabberRPCServer.this.server.start();
            }
        };
        startingThread.setDaemon(false);
        startingThread.setName("Jabber-RPC Server main thread");
        startingThread.start();
    }

    public void stopServer() throws IOException {
        this.server.shutDown();
    }
}

