/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.File;
import java.net.URL;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.synapse.util.UUIDGenerator;
import samples.common.StockQuoteHandler;

public class StockQuoteClient {
    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            StockQuoteClient.executeClient();
            if ("placeorder".equals(InnerStruct.MODE)) {
                System.out.println("Order placed for " + InnerStruct.QUANTITY + " shares of stock " + InnerStruct.SYMBOL + " at a price of $ " + InnerStruct.PRICE);
            } else if ("customquote".equals(InnerStruct.MODE)) {
                System.out.println("Custom :: Stock price = $" + StockQuoteHandler.parseCustomQuoteResponse(InnerStruct.RESULT));
            } else if ("quote".equals(InnerStruct.MODE)) {
                System.out.println("Standard :: Stock price = $" + StockQuoteHandler.parseStandardQuoteResponse(InnerStruct.RESULT));
            } else if ("fullquote".equals(InnerStruct.MODE)) {
                System.out.println("Full :: Average price = $" + StockQuoteHandler.parseFullQuoteResponse(InnerStruct.RESULT));
            } else if ("marketactivity".equals(InnerStruct.MODE)) {
                System.out.println("Activity :: Average price = $" + StockQuoteHandler.parseMarketActivityResponse(InnerStruct.RESULT));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static OMElement executeTestClient() throws Exception {
        StockQuoteClient.executeClient();
        return InnerStruct.RESULT;
    }

    public static void executeClient() throws Exception {
        String symbol = StockQuoteClient.getProperty("symbol", "IBM");
        String mode = StockQuoteClient.getProperty("mode", "quote");
        String addUrl = StockQuoteClient.getProperty("addurl", null);
        String trpUrl = StockQuoteClient.getProperty("trpurl", null);
        String prxUrl = StockQuoteClient.getProperty("prxurl", null);
        String repo = StockQuoteClient.getProperty("repository", "client_repo");
        String svcPolicy = StockQuoteClient.getProperty("policy", null);
        String rest = StockQuoteClient.getProperty("rest", null);
        String wsrm = StockQuoteClient.getProperty("wsrm", null);
        String itr = StockQuoteClient.getProperty("itr", "1");
        double price = 0.0;
        int quantity = 0;
        ConfigurationContext configContext = null;
        Options options = new Options();
        OMElement payload = null;
        ServiceClient serviceClient = null;
        if (repo != null && !"null".equals(repo)) {
            configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repo, (String)(repo + File.separator + "conf" + File.separator + "axis2.xml"));
            serviceClient = new ServiceClient(configContext, null);
        } else {
            serviceClient = new ServiceClient();
        }
        if ("customquote".equals(mode)) {
            payload = StockQuoteHandler.createCustomQuoteRequest(symbol);
            options.setAction("urn:getQuote");
        } else if ("fullquote".equals(mode)) {
            payload = StockQuoteHandler.createFullQuoteRequest(symbol);
            options.setAction("urn:getFullQuote");
        } else if ("placeorder".equals(mode)) {
            price = StockQuoteClient.getRandom(100.0, 0.9, true);
            quantity = (int)StockQuoteClient.getRandom(10000.0, 1.0, true);
            payload = StockQuoteHandler.createPlaceOrderRequest(price, quantity, symbol);
            options.setAction("urn:placeOrder");
        } else if ("marketactivity".equals(mode)) {
            payload = StockQuoteHandler.createMarketActivityRequest();
            options.setAction("urn:getMarketActivity");
        } else if ("quote".equals(mode)) {
            payload = StockQuoteHandler.createStandardQuoteRequest(symbol, Integer.parseInt(itr));
            options.setAction("urn:getQuote");
        }
        if (addUrl != null && !"null".equals(addUrl)) {
            serviceClient.engageModule("addressing");
            options.setTo(new EndpointReference(addUrl));
        }
        if (trpUrl != null && !"null".equals(trpUrl)) {
            options.setProperty("TransportURL", (Object)trpUrl);
        }
        if (prxUrl != null && !"null".equals(prxUrl)) {
            HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
            URL url = new URL(prxUrl);
            proxyProperties.setProxyName(url.getHost());
            proxyProperties.setProxyPort(url.getPort());
            proxyProperties.setUserName("");
            proxyProperties.setPassWord("");
            proxyProperties.setDomain("");
            options.setProperty("PROXY", (Object)proxyProperties);
        }
        if (svcPolicy != null && !"null".equals(svcPolicy) && svcPolicy.length() > 0) {
            System.out.println("Using WS-Security");
            serviceClient.engageModule("addressing");
            serviceClient.engageModule("rampart");
            options.setProperty("rampartPolicy", (Object)StockQuoteClient.loadPolicy(svcPolicy));
        }
        if (Boolean.parseBoolean(rest)) {
            System.out.println("Sending as REST");
            options.setProperty("enableREST", (Object)"true");
        }
        if (Boolean.parseBoolean(wsrm)) {
            System.out.println("Using WS-RM");
            serviceClient.engageModule("sandesha2");
            options.setProperty("Sandesha2LastMessage", (Object)"true");
            options.setProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID, (Object)UUIDGenerator.getUUID());
        }
        serviceClient.setOptions(options);
        InnerStruct.MODE = mode;
        InnerStruct.SYMBOL = symbol;
        InnerStruct.PRICE = price;
        InnerStruct.QUANTITY = quantity;
        if ("placeorder".equals(mode)) {
            serviceClient.fireAndForget(payload);
            Thread.sleep(5000L);
        } else {
            OMElement result;
            InnerStruct.RESULT = result = serviceClient.sendReceive(payload);
            if (Boolean.parseBoolean(wsrm)) {
                Thread.sleep(5000L);
                if (configContext != null) {
                    configContext.getListenerManager().stop();
                }
                serviceClient.cleanup();
                System.exit(0);
            }
        }
        try {
            if (configContext != null) {
                configContext.terminate();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    private static Policy loadPolicy(String xmlPath) throws Exception {
        StAXOMBuilder builder = new StAXOMBuilder(xmlPath);
        return PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
    }

    private static double getRandom(double base, double varience, boolean onlypositive) {
        double rand = Math.random();
        return (base + (double)(rand > 0.5 ? 1 : -1) * varience * base * rand) * (double)(onlypositive ? 1 : (rand > 0.5 ? 1 : -1));
    }

    private static class InnerStruct {
        static String MODE = null;
        static String SYMBOL = null;
        static int QUANTITY = 0;
        static double PRICE = 0.0;
        static OMElement RESULT = null;

        private InnerStruct() {
        }
    }
}

