/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.RequestBlockingHandler;
import org.apache.axis2.clustering.configuration.ConfigurationManager;
import org.apache.axis2.clustering.configuration.DefaultConfigurationManager;
import org.apache.axis2.clustering.context.ClusteringContextListener;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.clustering.context.DefaultContextManager;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.clustering.control.GetConfigurationCommand;
import org.apache.axis2.clustering.control.GetStateCommand;
import org.apache.axis2.clustering.tribes.ChannelListener;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.TribesControlCommandProcessor;
import org.apache.axis2.clustering.tribes.TribesMembershipListener;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextListener;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DispatchPhase;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ManagedChannel;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.interceptors.DomainFilterInterceptor;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.tribes.transport.ReceiverBase;
import org.apache.catalina.tribes.transport.ReplicationTransmitter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TribesClusterManager
implements ClusterManager {
    private static final Log log = LogFactory.getLog((Class)TribesClusterManager.class);
    private DefaultConfigurationManager configurationManager;
    private DefaultContextManager contextManager;
    private HashMap parameters = new HashMap();
    private ManagedChannel channel;
    private ConfigurationContext configurationContext;
    private TribesControlCommandProcessor controlCmdProcessor = new TribesControlCommandProcessor(this.configurationContext);
    private ChannelListener channelListener;
    private ChannelSender channelSender;

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public void init() throws ClusteringFault {
        Parameter domainParam;
        HandlerDescription handlerDesc;
        PhaseRule rule;
        RequestBlockingHandler requestBlockingHandler;
        Phase phase;
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        Iterator iterator = axisConfig.getInFlowPhases().iterator();
        while (iterator.hasNext()) {
            phase = (Phase)iterator.next();
            if (!(phase instanceof DispatchPhase)) continue;
            requestBlockingHandler = new RequestBlockingHandler();
            if (phase.getHandlers().contains(requestBlockingHandler)) break;
            rule = new PhaseRule("Dispatch");
            rule.setAfter("SOAPMessageBodyBasedDispatcher");
            rule.setBefore("InstanceDispatcher");
            handlerDesc = requestBlockingHandler.getHandlerDesc();
            handlerDesc.setHandler((Handler)requestBlockingHandler);
            handlerDesc.setName("RequestBlockingHandler");
            handlerDesc.setRules(rule);
            phase.addHandler((Handler)requestBlockingHandler);
            break;
        }
        iterator = axisConfig.getInFaultFlowPhases().iterator();
        while (iterator.hasNext()) {
            phase = (Phase)iterator.next();
            if (!(phase instanceof DispatchPhase)) continue;
            requestBlockingHandler = new RequestBlockingHandler();
            if (phase.getHandlers().contains(requestBlockingHandler)) continue;
            rule = new PhaseRule("Dispatch");
            rule.setAfter("SOAPMessageBodyBasedDispatcher");
            rule.setBefore("InstanceDispatcher");
            handlerDesc = requestBlockingHandler.getHandlerDesc();
            handlerDesc.setHandler((Handler)requestBlockingHandler);
            handlerDesc.setName("RequestBlockingHandler");
            handlerDesc.setRules(rule);
            phase.addHandler((Handler)requestBlockingHandler);
            break;
        }
        this.channelSender = new ChannelSender();
        this.channelListener = new ChannelListener(this.configurationContext, this.configurationManager, this.contextManager, this.controlCmdProcessor, this.channelSender, this.synchronizeAllMembers());
        this.controlCmdProcessor.setChannelSender(this.channelSender);
        this.channel = new GroupChannel();
        Parameter maxRetriesParam = this.getParameter("maxRetries");
        int maxRetries = 10;
        if (maxRetriesParam != null) {
            maxRetries = Integer.parseInt((String)maxRetriesParam.getValue());
        }
        ((ReplicationTransmitter)this.channel.getChannelSender()).getTransport().setMaxRetryAttempts(maxRetries);
        String localIP = System.getProperty("axis2.local.ip.address");
        if (localIP != null) {
            ReceiverBase receiver = (ReceiverBase)this.channel.getChannelReceiver();
            receiver.setAddress(localIP);
        }
        byte[] domain = (domainParam = this.getParameter("domain")) != null ? ((String)domainParam.getValue()).getBytes() : "apache.axis2.domain".getBytes();
        this.channel.getMembershipService().setDomain(domain);
        DomainFilterInterceptor dfi = new DomainFilterInterceptor();
        dfi.setDomain(domain);
        this.channel.addInterceptor((ChannelInterceptor)dfi);
        TcpFailureDetector tcpFailureDetector = new TcpFailureDetector();
        tcpFailureDetector.setPrevious((ChannelInterceptor)dfi);
        this.channel.addInterceptor((ChannelInterceptor)tcpFailureDetector);
        this.channel.addChannelListener((org.apache.catalina.tribes.ChannelListener)this.channelListener);
        TribesMembershipListener membershipListener = new TribesMembershipListener();
        this.channel.addMembershipListener((MembershipListener)membershipListener);
        try {
            this.channel.start(15);
            String localHost = TribesUtil.getLocalHost((Channel)this.channel);
            if (localHost.startsWith("127.0.")) {
                this.channel.stop(15);
                throw new ClusteringFault("Cannot join cluster using IP " + localHost + ". Please set an IP address other than " + localHost + " in your /etc/hosts file or set the " + "axis2.local.ip.address" + " System property and retry.");
            }
        }
        catch (ChannelException e) {
            throw new ClusteringFault("Error starting Tribes channel", (Exception)((Object)e));
        }
        this.channelSender.setChannel((Channel)this.channel);
        log.info((Object)("Local Tribes Member " + TribesUtil.getLocalHost((Channel)this.channel)));
        TribesUtil.printMembers();
        if (this.configurationManager != null) {
            this.configurationManager.setSender(this.channelSender);
            this.getInitializationMessage(this.channelSender, new GetConfigurationCommand());
        }
        if (this.contextManager != null) {
            this.contextManager.setSender(this.channelSender);
            this.channelListener.setContextManager(this.contextManager);
            this.getInitializationMessage(this.channelSender, new GetStateCommand());
            ClusteringContextListener contextListener = new ClusteringContextListener(this.channelSender);
            this.configurationContext.addContextListener((ContextListener)contextListener);
        }
        this.configurationContext.setNonReplicableProperty("local_cluster.initialized", (Object)"true");
    }

    private void getInitializationMessage(ChannelSender sender, ControlCommand command) {
        ArrayList<String> sentMembersList = new ArrayList<String>();
        sentMembersList.add(TribesUtil.getLocalHost((Channel)this.channel));
        Member[] members = MembershipManager.getMembers();
        for (int numberOfTries = 0; members.length > 0 && this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") == null && numberOfTries < 50; ++numberOfTries) {
            block3: {
                try {
                    Member member;
                    Member member2 = member = numberOfTries == 0 ? MembershipManager.getLongestLivingMember() : MembershipManager.getRandomMember();
                    if (sentMembersList.contains(TribesUtil.getHost(member))) break block3;
                    sender.sendToMember(command, member);
                    sentMembersList.add(TribesUtil.getHost(member));
                    log.debug((Object)"WAITING FOR INITIALIZATION MESSAGE...");
                    Thread.sleep(10 * (numberOfTries + 1));
                }
                catch (Exception e) {
                    log.error((Object)"Cannot get initialization information", (Throwable)e);
                    break;
                }
            }
            members = MembershipManager.getMembers();
        }
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = (DefaultConfigurationManager)configurationManager;
        this.configurationManager.setSender(this.channelSender);
    }

    public void setContextManager(ContextManager contextManager) {
        this.contextManager = (DefaultContextManager)contextManager;
        this.contextManager.setSender(this.channelSender);
    }

    public void addParameter(Parameter param) throws AxisFault {
        this.parameters.put(param.getName(), param);
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        throw new UnsupportedOperationException();
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.parameters.get(name);
    }

    public ArrayList getParameters() {
        ArrayList list = new ArrayList();
        Iterator it = this.parameters.keySet().iterator();
        while (it.hasNext()) {
            list.add(this.parameters.get(it.next()));
        }
        return list;
    }

    public boolean isParameterLocked(String parameterName) {
        Parameter parameter = (Parameter)this.parameters.get(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameters.remove(param.getName());
    }

    public void shutdown() throws ClusteringFault {
        log.debug((Object)"Enter: TribesClusterManager::shutdown");
        if (this.channel != null) {
            try {
                this.channel.stop(15);
            }
            catch (ChannelException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: TribesClusterManager::shutdown");
                }
                throw new ClusteringFault((Exception)((Object)e));
            }
        }
        log.debug((Object)"Exit: TribesClusterManager::shutdown");
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        this.controlCmdProcessor.setConfigurationContext(configurationContext);
        if (this.channelListener != null) {
            this.channelListener.setConfigurationContext(configurationContext);
        }
        if (this.configurationManager != null) {
            this.configurationManager.setConfigurationContext(configurationContext);
        }
        if (this.contextManager != null) {
            this.contextManager.setConfigurationContext(configurationContext);
        }
    }

    public boolean synchronizeAllMembers() {
        Parameter syncAllParam = this.getParameter("synchronizeAll");
        return syncAllParam == null || Boolean.parseBoolean((String)syncAllParam.getValue());
    }
}

