/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileSystemException;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.vfs.VFSOutTransportInfo;

public class VFSUtils
extends BaseUtils {
    private static final Log log = LogFactory.getLog(VFSUtils.class);
    private static BaseUtils _instance = new VFSUtils();

    public static BaseUtils getInstace() {
        return _instance;
    }

    public String getProperty(Object message, String property) {
        try {
            Object o = ((FileContent)message).getAttributes().get(property);
            if (o instanceof String) {
                return (String)o;
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return null;
    }

    public InputStream getInputStream(Object message) {
        try {
            return ((FileContent)message).getInputStream();
        }
        catch (FileSystemException e) {
            VFSUtils.handleException("Error creating an input stream to : " + ((FileContent)message).getFile().getName(), (Exception)((Object)e));
            return null;
        }
    }

    public String getMessageTextPayload(Object message) {
        try {
            return new String(VFSUtils.getBytesFromInputStream(this.getInputStream(message), (int)((FileContent)message).getSize()));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error reading message payload as text for : " + ((FileContent)message).getFile().getName()), (Throwable)e);
            }
            return null;
        }
    }

    public byte[] getMessageBinaryPayload(Object message) {
        try {
            return VFSUtils.getBytesFromInputStream(this.getInputStream(message), (int)((FileContent)message).getSize());
        }
        catch (Exception e) {
            VFSUtils.handleException("Error reading message payload as a byte[] for : " + ((FileContent)message).getFile().getName(), e);
            return new byte[0];
        }
    }

    public static String getFileName(MessageContext msgCtx, VFSOutTransportInfo vfsOutInfo) {
        Parameter param;
        String fileName = null;
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (transportHeaders != null) {
            fileName = (String)transportHeaders.get("transport.vfs.ReplyFileName");
        }
        if (fileName == null && (param = msgCtx.getAxisService().getParameter("transport.vfs.ReplyFileName")) != null) {
            fileName = (String)param.getValue();
        }
        if (fileName == null) {
            fileName = vfsOutInfo.getOutFileName();
        }
        if (fileName == null) {
            fileName = "response.xml";
        }
        return fileName;
    }

    public static int getMaxRetryCount(MessageContext msgCtx, VFSOutTransportInfo vfsOutInfo) {
        if (vfsOutInfo.getMaxRetryCount() != 0) {
            return vfsOutInfo.getMaxRetryCount();
        }
        return 3;
    }

    public static long getReconnectTimout(MessageContext msgCtx, VFSOutTransportInfo vfsOutInfo) {
        if (vfsOutInfo.getReconnectTimeout() != 0L) {
            return vfsOutInfo.getReconnectTimeout();
        }
        return 30000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromInputStream(InputStream is, int length) throws IOException {
        byte[] bytes = new byte[length];
        int numRead = 0;
        try {
            int offset;
            for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                VFSUtils.handleException("Could not completely read the stream to conver to a byte[]");
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignore) {}
        }
        return bytes;
    }
}

